/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.datasheet.indexer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.smartmdsd.datasheet.indexer.DatasheetProjectSettings;

public class WorkspaceDatasheetIndexer {
    private Map<String, DatasheetProjectSettings> index = new HashMap<String, DatasheetProjectSettings>();
    private static WorkspaceDatasheetIndexer instance;

    public static WorkspaceDatasheetIndexer getInstance() {
        if (instance == null) {
            instance = new WorkspaceDatasheetIndexer();
        }
        return instance;
    }

    public void reloadWorkspaceMetadataIndex() {
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            this.updateProjectIndex(project);
            ++n2;
        }
        this.index.values().removeIf(value -> !value.isValid());
    }

    public void updateProjectIndex(IProject project) {
        String projectName = project.getName();
        if (project.isAccessible()) {
            if (!this.index.containsKey(projectName)) {
                this.index.put(projectName, new DatasheetProjectSettings(project));
            }
        } else if (this.index.containsKey(projectName)) {
            this.index.remove(projectName);
        }
    }

    public void clearWorkspaceMetadataIndex() {
        this.index.clear();
    }

    public Set<String> getAllIndexedPropertyNames() {
        HashSet<String> unique_property_names = new HashSet<String>();
        for (DatasheetProjectSettings metadata : this.index.values()) {
            if (!metadata.isValid()) continue;
            unique_property_names.addAll(metadata.getAllPropertyNames());
        }
        return unique_property_names;
    }

    public Set<String> getAllMatchingPropertyValues(String propertyName) {
        HashSet<String> all_values = new HashSet<String>();
        for (DatasheetProjectSettings metadata : this.index.values()) {
            if (!metadata.isValid()) continue;
            all_values.addAll(metadata.getAllPropertyValues(propertyName));
        }
        return all_values;
    }

    public Set<String> getAllMatchingPropertyUnits(String propertyName) {
        HashSet<String> all_units = new HashSet<String>();
        for (DatasheetProjectSettings metadata : this.index.values()) {
            if (!metadata.isValid()) continue;
            all_units.addAll(metadata.getAllPropertyUnits(propertyName));
        }
        return all_units;
    }

    public Set<String> getAllMatchingPropertySemanticURIs(String propertyName) {
        HashSet<String> all_uris = new HashSet<String>();
        for (DatasheetProjectSettings metadata : this.index.values()) {
            if (!metadata.isValid()) continue;
            all_uris.addAll(metadata.getAllPropertySemanticURIs(propertyName));
        }
        return all_uris;
    }

    public DatasheetProjectSettings getDatasheetProjectSettings(String projectName) {
        IProject project;
        DatasheetProjectSettings metadata = this.index.get(projectName);
        if (metadata == null && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)).exists() && project.isOpen()) {
            metadata = this.index.put(projectName, new DatasheetProjectSettings(project));
        }
        return metadata;
    }

    public DatasheetProjectSettings getDatasheetSettingsFor(IProject project) {
        DatasheetProjectSettings metadata = null;
        if (project != null && project.isAccessible() && (metadata = this.index.get(project.getName())) == null) {
            metadata = this.index.put(project.getName(), new DatasheetProjectSettings(project));
        }
        return metadata;
    }
}

