/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.ecore.base.basicAttributes;

import com.google.common.base.Objects;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.xbase.lib.CollectionExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@SuppressWarnings("all")
public class BasicAttributesModelUtility {
  public String getValueString(final AbstractValue av) {
    String _switchResult = null;
    boolean _matched = false;
    if (av instanceof IntValue) {
      _matched=true;
      _switchResult = Integer.valueOf(((IntValue)av).getValue()).toString();
    }
    if (!_matched) {
      if (av instanceof FloatingPointValue) {
        _matched=true;
        _switchResult = Double.valueOf(((FloatingPointValue)av).getValue()).toString();
      }
    }
    if (!_matched) {
      if (av instanceof StringValue) {
        _matched=true;
        String _value = ((StringValue)av).getValue();
        String _plus = ("\"" + _value);
        _switchResult = (_plus + "\"");
      }
    }
    if (!_matched) {
      if (av instanceof BoolValue) {
        _matched=true;
        _switchResult = Boolean.valueOf(((BoolValue)av).isValue()).toString();
      }
    }
    if (!_matched) {
      if (av instanceof EnumerationValue) {
        _matched=true;
        _switchResult = ((EnumerationValue)av).getValue().getName();
      }
    }
    if (!_matched) {
      if (av instanceof ArrayValue) {
        _matched=true;
        EList<SingleValue> _values = ((ArrayValue)av).getValues();
        List<String> _map = null;
        if (_values!=null) {
          final Function1<SingleValue, String> _function = (SingleValue it) -> {
            return this.getValueString(it);
          };
          _map=ListExtensions.<SingleValue, String>map(_values, _function);
        }
        String _join = IterableExtensions.join(_map, ", ");
        String _plus = ("[" + _join);
        _switchResult = (_plus + "]");
      }
    }
    return _switchResult;
  }
  
  public Iterable<String> getDefaultValuesFor(final AbstractAttributeType type) {
    List<String> textList = CollectionLiterals.<String>newArrayList();
    if ((type instanceof PrimitiveType)) {
      PRIMITIVE_TYPE_NAME _typeName = ((PrimitiveType)type).getTypeName();
      boolean _matched = false;
      PRIMITIVE_TYPE_NAME _typeName_1 = ((PrimitiveType)type).getTypeName();
      boolean _lessEqualsThan = (_typeName_1.compareTo(PRIMITIVE_TYPE_NAME.INT64) <= 0);
      if (_lessEqualsThan) {
        _matched=true;
        textList.add("0");
      }
      if (!_matched) {
        PRIMITIVE_TYPE_NAME _typeName_2 = ((PrimitiveType)type).getTypeName();
        boolean _equals = Objects.equal(_typeName_2, PRIMITIVE_TYPE_NAME.FLOAT);
        if (_equals) {
          _matched=true;
          textList.add("1.0");
        }
      }
      if (!_matched) {
        PRIMITIVE_TYPE_NAME _typeName_3 = ((PrimitiveType)type).getTypeName();
        boolean _equals_1 = Objects.equal(_typeName_3, PRIMITIVE_TYPE_NAME.DOUBLE);
        if (_equals_1) {
          _matched=true;
          CollectionExtensions.<String>addAll(textList, "1.0", "0");
        }
      }
      if (!_matched) {
        PRIMITIVE_TYPE_NAME _typeName_4 = ((PrimitiveType)type).getTypeName();
        boolean _equals_2 = Objects.equal(_typeName_4, PRIMITIVE_TYPE_NAME.STRING);
        if (_equals_2) {
          _matched=true;
          textList.add("\"Text\"");
        }
      }
      if (!_matched) {
        PRIMITIVE_TYPE_NAME _typeName_5 = ((PrimitiveType)type).getTypeName();
        boolean _equals_3 = Objects.equal(_typeName_5, PRIMITIVE_TYPE_NAME.BOOLEAN);
        if (_equals_3) {
          _matched=true;
          CollectionExtensions.<String>addAll(textList, "true", "false");
        }
      }
    } else {
      if ((type instanceof InlineEnumerationType)) {
        EList<EnumerationElement> _enums = ((InlineEnumerationType)type).getEnums();
        for (final EnumerationElement en : _enums) {
          textList.add(en.getName());
        }
      }
    }
    return textList;
  }
  
  public String getTypeName(final AbstractAttributeType attrType) {
    String _switchResult = null;
    boolean _matched = false;
    if (attrType instanceof PrimitiveType) {
      _matched=true;
      _switchResult = ((PrimitiveType)attrType).getTypeName().getLiteral();
    }
    if (!_matched) {
      if (attrType instanceof InlineEnumerationType) {
        _matched=true;
        _switchResult = "InlineEnumeration";
      }
    }
    return _switchResult;
  }
  
  public boolean isOctetType(final AbstractAttributeType attrType) {
    boolean _switchResult = false;
    boolean _matched = false;
    if (attrType instanceof PrimitiveType) {
      PRIMITIVE_TYPE_NAME _typeName = ((PrimitiveType)attrType).getTypeName();
      boolean _equals = Objects.equal(_typeName, PRIMITIVE_TYPE_NAME.UINT8);
      if (_equals) {
        _matched=true;
        _switchResult = true;
      }
    }
    if (!_matched) {
      _switchResult = false;
    }
    return _switchResult;
  }
  
  public boolean isRealType(final AbstractAttributeType attrType) {
    boolean _switchResult = false;
    boolean _matched = false;
    if (attrType instanceof PrimitiveType) {
      PRIMITIVE_TYPE_NAME _typeName = ((PrimitiveType)attrType).getTypeName();
      boolean _equals = Objects.equal(_typeName, PRIMITIVE_TYPE_NAME.FLOAT);
      if (_equals) {
        _matched=true;
        _switchResult = true;
      }
    }
    if (!_matched) {
      if (attrType instanceof PrimitiveType) {
        PRIMITIVE_TYPE_NAME _typeName = ((PrimitiveType)attrType).getTypeName();
        boolean _equals = Objects.equal(_typeName, PRIMITIVE_TYPE_NAME.DOUBLE);
        if (_equals) {
          _matched=true;
          _switchResult = true;
        }
      }
    }
    if (!_matched) {
      _switchResult = false;
    }
    return _switchResult;
  }
  
  public boolean isBooleanType(final AbstractAttributeType attrType) {
    boolean _switchResult = false;
    boolean _matched = false;
    if (attrType instanceof PrimitiveType) {
      PRIMITIVE_TYPE_NAME _typeName = ((PrimitiveType)attrType).getTypeName();
      boolean _equals = Objects.equal(_typeName, PRIMITIVE_TYPE_NAME.BOOLEAN);
      if (_equals) {
        _matched=true;
        _switchResult = true;
      }
    }
    if (!_matched) {
      _switchResult = false;
    }
    return _switchResult;
  }
  
  public boolean isStringType(final AbstractAttributeType attrType) {
    boolean _switchResult = false;
    boolean _matched = false;
    if (attrType instanceof PrimitiveType) {
      PRIMITIVE_TYPE_NAME _typeName = ((PrimitiveType)attrType).getTypeName();
      boolean _equals = Objects.equal(_typeName, PRIMITIVE_TYPE_NAME.STRING);
      if (_equals) {
        _matched=true;
        _switchResult = true;
      }
    }
    if (!_matched) {
      _switchResult = false;
    }
    return _switchResult;
  }
  
  public boolean isLonglongType(final AbstractAttributeType attrType) {
    boolean _switchResult = false;
    boolean _matched = false;
    if (attrType instanceof PrimitiveType) {
      PRIMITIVE_TYPE_NAME _typeName = ((PrimitiveType)attrType).getTypeName();
      boolean _equals = Objects.equal(_typeName, PRIMITIVE_TYPE_NAME.INT64);
      if (_equals) {
        _matched=true;
        _switchResult = true;
      }
    }
    if (!_matched) {
      if (attrType instanceof PrimitiveType) {
        PRIMITIVE_TYPE_NAME _typeName = ((PrimitiveType)attrType).getTypeName();
        boolean _equals = Objects.equal(_typeName, PRIMITIVE_TYPE_NAME.UINT64);
        if (_equals) {
          _matched=true;
          _switchResult = true;
        }
      }
    }
    if (!_matched) {
      _switchResult = false;
    }
    return _switchResult;
  }
  
  public Boolean isArrayType(final AttributeDefinition attr) {
    ArrayType _array = attr.getType().getArray();
    return Boolean.valueOf((_array != null));
  }
  
  public Boolean haveEnums(final Collection<AttributeDefinition> attributes) {
    final Function1<AttributeDefinition, Boolean> _function = (AttributeDefinition it) -> {
      AbstractAttributeType _type = it.getType();
      return Boolean.valueOf((_type instanceof InlineEnumerationType));
    };
    return Boolean.valueOf(IterableExtensions.<AttributeDefinition>exists(attributes, _function));
  }
}
