/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ecore.base.basicAttributes;

import com.google.common.base.Objects;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractAttributeType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.ArrayType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.ArrayValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.BasicAttributesFactory;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.BoolValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.EnumerationElement;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.EnumerationValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.FloatingPointValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.InlineEnumerationType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.IntValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.PRIMITIVE_TYPE_NAME;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.PrimitiveType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.SingleValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.StringValue;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class BasicAttributesTypeConformance {
    public static final String IMLICIT_DEFAULT_ENUM = "ENUM_VALUE_UNDEFINED";
    public static final List<String> cppKeywords = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"alignas", "alignof", "and", "and_eq", "asm", "auto", "bitand", "bitor", "bool", "break", "case", "catch", "char", "char16_t", "char32_t", "class", "compl", "const", "constexpr", "const_cast", "continue", "decltype", "default", "delete", "do", "double", "dynamic_cast", "else", "enum", "explicit", "export", "extern", "false", "float", "for", "friend", "goto", "if", "inline", "int", "long", "mutable", "namespace", "new", "noexcept", "not", "not_eq", "nullptr", "operator", "or", "or_eq", "private", "protected", "public", "register", "reinterpret_cast", "return", "short", "signed", "sizeof", "static", "static_assert", "static_cast", "struct", "switch", "template", "this", "thread_local", "throw", "true", "try", "typedef", "typeid", "typename", "union", "unsigned", "using", "virtual", "void", "volatile", "wchar_t", "while", "xor", "xor_eq"}));

    public AbstractValue createPrimitiveDefaultValue(AbstractAttributeType attrType) {
        boolean _tripleNotEquals;
        SingleValue value = null;
        if (attrType instanceof PrimitiveType) {
            boolean _lessEqualsThan;
            PRIMITIVE_TYPE_NAME typeName = ((PrimitiveType)attrType).getTypeName();
            boolean bl = _lessEqualsThan = typeName.compareTo(PRIMITIVE_TYPE_NAME.INT64) <= 0;
            if (_lessEqualsThan) {
                IntValue intVal = BasicAttributesFactory.eINSTANCE.createIntValue();
                intVal.setValue(0);
                value = intVal;
            } else {
                boolean _lessEqualsThan_1;
                boolean bl2 = _lessEqualsThan_1 = typeName.compareTo(PRIMITIVE_TYPE_NAME.DOUBLE) <= 0;
                if (_lessEqualsThan_1) {
                    FloatingPointValue dblVal = BasicAttributesFactory.eINSTANCE.createFloatingPointValue();
                    dblVal.setValue(0.0);
                    value = dblVal;
                } else {
                    boolean _equals = Objects.equal((Object)((Object)typeName), (Object)((Object)PRIMITIVE_TYPE_NAME.STRING));
                    if (_equals) {
                        StringValue strVal = BasicAttributesFactory.eINSTANCE.createStringValue();
                        strVal.setValue("Text");
                        value = strVal;
                    } else {
                        boolean _equals_1 = Objects.equal((Object)((Object)typeName), (Object)((Object)PRIMITIVE_TYPE_NAME.BOOLEAN));
                        if (_equals_1) {
                            BoolValue boolVal = BasicAttributesFactory.eINSTANCE.createBoolValue();
                            boolVal.setValue(false);
                            value = boolVal;
                        }
                    }
                }
            }
        } else if (attrType instanceof InlineEnumerationType) {
            EnumerationValue en = BasicAttributesFactory.eINSTANCE.createEnumerationValue();
            en.setValue((EnumerationElement)IterableExtensions.head(((InlineEnumerationType)attrType).getEnums()));
            value = en;
        }
        ArrayType _array = attrType.getArray();
        boolean bl = _tripleNotEquals = _array != null;
        if (_tripleNotEquals) {
            ArrayValue arrayValue = BasicAttributesFactory.eINSTANCE.createArrayValue();
            if (value != null) {
                arrayValue.getValues().add((Object)value);
            }
            return arrayValue;
        }
        return value;
    }

    public boolean isCompatible(AbstractValue av, AbstractAttributeType attrType) {
        boolean _tripleNotEquals;
        ArrayType _array = attrType.getArray();
        boolean bl = _tripleNotEquals = _array != null;
        if (_tripleNotEquals) {
            if (av instanceof ArrayValue) {
                return true;
            }
            EObject _eContainer = av.eContainer();
            if (_eContainer instanceof ArrayValue) {
                return this.checkCompatibility(attrType, av);
            }
        } else {
            return this.checkCompatibility(attrType, av);
        }
        return false;
    }

    protected boolean checkCompatibility(AbstractAttributeType attrType, AbstractValue av) {
        boolean compatible = false;
        if (attrType instanceof PrimitiveType) {
            boolean _lessEqualsThan;
            PRIMITIVE_TYPE_NAME typeName = ((PrimitiveType)attrType).getTypeName();
            boolean bl = _lessEqualsThan = typeName.compareTo(PRIMITIVE_TYPE_NAME.UINT64) <= 0;
            if (_lessEqualsThan) {
                if (av instanceof IntValue) {
                    boolean _greaterEqualsThan;
                    int _value = ((IntValue)av).getValue();
                    compatible = _greaterEqualsThan = _value >= 0;
                }
            } else {
                boolean _lessEqualsThan_1;
                boolean bl2 = _lessEqualsThan_1 = typeName.compareTo(PRIMITIVE_TYPE_NAME.INT64) <= 0;
                if (_lessEqualsThan_1) {
                    compatible = av instanceof IntValue;
                } else {
                    boolean _lessEqualsThan_2;
                    boolean bl3 = _lessEqualsThan_2 = typeName.compareTo(PRIMITIVE_TYPE_NAME.DOUBLE) <= 0;
                    if (_lessEqualsThan_2) {
                        compatible = av instanceof FloatingPointValue || av instanceof IntValue;
                    } else {
                        boolean _equals = Objects.equal((Object)((Object)typeName), (Object)((Object)PRIMITIVE_TYPE_NAME.STRING));
                        if (_equals) {
                            compatible = av instanceof StringValue;
                        } else {
                            boolean _equals_1 = Objects.equal((Object)((Object)typeName), (Object)((Object)PRIMITIVE_TYPE_NAME.BOOLEAN));
                            if (_equals_1) {
                                compatible = av instanceof BoolValue;
                            }
                        }
                    }
                }
            }
        } else if (attrType instanceof InlineEnumerationType) {
            if (av instanceof EnumerationValue) {
                Functions.Function1 _function = en -> {
                    String _name = en.getName();
                    String _name_1 = ((EnumerationValue)av).getValue().getName();
                    return Objects.equal((Object)_name, (Object)_name_1);
                };
                compatible = IterableExtensions.exists(((InlineEnumerationType)attrType).getEnums(), (Functions.Function1)_function);
            } else {
                compatible = false;
            }
        }
        return compatible;
    }

    public String getValueTypeName(AbstractValue av) {
        int _value;
        String _xblockexpression = null;
        String arrayPrefix = "a value-type ";
        EObject _eContainer = av.eContainer();
        if (_eContainer instanceof ArrayValue) {
            arrayPrefix = "an array value-type ";
        }
        String _switchResult = null;
        boolean _matched = false;
        if (av instanceof IntValue) {
            boolean _lessThan;
            _value = ((IntValue)av).getValue();
            boolean bl = _lessThan = _value < 0;
            if (_lessThan) {
                _matched = true;
                _switchResult = String.valueOf(arrayPrefix) + "'negative number'";
            }
        }
        if (!_matched && av instanceof IntValue) {
            boolean _greaterEqualsThan;
            _value = ((IntValue)av).getValue();
            boolean bl = _greaterEqualsThan = _value >= 0;
            if (_greaterEqualsThan) {
                _matched = true;
                _switchResult = String.valueOf(arrayPrefix) + "'number'";
            }
        }
        if (!_matched && av instanceof FloatingPointValue) {
            _matched = true;
            _switchResult = String.valueOf(arrayPrefix) + "'floating point'";
        }
        if (!_matched && av instanceof StringValue) {
            _matched = true;
            _switchResult = String.valueOf(arrayPrefix) + "'string'";
        }
        if (!_matched && av instanceof BoolValue) {
            _matched = true;
            _switchResult = String.valueOf(arrayPrefix) + "'boolean'";
        }
        if (!_matched && av instanceof EnumerationValue) {
            _matched = true;
            _switchResult = String.valueOf(arrayPrefix) + "'EnumerationValue'";
        }
        if (!_matched && av instanceof ArrayValue) {
            _matched = true;
            SingleValue _head = (SingleValue)IterableExtensions.head(((ArrayValue)av).getValues());
            String _valueTypeName = null;
            if (_head != null) {
                _valueTypeName = this.getValueTypeName(_head);
            }
            _switchResult = _valueTypeName;
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    public String getCardinalityName(AbstractAttributeType attrType) {
        boolean _tripleEquals;
        String _plus;
        PRIMITIVE_TYPE_NAME _typeName;
        boolean _tripleNotEquals;
        ArrayType _array;
        String _switchResult = null;
        boolean _matched = false;
        if (attrType instanceof PrimitiveType) {
            _array = ((PrimitiveType)attrType).getArray();
            boolean bl = _tripleNotEquals = _array != null;
            if (_tripleNotEquals) {
                _matched = true;
                _typeName = ((PrimitiveType)attrType).getTypeName();
                _plus = "an array of type '" + (Object)((Object)_typeName);
                _switchResult = String.valueOf(_plus) + "'";
            }
        }
        if (!_matched && attrType instanceof PrimitiveType) {
            _array = ((PrimitiveType)attrType).getArray();
            boolean bl = _tripleEquals = _array == null;
            if (_tripleEquals) {
                _matched = true;
                _typeName = ((PrimitiveType)attrType).getTypeName();
                _plus = "an element of type '" + (Object)((Object)_typeName);
                _switchResult = String.valueOf(_plus) + "'";
            }
        }
        if (!_matched && attrType instanceof InlineEnumerationType) {
            _array = ((InlineEnumerationType)attrType).getArray();
            boolean bl = _tripleNotEquals = _array != null;
            if (_tripleNotEquals) {
                _matched = true;
                _switchResult = "an array of type 'InlineEnumeration'";
            }
        }
        if (!_matched && attrType instanceof InlineEnumerationType) {
            _array = ((InlineEnumerationType)attrType).getArray();
            boolean bl = _tripleEquals = _array == null;
            if (_tripleEquals) {
                _matched = true;
                _switchResult = "an element of type 'InlineEnumeration'";
            }
        }
        return _switchResult;
    }
}

