/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ecore.base.stateMachine;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum VisibilityType implements Enumerator
{
    PUBLIC(0, "PUBLIC", "public"),
    PRIVATE(1, "PRIVATE", "internal");

    public static final int PUBLIC_VALUE = 0;
    public static final int PRIVATE_VALUE = 1;
    private static final VisibilityType[] VALUES_ARRAY;
    public static final List<VisibilityType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new VisibilityType[]{PUBLIC, PRIVATE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static VisibilityType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VisibilityType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static VisibilityType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VisibilityType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static VisibilityType get(int value) {
        switch (value) {
            case 0: {
                return PUBLIC;
            }
            case 1: {
                return PRIVATE;
            }
        }
        return null;
    }

    private VisibilityType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

