/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ecore.service.parameterDefinition;

import com.google.common.collect.Iterables;
import java.util.LinkedHashSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.BasicAttributesModelUtility;
import org.eclipse.smartmdsd.ecore.service.parameterDefinition.ParameterDefinition;
import org.eclipse.smartmdsd.ecore.service.parameterDefinition.ParameterSetDefinition;
import org.eclipse.smartmdsd.ecore.service.parameterDefinition.TriggerDefinition;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ParameterDefinitionModelUtility
extends BasicAttributesModelUtility {
    public Iterable<ParameterDefinition> getParameters(ParameterSetDefinition set) {
        return Iterables.filter(set.getParameters(), ParameterDefinition.class);
    }

    public Iterable<TriggerDefinition> getTriggers(ParameterSetDefinition set) {
        return Iterables.filter(set.getParameters(), TriggerDefinition.class);
    }

    public LinkedHashSet<ParameterSetDefinition> getParameterSetHierarchy(ParameterSetDefinition set) {
        return this.iterateParameterSetHierarchy(set, CollectionLiterals.newLinkedHashSet());
    }

    public Iterable<ParameterDefinition> getParameterHierarchy(ParameterSetDefinition set) {
        Functions.Function1 _function = it -> it.getParameters();
        return Iterables.filter((Iterable)Iterables.concat((Iterable)IterableExtensions.map(this.getParameterSetHierarchy(set), (Functions.Function1)_function)), ParameterDefinition.class);
    }

    public Iterable<TriggerDefinition> getTriggerHierarchy(ParameterSetDefinition set) {
        Functions.Function1 _function = it -> it.getParameters();
        return Iterables.filter((Iterable)Iterables.concat((Iterable)IterableExtensions.map(this.getParameterSetHierarchy(set), (Functions.Function1)_function)), TriggerDefinition.class);
    }

    private LinkedHashSet<ParameterSetDefinition> iterateParameterSetHierarchy(ParameterSetDefinition set, LinkedHashSet<ParameterSetDefinition> visited) {
        EList<ParameterSetDefinition> _extends = set.getExtends();
        for (ParameterSetDefinition next : _extends) {
            boolean _not;
            boolean _contains = visited.contains(next);
            boolean bl = _not = !_contains;
            if (!_not) continue;
            visited.add(next);
            visited.addAll(this.iterateParameterSetHierarchy(next, visited));
        }
        return visited;
    }
}

