/**
 * Copyright (c) 2018 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.ecore.service.serviceDefinition;

import java.util.Arrays;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.smartmdsd.ecore.service.communicationPattern.CommunicationPatternStyledLabelProvider;
import org.eclipse.smartmdsd.ecore.service.communicationPattern.ForkingPattern;
import org.eclipse.smartmdsd.ecore.service.communicationPattern.JoiningPattern;
import org.eclipse.smartmdsd.ecore.service.communicationPattern.RequestAnswerPattern;

@SuppressWarnings("all")
public class ServiceDefinitionStyledLabelProvider extends CommunicationPatternStyledLabelProvider {
  protected StyledString _getStyledServiceString(final ForkingServiceDefinition service) {
    String _name = service.getName();
    StyledString text = new StyledString(_name, StyledString.DECORATIONS_STYLER);
    ForkingPattern _pattern = service.getPattern();
    boolean _tripleNotEquals = (_pattern != null);
    if (_tripleNotEquals) {
      StyledString _styledString = new StyledString(": ", StyledString.QUALIFIER_STYLER);
      text.append(_styledString);
      text.append(this.getStyledString(service.getPattern()));
    }
    return text;
  }
  
  protected StyledString _getStyledServiceString(final JoiningServiceDefinition service) {
    String _name = service.getName();
    StyledString text = new StyledString(_name, StyledString.DECORATIONS_STYLER);
    JoiningPattern _pattern = service.getPattern();
    boolean _tripleNotEquals = (_pattern != null);
    if (_tripleNotEquals) {
      StyledString _styledString = new StyledString(": ", StyledString.QUALIFIER_STYLER);
      text.append(_styledString);
      text.append(this.getStyledString(service.getPattern()));
    }
    return text;
  }
  
  protected StyledString _getStyledServiceString(final RequestAnswerServiceDefinition service) {
    String _name = service.getName();
    StyledString text = new StyledString(_name, StyledString.DECORATIONS_STYLER);
    RequestAnswerPattern _pattern = service.getPattern();
    boolean _tripleNotEquals = (_pattern != null);
    if (_tripleNotEquals) {
      StyledString _styledString = new StyledString(": ", StyledString.QUALIFIER_STYLER);
      text.append(_styledString);
      text.append(this.getStyledString(service.getPattern()));
    }
    return text;
  }
  
  protected StyledString _getStyledServiceString(final CoordinationServiceDefinition service) {
    String _name = service.getName();
    StyledString text = new StyledString(_name, StyledString.DECORATIONS_STYLER);
    return text;
  }
  
  public StyledString getStyledServiceString(final AbstractServiceDefinition service) {
    if (service instanceof ForkingServiceDefinition) {
      return _getStyledServiceString((ForkingServiceDefinition)service);
    } else if (service instanceof JoiningServiceDefinition) {
      return _getStyledServiceString((JoiningServiceDefinition)service);
    } else if (service instanceof RequestAnswerServiceDefinition) {
      return _getStyledServiceString((RequestAnswerServiceDefinition)service);
    } else if (service instanceof CoordinationServiceDefinition) {
      return _getStyledServiceString((CoordinationServiceDefinition)service);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(service).toString());
    }
  }
}
