/**
 * Copyright (c) 2021 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.ecore.service.skillDefinition;

import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.smartmdsd.ui.factories.ISmartMDSDModelFactory;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

@SuppressWarnings("all")
public class SmartMDSDSkillDefinitionFactory implements ISmartMDSDModelFactory {
  @Override
  public EPackage getEPackage() {
    return SkillDefinitionPackage.eINSTANCE;
  }
  
  @Override
  public Collection<EPackage> getParentEPackages() {
    return CollectionLiterals.<EPackage>newArrayList();
  }
  
  @Override
  public EObject createDefaultModel(final String projectName, final Collection<EObject> parentModels) {
    final SkillDefinitionModel model = SkillDefinitionFactory.eINSTANCE.createSkillDefinitionModel();
    final SkillDefinitionRepository repo = SkillDefinitionFactory.eINSTANCE.createSkillDefinitionRepository();
    repo.setName(projectName);
    model.setRepository(repo);
    return model;
  }
}
