/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.sirius.utils;

import com.google.inject.Injector;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.sirius.business.api.resource.ResourceDescriptor;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.tools.api.command.semantic.AddSemanticResourceCommand;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.xtext.resource.IContainer;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;
import org.osgi.framework.Bundle;

public class DiagramHelperServices {
    public static String getProjectName(EObject obj) {
        return obj.eResource().getURI().segment(1);
    }

    public static EObject printObject(EObject object) {
        System.out.println("Object: " + object);
        System.out.println("Object.eClass(): " + object.eClass());
        return object;
    }

    public static Collection<EObject> geXtextIndexEObjetcsByType(Injector injector, EObject context, EClass type) {
        ArrayList<EObject> objects = new ArrayList<EObject>();
        ResourceDescriptionsProvider rdp = (ResourceDescriptionsProvider)injector.getInstance(ResourceDescriptionsProvider.class);
        IResourceDescriptions descriptions = rdp.getResourceDescriptions(context.eResource());
        IResourceDescription description = descriptions.getResourceDescription(context.eResource().getURI());
        IContainer.Manager manager = (IContainer.Manager)injector.getInstance(IContainer.Manager.class);
        List containters = manager.getVisibleContainers(description, descriptions);
        for (IContainer container : containters) {
            Iterable objectDescriptions = container.getExportedObjectsByType(type);
            for (IEObjectDescription objectDescription : objectDescriptions) {
                EObject serviceRepoProxy = objectDescription.getEObjectOrProxy();
                if (serviceRepoProxy.eIsProxy()) {
                    EObject serviceRepo = context.eResource().getResourceSet().getEObject(objectDescription.getEObjectURI(), true);
                    objects.add(serviceRepo);
                    continue;
                }
                objects.add(serviceRepoProxy);
            }
        }
        return objects;
    }

    public static EObject openRepresentation(EObject obj, String representationName) {
        for (Session session : SessionManager.INSTANCE.getSessions()) {
            for (DView view : session.getOwnedViews()) {
                for (DRepresentationDescriptor representation : view.getOwnedRepresentationDescriptors()) {
                    if (!representation.getName().equals(representationName)) continue;
                    System.out.println("Opening represenatation: " + representationName);
                    DialectUIManager.INSTANCE.openEditor(session, representation.getRepresentation(), (IProgressMonitor)new NullProgressMonitor());
                }
            }
        }
        return obj;
    }

    public static List<EObject> getModelSelections(EObject containerView, String modelFolder, String modelFileExtension, Boolean multipleSelection, String dialogMessage) {
        DDiagram diagram;
        List<ResourceDescriptor> currentSematicResources;
        LabelProvider labelProvider;
        Object[] results;
        ArrayList<EObject> selection = new ArrayList<EObject>();
        if (containerView instanceof DDiagram && (results = DiagramHelperServices.openModelSelectionDialog((ILabelProvider)(labelProvider = new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ResourceDescriptor) {
                    ResourceDescriptor descr = (ResourceDescriptor)element;
                    return descr.getResourceURI().segment(1);
                }
                return "";
            }
        }), (currentSematicResources = DiagramHelperServices.getSemanticResources(diagram = (DDiagram)containerView, modelFileExtension)).toArray(), multipleSelection, dialogMessage)) != null) {
            Object[] objectArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj instanceof ResourceDescriptor) {
                    ResourceDescriptor descr = (ResourceDescriptor)obj;
                    boolean loadOnDemand = false;
                    Resource resource = diagram.eResource().getResourceSet().getResource(descr.getResourceURI(), loadOnDemand);
                    if (resource != null) {
                        selection.addAll((Collection<EObject>)resource.getContents());
                    }
                }
                ++n2;
            }
        }
        return selection;
    }

    public static EObject importSingleModel(DDiagram diagram, String modelFolder, String modelFileExtension, String dialogMessage) {
        boolean deselectProjects = true;
        return DiagramHelperServices.importSingleModel(diagram, modelFolder, modelFileExtension, dialogMessage, deselectProjects);
    }

    public static EObject importSingleModel(DDiagram diagram, String modelFolder, String modelFileExtension, String dialogMessage, Boolean deselectProjects) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        NullProgressMonitor monitor = new NullProgressMonitor();
        ArrayList<IProject> elements = new ArrayList<IProject>();
        IProject[] iProjectArray = root.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            String modelFileName;
            IFile modelFile;
            IProject project = iProjectArray[n2];
            IFolder modelDir = project.getFolder(modelFolder);
            if (modelDir.exists() && (modelFile = modelDir.getFile(modelFileName = String.valueOf(project.getName()) + "." + modelFileExtension)).exists()) {
                elements.add(project);
            }
            ++n2;
        }
        boolean multipleSelection = false;
        Object[] results = DiagramHelperServices.openModelSelectionDialog(DiagramHelperServices.createProjectLabelProvider(), elements.toArray(), multipleSelection, dialogMessage);
        if (results != null) {
            List<ResourceDescriptor> currentSematicResources = DiagramHelperServices.getSemanticResources(diagram, modelFileExtension);
            DiagramHelperServices.adjustSemanticResources(diagram, results, currentSematicResources, modelFolder, modelFileExtension, root, (IProgressMonitor)monitor);
            DiagramHelperServices.adjustJavaBuildPath(diagram, results, deselectProjects, root, (IProgressMonitor)monitor);
        }
        return diagram;
    }

    private static ILabelProvider createProjectLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IProject) {
                    IProject project = (IProject)element;
                    return project.getName();
                }
                return "";
            }
        };
    }

    public static ILabelProvider createNameFeatureLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof EObject) {
                    EObject obj = (EObject)element;
                    for (EAttribute attr : obj.eClass().getEAllAttributes()) {
                        if (!attr.getName().equals("name") || !attr.getEType().getName().equals("EString")) continue;
                        return (String)obj.eGet((EStructuralFeature)attr);
                    }
                }
                return "";
            }
        };
    }

    public static Object[] openModelSelectionDialog(ILabelProvider labelProvider, Object[] elements, boolean multipleSelection, String dialogMessage) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, labelProvider);
        dialog.setTitle("Model selection");
        dialog.setMessage(dialogMessage);
        dialog.setElements(elements);
        dialog.setMultipleSelection(multipleSelection);
        if (dialog.open() == 0) {
            return dialog.getResult();
        }
        return null;
    }

    public static Object[] openTreeSelectionDialog(ILabelProvider labelProvider, ITreeContentProvider contenProvider, Object input, ViewerComparator comparator, boolean multipleSelection, String dialogMessage) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(shell, labelProvider, contenProvider);
        dialog.setTitle("Model selection");
        dialog.setEmptyListMessage("There are no models to be selected.");
        dialog.setMessage(dialogMessage);
        dialog.setAllowMultiple(multipleSelection);
        dialog.setComparator(comparator);
        dialog.setInput(input);
        if (dialog.open() == 0) {
            return dialog.getResult();
        }
        return null;
    }

    public static Object[] openTwoPaneModelSelectionDialog(ILabelProvider upperLabelProvider, ILabelProvider lowerLabelProvider, Object[] candidates, boolean multipleSelection, String upperLabel, String lowerLabel) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        TwoPaneElementSelector dialog = new TwoPaneElementSelector(shell, upperLabelProvider, lowerLabelProvider);
        dialog.setTitle("Model selection");
        dialog.setUpperListLabel(upperLabel);
        dialog.setLowerListLabel(lowerLabel);
        dialog.setElements(candidates);
        dialog.setMultipleSelection(multipleSelection);
        if (dialog.open() == 0) {
            return dialog.getResult();
        }
        return null;
    }

    public static EObject importModels(DDiagram diagram, String modelFolder, String modelFileExtension) {
        boolean deselectProjects = true;
        return DiagramHelperServices.importModels(diagram, modelFolder, modelFileExtension, deselectProjects);
    }

    public static EObject importModels(DDiagram diagram, String modelFolder, String modelFileExtension, Boolean deselectProjects) {
        DiagramHelperServices.triggerModelImportCommand();
        return diagram;
    }

    public static void triggerModelImportCommand() {
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(IHandlerService.class);
        try {
            handlerService.executeCommand("org.eclipse.smartmdsd.navigator.imports", null);
        }
        catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
            e.printStackTrace();
        }
    }

    public static List<ResourceDescriptor> getSemanticResources(DDiagram diagram, String modelFileExtension) {
        ArrayList<ResourceDescriptor> currentSematicResources = new ArrayList<ResourceDescriptor>();
        for (EObject obj : diagram.eResource().getContents()) {
            if (!(obj instanceof DAnalysis)) continue;
            DAnalysis analysis = (DAnalysis)obj;
            for (ResourceDescriptor semanticResource : analysis.getSemanticResources()) {
                if (!semanticResource.getResourceURI().fileExtension().equals(modelFileExtension)) continue;
                currentSematicResources.add(semanticResource);
            }
        }
        return currentSematicResources;
    }

    private static void adjustSemanticResources(DDiagram diagram, Object[] results, List<ResourceDescriptor> currentSematicResources, String modelFolder, String modelFileExtension, IWorkspaceRoot root, IProgressMonitor monitor) {
        Session session = SessionManager.INSTANCE.getSession(diagram.eResource().getURI(), monitor);
        for (ResourceDescriptor resourceDescriptor : currentSematicResources) {
            String projName = resourceDescriptor.getResourceURI().segment(1);
            boolean selected = false;
            Object[] objectArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project;
                Object obj = objectArray[n2];
                if (obj instanceof IProject && (project = (IProject)obj).getName().equals(projName)) {
                    selected = true;
                    break;
                }
                ++n2;
            }
            if (selected) continue;
            for (EObject eobj : diagram.eResource().getContents()) {
                if (!(eobj instanceof DAnalysis)) continue;
                DAnalysis analysis = (DAnalysis)eobj;
                analysis.getSemanticResources().remove((Object)resourceDescriptor);
            }
        }
        Object[] objectArray = results;
        int n = results.length;
        int n3 = 0;
        while (n3 < n) {
            IProject project;
            IFile file;
            Object object = objectArray[n3];
            if (object instanceof IProject && (file = (project = (IProject)object).getFolder(modelFolder).getFile(String.valueOf(project.getName()) + "." + modelFileExtension)).exists()) {
                String platformUriStr = "platform:/resource/" + project.getName() + "/" + modelFolder + "/" + project.getName() + "." + modelFileExtension;
                URI uri = URI.createURI((String)platformUriStr);
                AddSemanticResourceCommand cmd = new AddSemanticResourceCommand(session, uri, monitor);
                session.getTransactionalEditingDomain().getCommandStack().execute((Command)cmd);
            }
            ++n3;
        }
        session.save(monitor);
    }

    private static void adjustJavaBuildPath(DDiagram diagram, Object[] results, boolean deselectProjects, IWorkspaceRoot root, IProgressMonitor monitor) {
        IProject project = root.getProject(diagram.eResource().getURI().segment(1));
        if (project.exists()) {
            try {
                IProjectNature nature = project.getNature("org.eclipse.jdt.core.javanature");
                if (nature instanceof IJavaProject) {
                    IClasspathEntry[] currClasspath;
                    IJavaProject jproject = (IJavaProject)nature;
                    ArrayList<IClasspathEntry> newClasspath = new ArrayList<IClasspathEntry>();
                    Object[] objectArray = currClasspath = jproject.getRawClasspath();
                    int n = currClasspath.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IClasspathEntry entry = objectArray[n2];
                        if (deselectProjects && entry.getEntryKind() != 2) {
                            newClasspath.add(entry);
                        }
                        ++n2;
                    }
                    objectArray = results;
                    n = results.length;
                    n2 = 0;
                    while (n2 < n) {
                        IProject selectedProject;
                        IClasspathEntry obj = objectArray[n2];
                        if (obj instanceof IProject && (selectedProject = (IProject)obj) != project) {
                            IClasspathEntry entry = JavaCore.newProjectEntry((IPath)selectedProject.getFullPath());
                            newClasspath.add(entry);
                        }
                        ++n2;
                    }
                    IClasspathEntry[] newRawClasspath = newClasspath.toArray(new IClasspathEntry[0]);
                    jproject.setRawClasspath(newRawClasspath, monitor);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public static String askForTextDialog(String dialogTitle, String labelText, String defaultText) {
        String result = "";
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        SimpleInputTextDialog textDialog = new SimpleInputTextDialog(shell, dialogTitle, labelText, defaultText);
        textDialog.create();
        if (textDialog.open() == 0) {
            result = textDialog.getInputString();
        }
        return result;
    }

    public static Image getBundelImage(String bundleName, String imageName) {
        Bundle bundle = Platform.getBundle((String)bundleName);
        URL fullPathString = bundle.getEntry(imageName);
        ImageDescriptor imgDescr = ImageDescriptor.createFromURL((URL)fullPathString);
        return imgDescr.createImage();
    }

    protected static class SimpleInputTextDialog
    extends Dialog {
        private String dialogTitle;
        private String labelText;
        private Text inputText;
        private String inputString;

        public SimpleInputTextDialog(Shell parentShell) {
            super(parentShell);
        }

        public SimpleInputTextDialog(Shell parentShell, String dialogTitle, String labelText, String defaultText) {
            super(parentShell);
            this.dialogTitle = dialogTitle;
            this.labelText = labelText;
            this.inputString = defaultText;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(this.dialogTitle);
        }

        protected Control createDialogArea(Composite parent) {
            Composite area = (Composite)super.createDialogArea(parent);
            Composite container = new Composite(area, 0);
            container.setLayoutData((Object)new GridData(4, 4, true, true));
            GridLayout layout = new GridLayout(2, false);
            container.setLayout((Layout)layout);
            this.createInputLine(container);
            return area;
        }

        private void createInputLine(Composite container) {
            Label lbtFirstName = new Label(container, 0);
            lbtFirstName.setText(this.labelText);
            GridData dataFirstName = new GridData();
            dataFirstName.grabExcessHorizontalSpace = true;
            dataFirstName.horizontalAlignment = 4;
            this.inputText = new Text(container, 2048);
            this.inputText.setLayoutData((Object)dataFirstName);
            this.inputText.setText(this.inputString);
        }

        protected boolean isResizable() {
            return true;
        }

        private void saveInput() {
            this.inputString = this.inputText.getText();
        }

        protected void okPressed() {
            this.saveInput();
            super.okPressed();
        }

        public String getInputString() {
            return this.inputString;
        }
    }
}

