/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.sirius.utils;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManagerListener;
import org.eclipse.sirius.common.tools.api.resource.ImageFileFormat;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.business.api.dialect.ExportFormat;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.swt.widgets.Display;

public class DiagramSnapshotManager
implements SessionManagerListener {
    public void notify(final Session session, int arg1) {
        if (arg1 == 3) {
            final String projectName = session.getSessionResource().getURI().segment(1);
            for (DView view : session.getOwnedViews()) {
                String viewpointName = view.getViewpoint().getName();
                for (final DRepresentationDescriptor descr : view.getOwnedRepresentationDescriptors()) {
                    if (!descr.getName().startsWith(projectName)) continue;
                    final String imageName = String.valueOf(projectName) + viewpointName.replaceAll("Viewpoint", "") + ".jpg";
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            IPath absoluteImagePath = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getFolder("model").getLocation().append(imageName);
                            ExportFormat exportFormat = new ExportFormat(ExportFormat.ExportDocumentFormat.NONE, ImageFileFormat.JPG);
                            try {
                                DialectUIManager.INSTANCE.export(descr.getRepresentation(), session, absoluteImagePath, exportFormat, (IProgressMonitor)new NullProgressMonitor());
                            }
                            catch (CoreException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
            }
        }
    }

    public void notifyAddSession(Session arg0) {
    }

    public void notifyRemoveSession(Session arg0) {
    }

    public void viewpointDeselected(Viewpoint arg0) {
    }

    public void viewpointSelected(Viewpoint arg0) {
    }
}

