/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.sirius.utils.xtext;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.action.AbstractExternalJavaAction;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.smartmdsd.sirius.utils.xtext.AbstractXtextEditorViewPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractOpenXtextEditorViewPartAction
extends AbstractExternalJavaAction {
    public boolean canExecute(Collection<? extends EObject> arg0) {
        return true;
    }

    public void execute(Collection<? extends EObject> arg0, Map<String, Object> arg1) {
        EObject selfObject = (EObject)this.getParameter(arg1, "self", EObject.class);
        if (selfObject == null) {
            Iterator<? extends EObject> iterator = arg0.iterator();
            while (iterator.hasNext()) {
                EObject object;
                selfObject = object = iterator.next();
            }
        }
        try {
            DDiagramElement diagramElement;
            IViewPart view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(this.getViewPartID());
            if (selfObject instanceof DDiagramElement && this.checkModelConstraints(diagramElement = (DDiagramElement)selfObject) && view instanceof AbstractXtextEditorViewPart) {
                AbstractXtextEditorViewPart xtextViewPart = (AbstractXtextEditorViewPart)view;
                URI xtextResourceUri = xtextViewPart.getAccordingXtextResourceUri((DRepresentationElement)diagramElement);
                this.createModelFile(xtextResourceUri);
                xtextViewPart.setExternalEmfBase((DRepresentationElement)diagramElement, xtextResourceUri);
                this.updateSemanticModel((DRepresentationElement)diagramElement, xtextViewPart);
            }
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    protected void createModelFile(URI xtextResourceUri) {
        Path modelFilePath;
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IFile modelFile = workspaceRoot.getFile((IPath)(modelFilePath = new Path(xtextResourceUri.toPlatformString(true))));
        if (!modelFile.exists()) {
            String modelContent = this.getDefaultModelConent(xtextResourceUri);
            ByteArrayInputStream stream = new ByteArrayInputStream(modelContent.getBytes());
            try {
                modelFile.create((InputStream)stream, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public abstract String getViewPartID();

    public abstract String getDefaultModelConent(URI var1);

    public abstract boolean checkModelConstraints(DDiagramElement var1);

    protected void updateSemanticModel(DRepresentationElement representationElem, AbstractXtextEditorViewPart xtextViewPart) {
    }
}

