/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ui;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.smartmdsd.ui.ISmartMDSDProjectImportContribution;

public class SmartMDSDProjectImportContributionRegistry {
    private static Collection<ISmartMDSDProjectImportContribution> registry;

    public static void initialize() {
        registry = new ArrayList<ISmartMDSDProjectImportContribution>();
        IConfigurationElement[] configurations = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.smartmdsd.ui.SmartMDSDProjectImportContributionEP");
        try {
            IConfigurationElement[] iConfigurationElementArray = configurations;
            int n = configurations.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement config = iConfigurationElementArray[n2];
                Object object = config.createExecutableExtension("class");
                if (object instanceof ISmartMDSDProjectImportContribution) {
                    ISmartMDSDProjectImportContribution contribution = (ISmartMDSDProjectImportContribution)object;
                    System.out.println("Register SmartMDSD Project Imports Contribution for: " + contribution.getParentProjectNature());
                    registry.add(contribution);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static Collection<IProject> getFilteredProjectImports(IWorkspaceRoot root, String current_nature_id, IProject current_project) {
        ArrayList<IProject> result = new ArrayList<IProject>();
        try {
            IProject[] allWorkspaceProjects = root.getProjects();
            if (allWorkspaceProjects != null) {
                for (ISmartMDSDProjectImportContribution contribution : registry) {
                    boolean parent_nature_matches = false;
                    if (current_project != null && current_project.hasNature(contribution.getParentProjectNature())) {
                        parent_nature_matches = true;
                    } else if (current_nature_id.contentEquals(contribution.getParentProjectNature())) {
                        parent_nature_matches = true;
                    }
                    if (!parent_nature_matches) continue;
                    for (String imported_nature : contribution.getImportedProjectNatures()) {
                        IProject[] iProjectArray = allWorkspaceProjects;
                        int n = allWorkspaceProjects.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IProject candidate = iProjectArray[n2];
                            if (candidate.hasNature(imported_nature) && candidate != current_project) {
                                result.add(candidate);
                            }
                            ++n2;
                        }
                    }
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return result;
    }
}

