/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ui.factories;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.smartmdsd.ui.natures.SmartMDSDNatureHelpers;

public class JavaProjectFactory {
    public static void createJavaProject(IProject project, IProject[] referencedProjects, String modelFolderName, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Create Java Project", (int)20);
        SmartMDSDNatureHelpers.addProjectNature(project, "org.eclipse.jdt.core.javanature", (IProgressMonitor)subMonitor.split(10));
        IJavaProject javaProject = JavaCore.create((IProject)project);
        int defaultEntriesNumber = 2;
        IClasspathEntry[] buildPath = new IClasspathEntry[defaultEntriesNumber + referencedProjects.length];
        buildPath[0] = JavaRuntime.getDefaultJREContainerEntry();
        buildPath[1] = JavaCore.newSourceEntry((IPath)project.getFullPath().append(modelFolderName));
        Integer i = 0;
        while (i < referencedProjects.length) {
            buildPath[i.intValue() + defaultEntriesNumber] = JavaCore.newProjectEntry((IPath)referencedProjects[i].getFullPath());
            i = i + 1;
        }
        javaProject.setRawClasspath(buildPath, project.getFullPath().append("bin"), (IProgressMonitor)subMonitor.split(10));
    }

    public static void updateJavaReferencedProjects(IProject currentProject, Object[] selectedElements, IProgressMonitor monitor) throws CoreException {
        IProjectNature nature = currentProject.getNature("org.eclipse.jdt.core.javanature");
        if (nature instanceof IJavaProject) {
            IClasspathEntry[] currClasspath;
            IJavaProject javaProject = (IJavaProject)nature;
            ArrayList<IClasspathEntry> newClasspath = new ArrayList<IClasspathEntry>();
            Object[] objectArray = currClasspath = javaProject.getRawClasspath();
            int n = currClasspath.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = objectArray[n2];
                if (entry.getEntryKind() != 2) {
                    newClasspath.add(entry);
                }
                ++n2;
            }
            objectArray = selectedElements;
            n = selectedElements.length;
            n2 = 0;
            while (n2 < n) {
                IProject selectedProject;
                IClasspathEntry object = objectArray[n2];
                if (object instanceof IProject && (selectedProject = (IProject)object) != currentProject) {
                    IClasspathEntry entry = JavaCore.newProjectEntry((IPath)selectedProject.getFullPath());
                    newClasspath.add(entry);
                }
                ++n2;
            }
            IClasspathEntry[] newRawClasspath = newClasspath.toArray(new IClasspathEntry[0]);
            javaProject.setRawClasspath(newRawClasspath, monitor);
        }
    }

    public static List<IResource> getContainingJavaSources(IResource selectedResource) throws CoreException {
        ArrayList<IResource> sourceFiles = new ArrayList<IResource>();
        IProject project = selectedResource.getProject();
        IProjectNature nature = project.getNature("org.eclipse.jdt.core.javanature");
        if (nature instanceof IJavaProject) {
            IClasspathEntry[] currClasspath;
            IJavaProject javaProject = (IJavaProject)nature;
            IClasspathEntry[] iClasspathEntryArray = currClasspath = javaProject.getRawClasspath();
            int n = currClasspath.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 3) {
                    int n3;
                    IFolder sourceFolder = project.getFolder(entry.getPath().removeFirstSegments(1));
                    if (selectedResource instanceof IProject) {
                        if (sourceFolder.exists()) {
                            IResource[] iResourceArray = sourceFolder.members();
                            n3 = iResourceArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IResource source = iResourceArray[n4];
                                sourceFiles.add(source);
                                ++n4;
                            }
                        }
                    } else if (selectedResource instanceof IFolder) {
                        IFolder selectedFolder = (IFolder)selectedResource;
                        if (selectedFolder.equals((Object)sourceFolder)) {
                            IResource[] iResourceArray = sourceFolder.members();
                            int n5 = iResourceArray.length;
                            n3 = 0;
                            while (n3 < n5) {
                                IResource source = iResourceArray[n3];
                                sourceFiles.add(source);
                                ++n3;
                            }
                        }
                    } else if (selectedResource instanceof IFile && sourceFolder.equals((Object)selectedResource.getParent())) {
                        sourceFiles.add(selectedResource);
                    }
                }
                ++n2;
            }
        }
        return sourceFiles;
    }
}

