/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ui.factories;

import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelection;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelectionCallback;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class SelectViewpointCommand
extends RecordingCommand {
    private Session session;
    private final ViewpointSelection.Callback callback;
    final String modelFileExtension;
    final String viewpointName;
    private boolean createNewRepresentations;
    private IProgressMonitor monitor;

    public SelectViewpointCommand(Session session, String modelFileExtension, String viewpointName, IProgressMonitor monitor) {
        super(session.getTransactionalEditingDomain(), "Select a given viewpoint");
        this.session = session;
        this.callback = new ViewpointSelectionCallback();
        this.modelFileExtension = modelFileExtension;
        this.viewpointName = viewpointName;
        this.createNewRepresentations = true;
        this.monitor = monitor;
    }

    public SelectViewpointCommand(Session session, String modelFileExtension, String viewpointName, boolean createNewRepresentations, IProgressMonitor monitor) {
        super(session.getTransactionalEditingDomain(), "Select a given viewpoint");
        this.session = session;
        this.callback = new ViewpointSelectionCallback();
        this.modelFileExtension = modelFileExtension;
        this.viewpointName = viewpointName;
        this.createNewRepresentations = createNewRepresentations;
        this.monitor = monitor;
    }

    protected void doExecute() {
        if (this.callback == null || this.session == null) {
            return;
        }
        try {
            this.monitor.beginTask("Apply new viewpoints selection...", 1);
            Set viewpoints = ViewpointSelection.getViewpoints((String)this.modelFileExtension);
            for (Viewpoint viewpoint : viewpoints) {
                if (!viewpoint.getName().equals(this.viewpointName)) continue;
                try {
                    this.callback.selectViewpoint(viewpoint, this.session, this.createNewRepresentations, this.monitor);
                }
                catch (SecurityException e) {
                    String errorMessage = "Unable to activate viewpoint '" + viewpoint.getName() + "' because of insufficient rights.";
                    throw new SecurityException(errorMessage, e);
                }
            }
        }
        finally {
            this.monitor.done();
        }
    }
}

