/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ui.natures;

import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.smartmdsd.ui.Activator;
import org.eclipse.smartmdsd.ui.builder.CDTProjectHelpers;
import org.eclipse.smartmdsd.ui.models.SmartMDSDModelingLanguage;
import org.eclipse.smartmdsd.ui.models.SmartMDSDModelingLanguageRegistry;
import org.eclipse.smartmdsd.ui.natures.AbstractSmartMDSDNature;

public class SystemNature
extends AbstractSmartMDSDNature {
    public static final String NATURE_ID = "org.eclipse.smartmdsd.ui.natures.SystemNature";

    public static SmartMDSDModelingLanguageRegistry getRegistry() {
        return (SmartMDSDModelingLanguageRegistry)languages_registry.get(NATURE_ID);
    }

    public static SmartMDSDModelingLanguage getDSL(EPackage epackage) {
        return SystemNature.getRegistry().getLanguage(epackage);
    }

    @Override
    public void configure() throws CoreException {
        if (this.project != null && this.project.isAccessible()) {
            if (!this.project.hasNature("org.eclipse.cdt.core.ccnature")) {
                WorkspaceJob addCppSettingsJob = new WorkspaceJob("Add C++ project configuration to " + this.project.getName()){

                    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                        try {
                            String activeBuildType = Activator.getDefault().getPreferenceStore().getString("CMakeBuildType");
                            CDTProjectHelpers.addDefaultSettingsTo(SystemNature.this.project, activeBuildType, monitor);
                        }
                        catch (BuildException e) {
                            e.printStackTrace();
                            return Status.CANCEL_STATUS;
                        }
                        return Status.OK_STATUS;
                    }
                };
                addCppSettingsJob.setUser(true);
                addCppSettingsJob.schedule();
            } else {
                super.configure();
            }
        }
    }

    @Override
    public String getNatureID() {
        return NATURE_ID;
    }

    @Override
    public List<String> getImportedProjectNatureIds() {
        return Arrays.asList("org.eclipse.smartmdsd.ui.natures.ComponentNature", "org.eclipse.smartmdsd.ui.natures.BehaviorNature");
    }
}

