/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ui.perspectives;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.smartmdsd.ui.natures.SmartMDSDNatureEnum;

public enum SmartMDSDPerspectiveEnum {
    DomainExpert("org.eclipse.smartmdsd.ui.perspectives.domainExpert"),
    ComponentSupplier("org.eclipse.smartmdsd.ui.perspectives.componentSupplier"),
    SystemBuilder("org.eclipse.smartmdsd.ui.perspectives.systemBuilder"),
    BehaviorDeveloper("org.eclipse.smartmdsd.ui.perspectives.behaviorDeveloper");

    private static final Map<String, SmartMDSDPerspectiveEnum> lookup;
    private String perspectiveId;

    static {
        lookup = new HashMap<String, SmartMDSDPerspectiveEnum>();
        SmartMDSDPerspectiveEnum[] smartMDSDPerspectiveEnumArray = SmartMDSDPerspectiveEnum.values();
        int n = smartMDSDPerspectiveEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            SmartMDSDPerspectiveEnum perspective = smartMDSDPerspectiveEnumArray[n2];
            lookup.put(perspective.getId(), perspective);
            ++n2;
        }
    }

    public static SmartMDSDPerspectiveEnum getFromID(String perspectiveId) {
        return lookup.get(perspectiveId);
    }

    private SmartMDSDPerspectiveEnum(String perspectiveId) {
        this.perspectiveId = perspectiveId;
    }

    public String getId() {
        return this.perspectiveId;
    }

    public SmartMDSDNatureEnum getRelatedSmartMDSDNature() {
        switch (this) {
            case DomainExpert: {
                return SmartMDSDNatureEnum.DomainModelsNature;
            }
            case ComponentSupplier: {
                return SmartMDSDNatureEnum.ComponentNature;
            }
            case SystemBuilder: {
                return SmartMDSDNatureEnum.SystemNature;
            }
            case BehaviorDeveloper: {
                return SmartMDSDNatureEnum.BehaviorNature;
            }
        }
        return null;
    }
}

