/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ui.wizards;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.smartmdsd.ui.perspectives.SmartMDSDPerspectiveEnum;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class SingleProjectSelectionPage
extends WizardPage {
    private TableViewer referenceProjectsViewer;
    private ISelection initialSelection;
    private SmartMDSDPerspectiveEnum currentPerspectiveEnum;
    private static final int PROJECT_LIST_MULTIPLIER = 15;

    public SingleProjectSelectionPage(String pageName, IWorkbench workbench, ISelection selection) {
        super(pageName);
        this.initialSelection = selection;
        IPerspectiveDescriptor currentPerspective = workbench.getActiveWorkbenchWindow().getActivePage().getPerspective();
        this.currentPerspectiveEnum = SmartMDSDPerspectiveEnum.getFromID(currentPerspective.getId());
    }

    public IProject getSelectedProject() {
        StructuredSelection structuredSelection;
        Object firstElement;
        ISelection currentSelection = this.referenceProjectsViewer.getSelection();
        if (currentSelection instanceof StructuredSelection && (firstElement = (structuredSelection = (StructuredSelection)currentSelection).getFirstElement()) instanceof IProject) {
            return (IProject)firstElement;
        }
        return null;
    }

    public void setSelection(ISelection selection) {
        if (this.referenceProjectsViewer != null) {
            this.referenceProjectsViewer.setSelection(selection);
        }
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(768));
        composite.setFont(font);
        Label referenceLabel = new Label(composite, 0);
        referenceLabel.setText("Selected Project");
        referenceLabel.setFont(font);
        this.referenceProjectsViewer = new TableViewer(composite);
        this.referenceProjectsViewer.getTable().setFont(composite.getFont());
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = SingleProjectSelectionPage.getDefaultFontHeight((Control)this.referenceProjectsViewer.getTable(), 15);
        this.referenceProjectsViewer.getTable().setLayoutData((Object)data);
        this.referenceProjectsViewer.setLabelProvider((IBaseLabelProvider)WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        this.referenceProjectsViewer.setContentProvider((IContentProvider)this.getContentProvider());
        this.referenceProjectsViewer.setComparator(new ViewerComparator());
        this.referenceProjectsViewer.setInput((Object)ResourcesPlugin.getWorkspace());
        this.setPageComplete(false);
        ISelectionChangedListener selectTableElementListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection structuredSelection;
                Object firstElement;
                ISelection selection = event.getSelection();
                if (selection instanceof StructuredSelection && (firstElement = (structuredSelection = (StructuredSelection)selection).getFirstElement()) instanceof IProject) {
                    SingleProjectSelectionPage.this.setPageComplete(true);
                }
            }
        };
        this.referenceProjectsViewer.addSelectionChangedListener(selectTableElementListener);
        this.referenceProjectsViewer.setSelection(this.initialSelection);
        this.setControl((Control)composite);
    }

    protected IStructuredContentProvider getContentProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object element) {
                if (!(element instanceof IWorkspace)) {
                    return new Object[0];
                }
                IProject[] allProjects = ((IWorkspace)element).getRoot().getProjects();
                ArrayList<IProject> filteredProjects = new ArrayList<IProject>();
                IProject[] iProjectArray = allProjects;
                int n = allProjects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project = iProjectArray[n2];
                    if (project.isOpen()) {
                        if (SingleProjectSelectionPage.this.currentPerspectiveEnum != null) {
                            try {
                                if (project.hasNature(SingleProjectSelectionPage.this.currentPerspectiveEnum.getRelatedSmartMDSDNature().getId())) {
                                    filteredProjects.add(project);
                                }
                            }
                            catch (CoreException e) {
                                e.printStackTrace();
                            }
                        } else {
                            filteredProjects.add(project);
                        }
                    }
                    ++n2;
                }
                return filteredProjects.isEmpty() ? new Object[]{} : filteredProjects.toArray();
            }
        };
    }

    private static int getDefaultFontHeight(Control control, int lines) {
        FontData[] viewerFontData = control.getFont().getFontData();
        int fontHeight = 10;
        if (viewerFontData.length > 0) {
            fontHeight = viewerFontData[0].getHeight();
        }
        return lines * fontHeight;
    }
}

