/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.smartmdsd.ui.SmartMDSDProjectImportContributionRegistry;
import org.eclipse.smartmdsd.ui.natures.AbstractSmartMDSDNature;
import org.eclipse.smartmdsd.ui.natures.SmartMDSDNatureEnum;
import org.eclipse.ui.model.WorkbenchContentProvider;

public class SmartMDSDFilteredProjectImportContentProvider
extends WorkbenchContentProvider {
    private IProject currentProject = null;
    private SmartMDSDNatureEnum currentNatureEnum = null;

    public SmartMDSDFilteredProjectImportContentProvider(IProject currentProject) {
        this.currentProject = currentProject;
    }

    public SmartMDSDFilteredProjectImportContentProvider(SmartMDSDNatureEnum currentNatureEnum) {
        this.currentNatureEnum = currentNatureEnum;
    }

    public Object[] getChildren(Object element) {
        IWorkspaceRoot root = null;
        if (element instanceof IWorkspace) {
            root = ((IWorkspace)element).getRoot();
        } else if (element instanceof IWorkspaceRoot) {
            root = (IWorkspaceRoot)element;
        } else {
            return new Object[0];
        }
        IProject[] allWorkspaceProjects = root.getProjects();
        if (allWorkspaceProjects != null) {
            ArrayList<IProject> filteredProjects = new ArrayList<IProject>();
            try {
                int n;
                AbstractSmartMDSDNature currentNatureObject = null;
                if (this.currentProject != null) {
                    SmartMDSDNatureEnum[] smartMDSDNatureEnumArray = SmartMDSDNatureEnum.values();
                    n = smartMDSDNatureEnumArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        SmartMDSDNatureEnum nature = smartMDSDNatureEnumArray[n2];
                        if (this.currentProject.hasNature(nature.getId())) {
                            currentNatureObject = nature.getSmartMDSDNatureFrom(this.currentProject);
                        }
                        ++n2;
                    }
                } else if (this.currentNatureEnum != null) {
                    currentNatureObject = this.currentNatureEnum.createSmartMDSDNatureObject();
                }
                if (currentNatureObject != null) {
                    List<String> relatedProjectNatureIds = currentNatureObject.getImportedProjectNatureIds();
                    IProject[] iProjectArray = allWorkspaceProjects;
                    int n3 = allWorkspaceProjects.length;
                    n = 0;
                    while (n < n3) {
                        IProject project = iProjectArray[n];
                        if (project.isOpen()) {
                            for (String natureId : relatedProjectNatureIds) {
                                if (!project.hasNature(natureId) || project == this.currentProject) continue;
                                filteredProjects.add(project);
                            }
                        }
                        ++n;
                    }
                    filteredProjects.addAll(SmartMDSDProjectImportContributionRegistry.getFilteredProjectImports(root, currentNatureObject.getNatureID(), this.currentProject));
                } else if (this.currentProject != null) {
                    filteredProjects.addAll(SmartMDSDProjectImportContributionRegistry.getFilteredProjectImports(root, "", this.currentProject));
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            return filteredProjects.toArray();
        }
        return new Object[0];
    }
}

