/********************************************************************************
 * Copyright (c) 2019 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 ********************************************************************************/
grammar InternalDocuTerminals;

options {
	superClass=AbstractInternalContentAssistParser;
}

@lexer::header {
package org.eclipse.smartmdsd.xtext.base.docuterminals.ide.contentassist.antlr.internal;

// Hack: Use our own Lexer superclass by means of import. 
// Currently there is no other way to specify the superclass for the lexer.
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.Lexer;
}

@parser::header {
package org.eclipse.smartmdsd.xtext.base.docuterminals.ide.contentassist.antlr.internal;

import java.io.InputStream;
import org.eclipse.xtext.*;
import org.eclipse.xtext.parser.*;
import org.eclipse.xtext.parser.impl.*;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.parser.antlr.XtextTokenStream;
import org.eclipse.xtext.parser.antlr.XtextTokenStream.HiddenTokens;
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.AbstractInternalContentAssistParser;
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.DFA;
import org.eclipse.smartmdsd.xtext.base.docuterminals.services.DocuTerminalsGrammarAccess;

}
@parser::members {
	private DocuTerminalsGrammarAccess grammarAccess;

	public void setGrammarAccess(DocuTerminalsGrammarAccess grammarAccess) {
		this.grammarAccess = grammarAccess;
	}

	@Override
	protected Grammar getGrammar() {
		return grammarAccess.getGrammar();
	}

	@Override
	protected String getValueForTokenName(String tokenName) {
		return tokenName;
	}
}

// Entry rule entryRuleAbstractDocumentationElement
entryRuleAbstractDocumentationElement
:
{ before(grammarAccess.getAbstractDocumentationElementRule()); }
	 ruleAbstractDocumentationElement
{ after(grammarAccess.getAbstractDocumentationElementRule()); } 
	 EOF 
;

// Rule AbstractDocumentationElement
ruleAbstractDocumentationElement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getAbstractDocumentationElementAccess().getGroup()); }
		(rule__AbstractDocumentationElement__Group__0)
		{ after(grammarAccess.getAbstractDocumentationElementAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__AbstractDocumentationElement__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AbstractDocumentationElement__Group__0__Impl
	rule__AbstractDocumentationElement__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AbstractDocumentationElement__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAbstractDocumentationElementAccess().getAbstractDocumentationElementAction_0()); }
	()
	{ after(grammarAccess.getAbstractDocumentationElementAccess().getAbstractDocumentationElementAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AbstractDocumentationElement__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AbstractDocumentationElement__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AbstractDocumentationElement__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAbstractDocumentationElementAccess().getDocumentationAssignment_1()); }
	(rule__AbstractDocumentationElement__DocumentationAssignment_1)?
	{ after(grammarAccess.getAbstractDocumentationElementAccess().getDocumentationAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AbstractDocumentationElement__DocumentationAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAbstractDocumentationElementAccess().getDocumentationDOCU_COMMENTTerminalRuleCall_1_0()); }
		RULE_DOCU_COMMENT
		{ after(grammarAccess.getAbstractDocumentationElementAccess().getDocumentationDOCU_COMMENTTerminalRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

RULE_ML_COMMENT : '/*' ~('*') ( options {greedy=false;} : . )*'*/';

fragment RULE_ML_DOCUMENTATION : '/**' ( options {greedy=false;} : . )*'*/';

RULE_SL_COMMENT : '//' ~('/') ~(('\n'|'\r'))* ('\r'? '\n')?;

fragment RULE_SL_DOCUMENTATION : '///' ~(('\n'|'\r'))* ('\r'? '\n')?;

RULE_DOCU_COMMENT : (RULE_ML_DOCUMENTATION|RULE_SL_DOCUMENTATION);

RULE_ID : '^'? ('a'..'z'|'A'..'Z'|'_') ('a'..'z'|'A'..'Z'|'_'|'0'..'9')*;

RULE_INT : ('0'..'9')+;

RULE_STRING : ('"' ('\\' .|~(('\\'|'"')))* '"'|'\'' ('\\' .|~(('\\'|'\'')))* '\'');

RULE_WS : (' '|'\t'|'\r'|'\n')+;

RULE_ANY_OTHER : .;
