/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.service.communicationObject.ui.outline;

import java.util.function.Consumer;
import org.eclipse.smartmdsd.ecore.service.communicationObject.AbstractCommElement;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommObjectModel;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommObjectsRepository;
import org.eclipse.xtext.ui.editor.outline.impl.DefaultOutlineTreeProvider;
import org.eclipse.xtext.ui.editor.outline.impl.DocumentRootNode;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * Customization of the default outline structure.
 * 
 * See https://www.eclipse.org/Xtext/documentation/310_eclipse_support.html#outline
 */
@SuppressWarnings("all")
public class CommunicationObjectOutlineTreeProvider extends DefaultOutlineTreeProvider {
  public void _createChildren(final DocumentRootNode outlineNode, final CommObjectModel model) {
    CommObjectsRepository _repository = model.getRepository();
    boolean _tripleNotEquals = (_repository != null);
    if (_tripleNotEquals) {
      final Consumer<AbstractCommElement> _function = (AbstractCommElement elem) -> {
        this.createNode(outlineNode, elem);
      };
      IterableExtensions.<AbstractCommElement>filterNull(model.getRepository().getElements()).forEach(_function);
    }
  }
}
