/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtext.service.communicationObject.ui.contentassist;

import com.google.inject.Inject;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractAttributeType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.ArrayValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeDefinition;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.EnumerationElement;
import org.eclipse.smartmdsd.ecore.service.communicationObject.AbstractCommElement;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommElementReference;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommunicationObject;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommunicationObjectPackage;
import org.eclipse.smartmdsd.ecore.service.communicationObject.Enumeration;
import org.eclipse.smartmdsd.xtext.indexer.XtextResourceIndex;
import org.eclipse.smartmdsd.xtext.service.communicationObject.ui.contentassist.AbstractCommunicationObjectProposalProvider;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;

public class CommunicationObjectProposalProvider
extends AbstractCommunicationObjectProposalProvider {
    @Inject
    private XtextResourceIndex index;

    @Override
    public void completeCommObjectsRepository_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        URI uri = model.eResource().getURI();
        boolean _isPlatform = uri.isPlatform();
        if (_isPlatform) {
            String projectName = uri.segment(1);
            acceptor.accept(this.createCompletionProposal(projectName, String.valueOf(projectName) + " - ProjectName", this.getImage(model), context));
        }
    }

    @Override
    public void completeCommRepositoryImport_ImportedNamespace(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        Iterable repos = this.index.getVisibleEObjectDescriptions(model, CommunicationObjectPackage.eINSTANCE.getCommObjectsRepository());
        Consumer<IEObjectDescription> _function = repo -> {
            String name = repo.getName().toString();
            String text = String.valueOf(name) + ".*;";
            acceptor.accept(this.createCompletionProposal(text, String.valueOf(name) + " - CommRepositoryImport", this.getImage((IEObjectDescription)repo), context));
        };
        repos.forEach(_function);
    }

    @Override
    public void completeVersion_Major(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        acceptor.accept(this.createCompletionProposal("1.0", "1.0 - Version", this.getImage(model), context));
    }

    public void completeSingleValue_Value(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        EObject attr = model;
        if (model instanceof ArrayValue) {
            attr = ((ArrayValue)model).eContainer();
        }
        if (attr instanceof AttributeDefinition) {
            AbstractAttributeType type = ((AttributeDefinition)attr).getType();
            if (type instanceof CommElementReference) {
                AbstractCommElement id = ((CommElementReference)type).getTypeName();
                if (id instanceof Enumeration) {
                    Consumer<EnumerationElement> _function = en -> {
                        String _name = en.getName();
                        String _name_1 = en.getName();
                        String _plus = String.valueOf(_name_1) + " - EnumLiteral";
                        acceptor.accept(this.createCompletionProposal(_name, _plus, this.getImage((EObject)en), context));
                    };
                    ((Enumeration)id).getEnums().forEach(_function);
                } else if (id instanceof CommunicationObject) {
                    String _name = ((CommunicationObject)id).getName();
                    String _plus = String.valueOf(_name) + "()";
                    String _name_1 = ((CommunicationObject)id).getName();
                    String _plus_1 = String.valueOf(_name_1) + " - CommunicationObject";
                    acceptor.accept(this.createCompletionProposal(_plus, _plus_1, this.getImage((EObject)id), context));
                }
            } else {
                super.completeSingleValue_Value(model, assignment, context, acceptor);
            }
        }
    }
}

