/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtext.service.communicationObject.validation;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractAttributeType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.BasicAttributesTypeConformance;
import org.eclipse.smartmdsd.ecore.service.communicationObject.AbstractCommElement;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommObjectsRepository;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommunicationObjectPackage;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommunicationObjectTypeConformance;
import org.eclipse.smartmdsd.xtext.service.communicationObject.validation.AbstractCommunicationObjectValidator;
import org.eclipse.xtext.validation.Check;

public class CommunicationObjectValidator
extends AbstractCommunicationObjectValidator {
    protected static final String ISSUE_PREFIX = "org.xtext.service.communicationObject.";
    public static final String INVALID_REPO_NAME = "org.xtext.service.communicationObject.InvalidRepoName";
    public static final String CAPITAL_COMM_ELEM_NAME = "org.xtext.service.communicationObject.CapitalCommElementName";
    public static final String CPP_KEYWORD_COMM_ELEM_NAME = "org.xtext.service.communicationObject.CppKeywordCommElementName";
    public static final String CPP_KEYWORD_ATTR_NAME = "org.xtext.service.communicationObject.CppKeywordAttributeName";
    public static final String RESERVED_ENUM_NAME = "org.xtext.service.communicationObject.ReservedEnumName";
    @Inject
    private CommunicationObjectTypeConformance conf;

    public Boolean isCompatible(AbstractValue av, AbstractAttributeType type) {
        return this.conf.isCompatible(av, type);
    }

    @Check
    public void checkRepositoryNameIsProjectName(CommObjectsRepository repo) {
        URI uri = repo.eResource().getURI();
        boolean _isPlatform = uri.isPlatform();
        if (_isPlatform) {
            boolean _notEquals;
            String projectName = uri.segment(1);
            String _name = repo.getName();
            boolean bl = _notEquals = !Objects.equal((Object)_name, (Object)projectName);
            if (_notEquals) {
                this.warning("Repository name should match project name.", (EStructuralFeature)CommunicationObjectPackage.Literals.COMM_OBJECTS_REPOSITORY__NAME, INVALID_REPO_NAME, new String[]{projectName});
            }
        }
    }

    @Check
    public void checkAbstractCommElemNameStartsWithCapital(AbstractCommElement elem) {
        boolean _not;
        boolean _isUpperCase = Character.isUpperCase(elem.getName().charAt(0));
        boolean bl = _not = !_isUpperCase;
        if (_not) {
            this.warning("CommElement name should start with a capital!", (EStructuralFeature)CommunicationObjectPackage.Literals.ABSTRACT_COMM_ELEMENT__NAME, CAPITAL_COMM_ELEM_NAME, new String[0]);
        }
    }

    @Check
    public void checkCppReservedKeywords(AbstractCommElement elem) {
        boolean _contains = BasicAttributesTypeConformance.cppKeywords.contains(elem.getName());
        if (_contains) {
            this.error("Element name must not be a C++ reserved keyword.", (EStructuralFeature)CommunicationObjectPackage.Literals.ABSTRACT_COMM_ELEMENT__NAME, CPP_KEYWORD_COMM_ELEM_NAME, new String[0]);
        }
    }
}

