/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.service.componentMode.formatting2;

import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.service.componentMode.ComponentModeCollection;
import org.eclipse.smartmdsd.ecore.service.componentMode.ComponentModeModel;
import org.eclipse.smartmdsd.ecore.service.componentMode.ComponentModeRepository;
import org.eclipse.xtext.formatting2.AbstractFormatter2;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;

@SuppressWarnings("all")
public class ComponentModeFormatter extends AbstractFormatter2 {
  protected void _format(final ComponentModeModel componentModeModel, @Extension final IFormattableDocument document) {
    document.<ComponentModeRepository>format(componentModeModel.getRepository());
  }
  
  protected void _format(final ComponentModeRepository componentModeRepository, @Extension final IFormattableDocument document) {
    EList<ComponentModeCollection> _collections = componentModeRepository.getCollections();
    for (final ComponentModeCollection componentModeCollection : _collections) {
      document.<ComponentModeCollection>format(componentModeCollection);
    }
  }
  
  public void format(final Object componentModeModel, final IFormattableDocument document) {
    if (componentModeModel instanceof XtextResource) {
      _format((XtextResource)componentModeModel, document);
      return;
    } else if (componentModeModel instanceof ComponentModeModel) {
      _format((ComponentModeModel)componentModeModel, document);
      return;
    } else if (componentModeModel instanceof ComponentModeRepository) {
      _format((ComponentModeRepository)componentModeModel, document);
      return;
    } else if (componentModeModel instanceof EObject) {
      _format((EObject)componentModeModel, document);
      return;
    } else if (componentModeModel == null) {
      _format((Void)null, document);
      return;
    } else if (componentModeModel != null) {
      _format(componentModeModel, document);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(componentModeModel, document).toString());
    }
  }
}
