/**
 * Copyright (c) 2021 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.service.componentMode.ui;

import com.google.inject.Injector;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.smartmdsd.ecore.service.componentMode.ComponentModePackage;
import org.eclipse.smartmdsd.ui.models.ISmartMDSDXtextContribution;
import org.eclipse.smartmdsd.ui.natures.SmartMDSDNatureEnum;
import org.eclipse.smartmdsd.xtext.service.componentMode.ui.internal.ComponentModeActivator;

@SuppressWarnings("all")
public class SmartMDSDComponentModeContribution implements ISmartMDSDXtextContribution {
  @Override
  public EPackage getEPackage() {
    return ComponentModePackage.eINSTANCE;
  }
  
  @Override
  public SmartMDSDNatureEnum getSmartMDSDNatureEnum() {
    return SmartMDSDNatureEnum.DomainModelsNature;
  }
  
  @Override
  public String getXtextEditorID() {
    return ComponentModeActivator.ORG_ECLIPSE_SMARTMDSD_XTEXT_SERVICE_COMPONENTMODE_COMPONENTMODE;
  }
  
  @Override
  public Injector getXtextInjector() {
    return ComponentModeActivator.getInstance().getInjector(this.getXtextEditorID());
  }
  
  @Override
  public boolean isDefaultLanguage() {
    return false;
  }
}
