/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtext.service.serviceDefinition.formatting2;

import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.smartmdsd.ecore.service.coordinationPattern.ParameterPattern;
import org.eclipse.smartmdsd.ecore.service.coordinationPattern.StatePattern;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.AbstractServiceDefinition;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.CommRepoImport;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.CommunicationServiceDefinition;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.CoordinationServiceDefinition;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.ServiceDefModel;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.ServiceDefRepository;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.ServiceDefinitionPackage;
import org.eclipse.smartmdsd.xtext.base.docuterminals.formatting2.DocuTerminalsFormatter;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class ServiceDefinitionFormatter
extends DocuTerminalsFormatter {
    protected void _format(ServiceDefModel serviceDefModel, @Extension IFormattableDocument document) {
        EList _imports = serviceDefModel.getImports();
        for (CommRepoImport commRepoImport : _imports) {
            document.format((Object)commRepoImport);
            Procedures.Procedure1 _function = it -> it.newLine();
            document.append((EObject)commRepoImport, _function);
        }
        document.format((Object)serviceDefModel.getRepository());
    }

    protected void _format(ServiceDefRepository serviceDefRepository, @Extension IFormattableDocument document) {
        document.format((Object)serviceDefRepository.getVersion());
        ISemanticRegion ropen = this.textRegionExtensions.regionFor((EObject)serviceDefRepository).keyword("{");
        ISemanticRegion rclose = this.textRegionExtensions.regionFor((EObject)serviceDefRepository).keyword("}");
        Procedures.Procedure1 _function = it -> it.newLine();
        document.prepend(ropen, _function);
        Procedures.Procedure1 _function_1 = it -> it.newLine();
        document.append(ropen, _function_1);
        Procedures.Procedure1 _function_2 = it -> it.indent();
        document.interior(ropen, rclose, _function_2);
        AbstractServiceDefinition lastElement = (AbstractServiceDefinition)IterableExtensions.last((Iterable)serviceDefRepository.getServices());
        EList _services = serviceDefRepository.getServices();
        for (AbstractServiceDefinition serviceDefinition : _services) {
            document.format((Object)serviceDefinition);
            Procedures.Procedure1 _function_3 = it -> it.oneSpace();
            document.surround(this.textRegionExtensions.regionFor((EObject)serviceDefinition).feature((EStructuralFeature)ServiceDefinitionPackage.Literals.ABSTRACT_SERVICE_DEFINITION__NAME), _function_3);
            if (serviceDefinition == lastElement) {
                Procedures.Procedure1 _function_4 = it -> it.newLine();
                document.append((EObject)serviceDefinition, _function_4);
                continue;
            }
            Procedures.Procedure1 _function_5 = it -> it.setNewLines(2);
            document.append((EObject)serviceDefinition, _function_5);
        }
    }

    protected void _format(CommunicationServiceDefinition serviceDefinition, @Extension IFormattableDocument document) {
        ISemanticRegion open = this.textRegionExtensions.regionFor((EObject)serviceDefinition).keyword("{");
        ISemanticRegion close = this.textRegionExtensions.regionFor((EObject)serviceDefinition).keyword("}");
        Procedures.Procedure1 _function = it -> it.newLine();
        document.append(open, _function);
        Procedures.Procedure1 _function_1 = it -> it.indent();
        document.interior(open, close, _function_1);
    }

    protected void _format(CoordinationServiceDefinition serviceDefinition, @Extension IFormattableDocument document) {
        StatePattern _statePattern;
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        ISemanticRegion open = this.textRegionExtensions.regionFor((EObject)serviceDefinition).keyword("{");
        ISemanticRegion close = this.textRegionExtensions.regionFor((EObject)serviceDefinition).keyword("}");
        Procedures.Procedure1 _function = it -> it.newLine();
        document.append(open, _function);
        Procedures.Procedure1 _function_1 = it -> it.indent();
        document.interior(open, close, _function_1);
        ParameterPattern _parameterPattern = serviceDefinition.getParameterPattern();
        boolean bl = _tripleNotEquals = _parameterPattern != null;
        if (_tripleNotEquals) {
            Procedures.Procedure1 _function_2 = it -> it.newLine();
            document.append((EObject)serviceDefinition.getParameterPattern(), _function_2);
            document.format((Object)serviceDefinition.getParameterPattern());
        }
        boolean bl2 = _tripleNotEquals_1 = (_statePattern = serviceDefinition.getStatePattern()) != null;
        if (_tripleNotEquals_1) {
            Procedures.Procedure1 _function_3 = it -> it.newLine();
            document.append((EObject)serviceDefinition.getStatePattern(), _function_3);
            document.format((Object)serviceDefinition.getStatePattern());
        }
    }

    public void format(Object serviceDefinition, IFormattableDocument document) {
        if (serviceDefinition instanceof CommunicationServiceDefinition) {
            this._format((CommunicationServiceDefinition)serviceDefinition, document);
            return;
        }
        if (serviceDefinition instanceof CoordinationServiceDefinition) {
            this._format((CoordinationServiceDefinition)serviceDefinition, document);
            return;
        }
        if (serviceDefinition instanceof XtextResource) {
            this._format((XtextResource)serviceDefinition, document);
            return;
        }
        if (serviceDefinition instanceof ServiceDefRepository) {
            this._format((ServiceDefRepository)serviceDefinition, document);
            return;
        }
        if (serviceDefinition instanceof ServiceDefModel) {
            this._format((ServiceDefModel)serviceDefinition, document);
            return;
        }
        if (serviceDefinition instanceof EObject) {
            this._format((EObject)serviceDefinition, document);
            return;
        }
        if (serviceDefinition == null) {
            this._format(null, document);
            return;
        }
        if (serviceDefinition != null) {
            this._format(serviceDefinition, document);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(serviceDefinition, document).toString());
    }
}

