/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ecore.system.datasheetPropertyChecks;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum EvaluationFunction implements Enumerator
{
    FOR_ALL(0, "FOR_ALL", "FOR_ALL"),
    SUM(1, "SUM", "SUM"),
    EXISTS(2, "EXISTS", "EXISTS");

    public static final int FOR_ALL_VALUE = 0;
    public static final int SUM_VALUE = 1;
    public static final int EXISTS_VALUE = 2;
    private static final EvaluationFunction[] VALUES_ARRAY;
    public static final List<EvaluationFunction> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new EvaluationFunction[]{FOR_ALL, SUM, EXISTS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static EvaluationFunction get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EvaluationFunction result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EvaluationFunction getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EvaluationFunction result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EvaluationFunction get(int value) {
        switch (value) {
            case 0: {
                return FOR_ALL;
            }
            case 1: {
                return SUM;
            }
            case 2: {
                return EXISTS;
            }
        }
        return null;
    }

    private EvaluationFunction(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

