/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.sirius.component.design;

import com.google.inject.Injector;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.AbstractComponentElement;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinition;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ComponentParametersRef;
import org.eclipse.smartmdsd.sirius.utils.xtext.AbstractXtextEditorViewPart;
import org.eclipse.smartmdsd.xtext.component.componentParameter.ui.internal.ComponentParameterActivator;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

public class ComponentParameterViewPart
extends AbstractXtextEditorViewPart {
    public Injector getInjector() {
        return ComponentParameterActivator.getInstance().getInjector("org.eclipse.smartmdsd.xtext.component.componentParameter.ComponentParameter");
    }

    protected ISelectionListener createNewSelectionListener() {
        return new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                if (part instanceof DDiagramEditor) {
                    DDiagramEditor dEditor = (DDiagramEditor)part;
                    Session session = dEditor.getSession();
                    for (DView view : session.getOwnedViews()) {
                        if (!view.getViewpoint().getName().equals("ComponentDefinitionViewpoint")) continue;
                        for (DRepresentationDescriptor repDescr : view.getOwnedRepresentationDescriptors()) {
                            DRepresentation rep = repDescr.getRepresentation();
                            if (!(rep instanceof DSemanticDiagram)) continue;
                            for (DRepresentationElement elem : rep.getOwnedRepresentationElements()) {
                                if (!(elem.getTarget() instanceof ComponentDefinition)) continue;
                                ComponentDefinition comp = (ComponentDefinition)elem.getTarget();
                                for (AbstractComponentElement compElem : comp.getElements()) {
                                    if (!(compElem instanceof ComponentParametersRef)) continue;
                                    if (ComponentParameterViewPart.this.getResourceProvider().isCurrentSession(session)) {
                                        ComponentParameterViewPart.this.showEmbeddedEditor();
                                    } else {
                                        URI componentModelUri = comp.eResource().getURI();
                                        String modelFileExtension = ComponentParameterViewPart.this.getModelFileExtension();
                                        URI xtextResourceUri = componentModelUri.trimFileExtension().appendFileExtension(modelFileExtension);
                                        ComponentParameterViewPart.this.setExternalEmfBase(elem, xtextResourceUri);
                                    }
                                    return;
                                }
                            }
                        }
                    }
                }
                ComponentParameterViewPart.this.hideEmbeddedEditor();
            }
        };
    }
}

