/**
 * Copyright (c) 2019 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Matthias Lutz, Alex Lotz, Dennis Stampfer
 */
package org.eclipse.smartmdsd.xtend.behavior.generator.domainModels;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinitionModelUtility;
import org.eclipse.smartmdsd.ecore.component.coordinationExtension.CoordinationInterfaceModelUtility;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommObjectsRepository;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommunicationObject;
import org.eclipse.smartmdsd.ecore.service.communicationPattern.CommunicationPattern;
import org.eclipse.smartmdsd.ecore.service.communicationPattern.EventPattern;
import org.eclipse.smartmdsd.ecore.service.communicationPattern.PushPattern;
import org.eclipse.smartmdsd.ecore.service.communicationPattern.QueryPattern;
import org.eclipse.smartmdsd.ecore.service.communicationPattern.SendPattern;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.CommunicationServiceUsage;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.CoordinationServiceDefinition;
import org.eclipse.smartmdsd.xtend.behavior.generator.ExtendedOutputConfigurationProvider;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.CopyrightHelpers;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.commObj.CommObjectGenHelpers;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.ComponentGenHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.AbstractGenerator;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class CoordinationInterfaceGeneratorImpl extends AbstractGenerator {
  @Inject
  @Extension
  private CopyrightHelpers _copyrightHelpers;
  
  @Inject
  @Extension
  private ComponentGenHelpers _componentGenHelpers;
  
  @Inject
  @Extension
  private CommObjectGenHelpers _commObjectGenHelpers;
  
  @Override
  public void doGenerate(final Resource resource, final IFileSystemAccess2 fsa, final IGeneratorContext context) {
    fsa.generateFile("info.txt", this.compileToolchainVersionFile(resource));
    fsa.generateFile("runTimeInterface.hh", this.compileModuleInterface(resource));
    fsa.generateFile("coordinationInterfaces.cmake", this.compileCollectCMakeCoordinationInterface(resource));
    Iterable<CoordinationServiceDefinition> _filter = Iterables.<CoordinationServiceDefinition>filter(IteratorExtensions.<EObject>toIterable(resource.getAllContents()), CoordinationServiceDefinition.class);
    for (final CoordinationServiceDefinition coordServiceDef : _filter) {
      {
        String _name = coordServiceDef.getName();
        String _plus = (_name + "/");
        String _plus_1 = (_plus + "CMakeLists.txt");
        fsa.generateFile(_plus_1, this.compileCMakeCoordinationInterfaceSlave(coordServiceDef));
        String _name_1 = coordServiceDef.getName();
        String _plus_2 = (_name_1 + "/");
        String _firstUpper = StringExtensions.toFirstUpper(coordServiceDef.getName());
        String _plus_3 = (_plus_2 + _firstUpper);
        String _plus_4 = (_plus_3 + ".hh");
        fsa.generateFile(_plus_4, this.compileCoordinationInterfaceSlaveHeader(coordServiceDef));
        String _name_2 = coordServiceDef.getName();
        String _plus_5 = (_name_2 + "/");
        String _firstUpper_1 = StringExtensions.toFirstUpper(coordServiceDef.getName());
        String _plus_6 = (_plus_5 + _firstUpper_1);
        String _plus_7 = (_plus_6 + ".cc");
        fsa.generateFile(_plus_7, this.compileCoordinationInterfaceSlaveSource(coordServiceDef));
        String _name_3 = coordServiceDef.getName();
        String _plus_8 = (_name_3 + "/");
        String _firstUpper_2 = StringExtensions.toFirstUpper(coordServiceDef.getName());
        String _plus_9 = (_plus_8 + _firstUpper_2);
        String _plus_10 = (_plus_9 + "Core.hh");
        fsa.generateFile(_plus_10, this.compileCoordinationInterfaceSlaveCoreHeader(coordServiceDef));
        String _name_4 = coordServiceDef.getName();
        String _plus_11 = (_name_4 + "/");
        String _firstUpper_3 = StringExtensions.toFirstUpper(coordServiceDef.getName());
        String _plus_12 = (_plus_11 + _firstUpper_3);
        String _plus_13 = (_plus_12 + "Core.cc");
        fsa.generateFile(_plus_13, this.compileCoordinationInterfaceSlaveCoreSource(coordServiceDef));
        this.generateServicesHandler(fsa, coordServiceDef);
        String _name_5 = coordServiceDef.getName();
        String _plus_14 = (_name_5 + "/");
        String _firstUpper_4 = StringExtensions.toFirstUpper(coordServiceDef.getName());
        String _plus_15 = (_plus_14 + _firstUpper_4);
        String _plus_16 = (_plus_15 + "RunTimeInterface.cc");
        fsa.generateFile(_plus_16, this.compileSwitchCoordinationServiceSource(coordServiceDef));
      }
    }
  }
  
  public void generateServicesHandler(final IFileSystemAccess2 fsa, final CoordinationServiceDefinition coordServiceDef) {
    final Function1<CommunicationServiceUsage, String> _function = (CommunicationServiceUsage e) -> {
      return e.getName();
    };
    List<CommunicationServiceUsage> _sortBy = IterableExtensions.<CommunicationServiceUsage, String>sortBy(coordServiceDef.getServices(), _function);
    for (final CommunicationServiceUsage service : _sortBy) {
      {
        CommunicationPattern pattern = ComponentDefinitionModelUtility.getPattern(service.getUses());
        if ((pattern instanceof EventPattern)) {
          String _name = coordServiceDef.getName();
          String _plus = (_name + "/");
          String _firstUpper = StringExtensions.toFirstUpper(coordServiceDef.getName());
          String _plus_1 = (_plus + _firstUpper);
          String _firstUpper_1 = StringExtensions.toFirstUpper(service.getName());
          String _plus_2 = (_plus_1 + _firstUpper_1);
          String _plus_3 = (_plus_2 + "EventHandlerCore.hh");
          fsa.generateFile(_plus_3, this.compileEventHandlerHeaderCore(service, ((EventPattern)pattern), coordServiceDef.getName()));
          String _name_1 = coordServiceDef.getName();
          String _plus_4 = (_name_1 + "/");
          String _firstUpper_2 = StringExtensions.toFirstUpper(coordServiceDef.getName());
          String _plus_5 = (_plus_4 + _firstUpper_2);
          String _firstUpper_3 = StringExtensions.toFirstUpper(service.getName());
          String _plus_6 = (_plus_5 + _firstUpper_3);
          String _plus_7 = (_plus_6 + "EventHandlerCore.cc");
          fsa.generateFile(_plus_7, this.compileEventHandlerSourceCore(service, ((EventPattern)pattern), coordServiceDef.getName()));
          String _name_2 = coordServiceDef.getName();
          String _plus_8 = (_name_2 + "/");
          String _firstUpper_4 = StringExtensions.toFirstUpper(coordServiceDef.getName());
          String _plus_9 = (_plus_8 + _firstUpper_4);
          String _firstUpper_5 = StringExtensions.toFirstUpper(service.getName());
          String _plus_10 = (_plus_9 + _firstUpper_5);
          String _plus_11 = (_plus_10 + "EventHandler.hh");
          fsa.generateFile(_plus_11, ExtendedOutputConfigurationProvider.SRC_OUTPUT, this.compileEventHandlerHeader(service, ((EventPattern)pattern), coordServiceDef.getName()));
          String _name_3 = coordServiceDef.getName();
          String _plus_12 = (_name_3 + "/");
          String _firstUpper_6 = StringExtensions.toFirstUpper(coordServiceDef.getName());
          String _plus_13 = (_plus_12 + _firstUpper_6);
          String _firstUpper_7 = StringExtensions.toFirstUpper(service.getName());
          String _plus_14 = (_plus_13 + _firstUpper_7);
          String _plus_15 = (_plus_14 + "EventHandler.cc");
          fsa.generateFile(_plus_15, ExtendedOutputConfigurationProvider.SRC_OUTPUT, this.compileEventHandlerSource(service, ((EventPattern)pattern), coordServiceDef.getName()));
        } else {
          if ((pattern instanceof SendPattern)) {
            String _name_4 = coordServiceDef.getName();
            String _plus_16 = (_name_4 + "/");
            String _firstUpper_8 = StringExtensions.toFirstUpper(coordServiceDef.getName());
            String _plus_17 = (_plus_16 + _firstUpper_8);
            String _firstUpper_9 = StringExtensions.toFirstUpper(service.getName());
            String _plus_18 = (_plus_17 + _firstUpper_9);
            String _plus_19 = (_plus_18 + "SendHandler.hh");
            fsa.generateFile(_plus_19, ExtendedOutputConfigurationProvider.SRC_OUTPUT, this.compileSendHeader(service, ((SendPattern)pattern), coordServiceDef.getName()));
            String _name_5 = coordServiceDef.getName();
            String _plus_20 = (_name_5 + "/");
            String _firstUpper_10 = StringExtensions.toFirstUpper(coordServiceDef.getName());
            String _plus_21 = (_plus_20 + _firstUpper_10);
            String _firstUpper_11 = StringExtensions.toFirstUpper(service.getName());
            String _plus_22 = (_plus_21 + _firstUpper_11);
            String _plus_23 = (_plus_22 + "SendHandler.cc");
            fsa.generateFile(_plus_23, ExtendedOutputConfigurationProvider.SRC_OUTPUT, this.compileSendSource(service, ((SendPattern)pattern), coordServiceDef.getName()));
          } else {
            if ((pattern instanceof QueryPattern)) {
              String _name_6 = coordServiceDef.getName();
              String _plus_24 = (_name_6 + "/");
              String _firstUpper_12 = StringExtensions.toFirstUpper(coordServiceDef.getName());
              String _plus_25 = (_plus_24 + _firstUpper_12);
              String _firstUpper_13 = StringExtensions.toFirstUpper(service.getName());
              String _plus_26 = (_plus_25 + _firstUpper_13);
              String _plus_27 = (_plus_26 + "QueryHandler.hh");
              fsa.generateFile(_plus_27, ExtendedOutputConfigurationProvider.SRC_OUTPUT, this.compileQueryHeader(service, ((QueryPattern)pattern), coordServiceDef.getName()));
              String _name_7 = coordServiceDef.getName();
              String _plus_28 = (_name_7 + "/");
              String _firstUpper_14 = StringExtensions.toFirstUpper(coordServiceDef.getName());
              String _plus_29 = (_plus_28 + _firstUpper_14);
              String _firstUpper_15 = StringExtensions.toFirstUpper(service.getName());
              String _plus_30 = (_plus_29 + _firstUpper_15);
              String _plus_31 = (_plus_30 + "QueryHandler.cc");
              fsa.generateFile(_plus_31, ExtendedOutputConfigurationProvider.SRC_OUTPUT, this.compileQuerySource(service, ((QueryPattern)pattern), coordServiceDef.getName()));
            }
          }
        }
      }
    }
  }
  
  public CharSequence compileToolchainVersionFile(final Resource res) {
    StringConcatenation _builder = new StringConcatenation();
    String _toolchainVersionFileString = this._copyrightHelpers.getToolchainVersionFileString();
    _builder.append(_toolchainVersionFileString);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  /**
   * compileModuleInterface moduleInterface.hh
   */
  public CharSequence compileModuleInterface(final Resource res) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("#ifndef _RUNTIMEINTERFACE_HH");
    _builder.newLine();
    _builder.append("#define _RUNTIMEINTERFACE_HH");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#include <map>");
    _builder.newLine();
    _builder.append("#include <string>");
    _builder.newLine();
    _builder.append("#include <ace/OS.h>");
    _builder.newLine();
    _builder.newLine();
    _builder.append("extern \tstd::string queryParam(const std::string& server, const std::string& param);");
    _builder.newLine();
    _builder.append("extern \tstd::string setState(const std::string& server, const std::string& state);");
    _builder.newLine();
    _builder.append("extern\tstd::string getState(const std::string& server);");
    _builder.newLine();
    _builder.append("extern \tstd::string waitForLifeCycleState(const std::string& server, const std::string& state);");
    _builder.newLine();
    _builder.append("extern  int appedEvent(const std::string& event);");
    _builder.newLine();
    _builder.newLine();
    _builder.append("typedef struct");
    _builder.newLine();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("std::string ciTypeName;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("std::string componentInstanceName;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("std::map< std::string,std::string >serviceNameMap;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("}CiConnection;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("struct ciLessLibC : public std::binary_function<std::string, std::string, bool> {");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("bool operator()(const std::string &lhs, const std::string &rhs) const {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return ACE_OS::strcasecmp(lhs.c_str(), rhs.c_str()) < 0 ;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("};");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#endif");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence compileCollectCMakeCoordinationInterface(final Resource resource) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyrightWriteOnceHash = this._copyrightHelpers.getCopyrightWriteOnceHash();
    _builder.append(_copyrightWriteOnceHash);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("CMAKE_MINIMUM_REQUIRED(VERSION 3.0)");
    _builder.newLine();
    {
      Iterable<CoordinationServiceDefinition> _filter = Iterables.<CoordinationServiceDefinition>filter(IteratorExtensions.<EObject>toIterable(resource.getAllContents()), CoordinationServiceDefinition.class);
      for(final CoordinationServiceDefinition service : _filter) {
        _builder.append("MESSAGE(\"-- Include ");
        String _firstUpper = StringExtensions.toFirstUpper(service.getName());
        _builder.append(_firstUpper);
        _builder.append("\")");
        _builder.newLineIfNotEmpty();
        _builder.append("ADD_SUBDIRECTORY(${CMAKE_CURRENT_LIST_DIR}/");
        String _firstUpper_1 = StringExtensions.toFirstUpper(service.getName());
        _builder.append(_firstUpper_1);
        _builder.append(" ${CMAKE_CURRENT_BINARY_DIR}/");
        String _firstUpper_2 = StringExtensions.toFirstUpper(service.getName());
        _builder.append(_firstUpper_2);
        _builder.append(")");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  /**
   * CoordinationInterfaceLibrary.cmake
   */
  public CharSequence compileCMakeCoordinationInterfaceSlave(final CoordinationServiceDefinition coordServiceDef) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyrightHash = this._copyrightHelpers.getCopyrightHash();
    _builder.append(_copyrightHash);
    _builder.newLineIfNotEmpty();
    _builder.append("CMAKE_MINIMUM_REQUIRED(VERSION 3.0)");
    _builder.newLine();
    _builder.newLine();
    _builder.append("PROJECT(");
    String _name = coordServiceDef.getName();
    _builder.append(_name);
    _builder.append(")");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("# find SmartSoft package");
    _builder.newLine();
    _builder.append("#FIND_SMARTSOFT(3.0)");
    _builder.newLine();
    _builder.append("FIND_PACKAGE(AceSmartSoft PATHS $ENV{SMART_ROOT_ACE} PATH_SUFFIXES modules)");
    _builder.newLine();
    _builder.newLine();
    {
      HashSet<CommObjectsRepository> _usedCommObjRepositories = this.getUsedCommObjRepositories(coordServiceDef);
      for(final CommObjectsRepository repo : _usedCommObjRepositories) {
        {
          String _name_1 = repo.getName();
          String _currentProjectName = this.getCurrentProjectName(coordServiceDef);
          boolean _notEquals = (!Objects.equal(_name_1, _currentProjectName));
          if (_notEquals) {
            _builder.append("# find dependency ");
            String _name_2 = repo.getName();
            _builder.append(_name_2);
            _builder.newLineIfNotEmpty();
            _builder.append("FIND_PACKAGE(");
            String _name_3 = repo.getName();
            _builder.append(_name_3);
            _builder.append(" PATHS $ENV{SMART_ROOT_ACE}/modules)");
            _builder.newLineIfNotEmpty();
            _builder.append("FIND_PACKAGE(");
            String _name_4 = repo.getName();
            _builder.append(_name_4);
            _builder.append("JSON PATHS $ENV{SMART_ROOT_ACE}/modules)");
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    _builder.newLine();
    _builder.append("# these are the regular includes (add your own includes, if needed)");
    _builder.newLine();
    _builder.append("INCLUDE_DIRECTORIES(");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("${CMAKE_CURRENT_LIST_DIR}");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("${CMAKE_CURRENT_LIST_DIR}/../");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("${CMAKE_CURRENT_LIST_DIR}/../../src/");
    String _firstUpper = StringExtensions.toFirstUpper(coordServiceDef.getName());
    _builder.append(_firstUpper, "  ");
    _builder.newLineIfNotEmpty();
    _builder.append(")");
    _builder.newLine();
    _builder.newLine();
    _builder.append("# collect the toolchain-generated source-files");
    _builder.newLine();
    _builder.append("FILE(GLOB_RECURSE SRC ${CMAKE_CURRENT_LIST_DIR}/*.cc)");
    _builder.newLine();
    _builder.append("FILE(GLOB_RECURSE SRC_GEN ${CMAKE_CURRENT_LIST_DIR}/../../src/");
    String _firstUpper_1 = StringExtensions.toFirstUpper(coordServiceDef.getName());
    _builder.append(_firstUpper_1);
    _builder.append("/*.cc)");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("IF(WIN32)");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("ADD_LIBRARY(${PROJECT_NAME} STATIC ${SRC} ${SRC_GEN})");
    _builder.newLine();
    _builder.append("ELSE()");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("ADD_LIBRARY(${PROJECT_NAME} SHARED ${SRC} ${SRC_GEN})");
    _builder.newLine();
    _builder.append("ENDIF()");
    _builder.newLine();
    _builder.newLine();
    _builder.append("# SmartSoftKernel is one of the default dependencies for each component");
    _builder.newLine();
    _builder.append("TARGET_LINK_LIBRARIES(${PROJECT_NAME} AceSmartSoftKernel)");
    _builder.newLine();
    _builder.newLine();
    {
      HashSet<CommObjectsRepository> _usedCommObjRepositories_1 = this.getUsedCommObjRepositories(coordServiceDef);
      for(final CommObjectsRepository repo_1 : _usedCommObjRepositories_1) {
        _builder.append("# link library");
        String _name_5 = repo_1.getName();
        _builder.append(_name_5);
        _builder.newLineIfNotEmpty();
        _builder.append("TARGET_LINK_LIBRARIES(${PROJECT_NAME} ");
        String _name_6 = repo_1.getName();
        _builder.append(_name_6);
        _builder.append(" ");
        String _name_7 = repo_1.getName();
        _builder.append(_name_7);
        _builder.append("JSON)");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("# automatically install the component target");
    _builder.newLine();
    _builder.append("# automatically run \"make install\" after regular \"make\" for the communication object");
    _builder.newLine();
    _builder.append("ADD_DEPENDENCIES(autoinstall ${PROJECT_NAME})");
    _builder.newLine();
    _builder.newLine();
    _builder.append("# install component executable target");
    _builder.newLine();
    _builder.append("INSTALL(TARGETS ${PROJECT_NAME} DESTINATION lib)");
    _builder.newLine();
    return _builder;
  }
  
  public HashSet<CommObjectsRepository> getUsedCommObjRepositories(final CoordinationServiceDefinition coordServiceDef) {
    HashSet<CommObjectsRepository> repos = new HashSet<CommObjectsRepository>();
    Collection<CommunicationObject> _allCommObjects = CoordinationInterfaceModelUtility.getAllCommObjects(coordServiceDef);
    for (final CommunicationObject obj : _allCommObjects) {
      {
        final EObject parent = obj.eContainer();
        if ((parent instanceof CommObjectsRepository)) {
          repos.add(((CommObjectsRepository)parent));
        }
      }
    }
    return repos;
  }
  
  public String getCurrentProjectName(final CoordinationServiceDefinition coordServiceDef) {
    return coordServiceDef.eResource().getURI().segment(1);
  }
  
  /**
   * compileCoordinationInterfaceSlaveHeader
   */
  public CharSequence compileCoordinationInterfaceSlaveHeader(final CoordinationServiceDefinition coordServiceDef) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("#ifndef ");
    String _upperCase = coordServiceDef.getName().toUpperCase();
    _builder.append(_upperCase);
    _builder.append("_H_");
    _builder.newLineIfNotEmpty();
    _builder.append("#define ");
    String _upperCase_1 = coordServiceDef.getName().toUpperCase();
    _builder.append(_upperCase_1);
    _builder.append("_H_");
    _builder.newLineIfNotEmpty();
    _builder.append("#include \"aceSmartSoft.hh\"");
    _builder.newLine();
    _builder.newLine();
    _builder.append("// include communication objects");
    _builder.newLine();
    {
      final Function1<CommunicationObject, String> _function = (CommunicationObject it) -> {
        return it.getName();
      };
      List<CommunicationObject> _sortBy = IterableExtensions.<CommunicationObject, String>sortBy(CoordinationInterfaceModelUtility.getAllCommObjects(coordServiceDef), _function);
      for(final CommunicationObject obj : _sortBy) {
        _builder.append("#include <");
        CharSequence _userClassHeaderFileNameFQN = this._commObjectGenHelpers.getUserClassHeaderFileNameFQN(obj);
        _builder.append(_userClassHeaderFileNameFQN);
        _builder.append(">");
        _builder.newLineIfNotEmpty();
        _builder.append("#include <");
        CharSequence _serailizationHeaderFileNameFQN = this._commObjectGenHelpers.getSerailizationHeaderFileNameFQN(obj);
        _builder.append(_serailizationHeaderFileNameFQN);
        _builder.append(">");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.newLine();
    {
      final Function1<CommunicationServiceUsage, String> _function_1 = (CommunicationServiceUsage e) -> {
        return e.getName();
      };
      List<CommunicationServiceUsage> _sortBy_1 = IterableExtensions.<CommunicationServiceUsage, String>sortBy(coordServiceDef.getServices(), _function_1);
      for(final CommunicationServiceUsage service : _sortBy_1) {
        CommunicationPattern pattern = ComponentDefinitionModelUtility.getPattern(service.getUses());
        _builder.newLineIfNotEmpty();
        CharSequence _switchResult = null;
        boolean _matched = false;
        if (pattern instanceof EventPattern) {
          _matched=true;
          StringConcatenation _builder_1 = new StringConcatenation();
          _builder_1.append("#include \"");
          String _firstUpper = StringExtensions.toFirstUpper(coordServiceDef.getName());
          String _firstUpper_1 = StringExtensions.toFirstUpper(service.getName());
          String _plus = (_firstUpper + _firstUpper_1);
          String _plus_1 = (_plus + "EventHandlerCore.hh");
          _builder_1.append(_plus_1);
          _builder_1.append("\"");
          _switchResult = _builder_1;
        }
        if (!_matched) {
          if (pattern instanceof SendPattern) {
            _matched=true;
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("#include \"");
            String _firstUpper = StringExtensions.toFirstUpper(coordServiceDef.getName());
            String _firstUpper_1 = StringExtensions.toFirstUpper(service.getName());
            String _plus = (_firstUpper + _firstUpper_1);
            String _plus_1 = (_plus + "SendHandler.hh");
            _builder_1.append(_plus_1);
            _builder_1.append("\"");
            _switchResult = _builder_1;
          }
        }
        if (!_matched) {
          if (pattern instanceof QueryPattern) {
            _matched=true;
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("#include \"");
            String _firstUpper = StringExtensions.toFirstUpper(coordServiceDef.getName());
            String _firstUpper_1 = StringExtensions.toFirstUpper(service.getName());
            String _plus = (_firstUpper + _firstUpper_1);
            String _plus_1 = (_plus + "QueryHandler.hh");
            _builder_1.append(_plus_1);
            _builder_1.append("\"");
            _switchResult = _builder_1;
          }
        }
        if (!_matched) {
          _switchResult = "";
        }
        _builder.append(_switchResult);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.newLine();
    _builder.append("class ");
    String _firstUpper = StringExtensions.toFirstUpper(coordServiceDef.getName());
    _builder.append(_firstUpper);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.append(" \t");
    _builder.newLine();
    _builder.append("public:");
    _builder.newLine();
    _builder.append("\t");
    String _firstUpper_1 = StringExtensions.toFirstUpper(coordServiceDef.getName());
    _builder.append(_firstUpper_1, "\t");
    _builder.append(" ();");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("~");
    String _firstUpper_2 = StringExtensions.toFirstUpper(coordServiceDef.getName());
    _builder.append(_firstUpper_2, "\t");
    _builder.append(" ();");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("//variables, ports, handlers");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("//param, state, wiring is dealt with the single master");
    _builder.newLine();
    {
      final Function1<CommunicationServiceUsage, String> _function_2 = (CommunicationServiceUsage e) -> {
        return e.getName();
      };
      List<CommunicationServiceUsage> _sortBy_2 = IterableExtensions.<CommunicationServiceUsage, String>sortBy(coordServiceDef.getServices(), _function_2);
      for(final CommunicationServiceUsage service_1 : _sortBy_2) {
        _builder.append("\t");
        CommunicationPattern pattern_1 = ComponentDefinitionModelUtility.getPattern(service_1.getUses());
        _builder.newLineIfNotEmpty();
        {
          if ((pattern_1 instanceof PushPattern)) {
            _builder.append("\t");
            _builder.append("//PUSH IS NOT USED!");
            _builder.newLine();
          } else {
            if ((pattern_1 instanceof EventPattern)) {
              _builder.append("\t");
              _builder.append("Smart::IEventClientPattern<");
              CharSequence _commObjectCppList = this._componentGenHelpers.getCommObjectCppList(pattern_1, Boolean.valueOf(false));
              _builder.append(_commObjectCppList, "\t");
              _builder.append("> *");
              String _firstLower = StringExtensions.toFirstLower(coordServiceDef.getName());
              _builder.append(_firstLower, "\t");
              String _firstLower_1 = StringExtensions.toFirstLower(service_1.getName());
              _builder.append(_firstLower_1, "\t");
              _builder.append("Client;");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              String _firstUpper_3 = StringExtensions.toFirstUpper(coordServiceDef.getName());
              _builder.append(_firstUpper_3, "\t");
              String _firstUpper_4 = StringExtensions.toFirstUpper(service_1.getName());
              _builder.append(_firstUpper_4, "\t");
              _builder.append("EventHandlerCore *");
              String _firstLower_2 = StringExtensions.toFirstLower(coordServiceDef.getName());
              _builder.append(_firstLower_2, "\t");
              String _firstLower_3 = StringExtensions.toFirstLower(service_1.getName());
              _builder.append(_firstLower_3, "\t");
              _builder.append("EventHandlerCore;");
              _builder.newLineIfNotEmpty();
            } else {
              if ((pattern_1 instanceof SendPattern)) {
                _builder.append("\t");
                _builder.append("SmartACE::SendClient<");
                CharSequence _commObjectCppList_1 = this._componentGenHelpers.getCommObjectCppList(pattern_1, Boolean.valueOf(false));
                _builder.append(_commObjectCppList_1, "\t");
                _builder.append("> *");
                String _firstLower_4 = StringExtensions.toFirstLower(coordServiceDef.getName());
                _builder.append(_firstLower_4, "\t");
                String _firstLower_5 = StringExtensions.toFirstLower(service_1.getName());
                _builder.append(_firstLower_5, "\t");
                _builder.append("Client;");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                String _firstUpper_5 = StringExtensions.toFirstUpper(coordServiceDef.getName());
                _builder.append(_firstUpper_5, "\t");
                String _firstUpper_6 = StringExtensions.toFirstUpper(service_1.getName());
                _builder.append(_firstUpper_6, "\t");
                _builder.append("SendHandler *");
                String _firstLower_6 = StringExtensions.toFirstLower(coordServiceDef.getName());
                _builder.append(_firstLower_6, "\t");
                String _firstLower_7 = StringExtensions.toFirstLower(service_1.getName());
                _builder.append(_firstLower_7, "\t");
                _builder.append("SendHandler;");
                _builder.newLineIfNotEmpty();
              } else {
                if ((pattern_1 instanceof QueryPattern)) {
                  _builder.append("\t");
                  _builder.append("Smart::IQueryClientPattern<");
                  CharSequence _commObjectCppList_2 = this._componentGenHelpers.getCommObjectCppList(pattern_1, Boolean.valueOf(false));
                  _builder.append(_commObjectCppList_2, "\t");
                  _builder.append("> *");
                  String _firstLower_8 = StringExtensions.toFirstLower(coordServiceDef.getName());
                  _builder.append(_firstLower_8, "\t");
                  String _firstLower_9 = StringExtensions.toFirstLower(service_1.getName());
                  _builder.append(_firstLower_9, "\t");
                  _builder.append("Client;");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t");
                  String _firstUpper_7 = StringExtensions.toFirstUpper(coordServiceDef.getName());
                  _builder.append(_firstUpper_7, "\t");
                  String _firstUpper_8 = StringExtensions.toFirstUpper(service_1.getName());
                  _builder.append(_firstUpper_8, "\t");
                  _builder.append("QueryHandler *");
                  String _firstLower_10 = StringExtensions.toFirstLower(coordServiceDef.getName());
                  _builder.append(_firstLower_10, "\t");
                  String _firstLower_11 = StringExtensions.toFirstLower(service_1.getName());
                  _builder.append(_firstLower_11, "\t");
                  _builder.append("QueryHandler;");
                  _builder.newLineIfNotEmpty();
                }
              }
            }
          }
        }
      }
    }
    _builder.append(" ");
    _builder.append("};");
    _builder.newLine();
    _builder.append("#endif /* ");
    String _upperCase_2 = coordServiceDef.getName().toUpperCase();
    _builder.append(_upperCase_2);
    _builder.append("_H_ */");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  /**
   * compileCoordinationInterfaceSlaveSource
   */
  public CharSequence compileCoordinationInterfaceSlaveSource(final CoordinationServiceDefinition coordServiceDef) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("#include \"");
    String _firstUpper = StringExtensions.toFirstUpper(coordServiceDef.getName());
    _builder.append(_firstUpper);
    _builder.append(".hh\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    String _firstUpper_1 = StringExtensions.toFirstUpper(coordServiceDef.getName());
    _builder.append(_firstUpper_1);
    _builder.append("::");
    String _firstUpper_2 = StringExtensions.toFirstUpper(coordServiceDef.getName());
    _builder.append(_firstUpper_2);
    _builder.append(" (){");
    _builder.newLineIfNotEmpty();
    {
      final Function1<CommunicationServiceUsage, String> _function = (CommunicationServiceUsage e) -> {
        return e.getName();
      };
      List<CommunicationServiceUsage> _sortBy = IterableExtensions.<CommunicationServiceUsage, String>sortBy(coordServiceDef.getServices(), _function);
      for(final CommunicationServiceUsage service : _sortBy) {
        _builder.append("\t\t");
        CommunicationPattern pattern = ComponentDefinitionModelUtility.getPattern(service.getUses());
        _builder.newLineIfNotEmpty();
        {
          if ((pattern instanceof PushPattern)) {
            _builder.append("\t\t");
            _builder.append("//PUSH IS NOT USED!");
            _builder.newLine();
          } else {
            if ((pattern instanceof EventPattern)) {
              _builder.append("\t\t");
              String _firstLower = StringExtensions.toFirstLower(coordServiceDef.getName());
              _builder.append(_firstLower, "\t\t");
              String _firstLower_1 = StringExtensions.toFirstLower(service.getName());
              _builder.append(_firstLower_1, "\t\t");
              _builder.append("Client = NULL;");
              _builder.newLineIfNotEmpty();
              _builder.append("\t\t");
              String _firstLower_2 = StringExtensions.toFirstLower(coordServiceDef.getName());
              _builder.append(_firstLower_2, "\t\t");
              String _firstLower_3 = StringExtensions.toFirstLower(service.getName());
              _builder.append(_firstLower_3, "\t\t");
              _builder.append("EventHandlerCore = NULL;");
              _builder.newLineIfNotEmpty();
            } else {
              if ((pattern instanceof SendPattern)) {
                _builder.append("\t\t");
                String _firstLower_4 = StringExtensions.toFirstLower(coordServiceDef.getName());
                _builder.append(_firstLower_4, "\t\t");
                String _firstLower_5 = StringExtensions.toFirstLower(service.getName());
                _builder.append(_firstLower_5, "\t\t");
                _builder.append("SendHandler = NULL;");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                String _firstLower_6 = StringExtensions.toFirstLower(coordServiceDef.getName());
                _builder.append(_firstLower_6, "\t\t");
                String _firstLower_7 = StringExtensions.toFirstLower(service.getName());
                _builder.append(_firstLower_7, "\t\t");
                _builder.append("Client = NULL;");
                _builder.newLineIfNotEmpty();
              } else {
                if ((pattern instanceof QueryPattern)) {
                  _builder.append("\t\t");
                  String _firstLower_8 = StringExtensions.toFirstLower(coordServiceDef.getName());
                  _builder.append(_firstLower_8, "\t\t");
                  String _firstLower_9 = StringExtensions.toFirstLower(service.getName());
                  _builder.append(_firstLower_9, "\t\t");
                  _builder.append("QueryHandler = NULL;");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t\t");
                  String _firstLower_10 = StringExtensions.toFirstLower(coordServiceDef.getName());
                  _builder.append(_firstLower_10, "\t\t");
                  String _firstLower_11 = StringExtensions.toFirstLower(service.getName());
                  _builder.append(_firstLower_11, "\t\t");
                  _builder.append("Client = NULL;");
                  _builder.newLineIfNotEmpty();
                }
              }
            }
          }
        }
      }
    }
    _builder.append("}");
    _builder.newLine();
    String _firstUpper_3 = StringExtensions.toFirstUpper(coordServiceDef.getName());
    _builder.append(_firstUpper_3);
    _builder.append("::~");
    String _firstUpper_4 = StringExtensions.toFirstUpper(coordServiceDef.getName());
    _builder.append(_firstUpper_4);
    _builder.append(" (){");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    return _builder;
  }
  
  /**
   * compileCoordinationInterfaceSlaveCoreHeader
   */
  public CharSequence compileCoordinationInterfaceSlaveCoreHeader(final CoordinationServiceDefinition coordServiceDef) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("#ifndef ");
    String _upperCase = coordServiceDef.getName().toUpperCase();
    _builder.append(_upperCase);
    _builder.append("CORE_H_");
    _builder.newLineIfNotEmpty();
    _builder.append("#define ");
    String _upperCase_1 = coordServiceDef.getName().toUpperCase();
    _builder.append(_upperCase_1);
    _builder.append("CORE_H_");
    _builder.newLineIfNotEmpty();
    _builder.append("#include \"aceSmartSoft.hh\"");
    _builder.newLine();
    _builder.append("#include \"runTimeInterface.hh\"");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#include <string>");
    _builder.newLine();
    _builder.append("#include <map>");
    _builder.newLine();
    _builder.append("#include <iostream>");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#include \"");
    String _firstUpper = StringExtensions.toFirstUpper(coordServiceDef.getName());
    _builder.append(_firstUpper);
    _builder.append(".hh\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append(" ");
    _builder.append("class ");
    String _firstUpper_1 = StringExtensions.toFirstUpper(coordServiceDef.getName());
    _builder.append(_firstUpper_1, " ");
    _builder.append("Core {");
    _builder.newLineIfNotEmpty();
    _builder.append(" \t");
    _builder.append("friend class ACE_Singleton<");
    String _firstUpper_2 = StringExtensions.toFirstUpper(coordServiceDef.getName());
    _builder.append(_firstUpper_2, " \t");
    _builder.append("Core, ACE_Thread_Mutex>;");
    _builder.newLineIfNotEmpty();
    _builder.append("private:");
    _builder.newLine();
    _builder.append("\t");
    String _firstUpper_3 = StringExtensions.toFirstUpper(coordServiceDef.getName());
    _builder.append(_firstUpper_3, "\t");
    _builder.append("Core (){");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("std::cout<<\"Create ");
    String _firstUpper_4 = StringExtensions.toFirstUpper(coordServiceDef.getName());
    _builder.append(_firstUpper_4, "\t\t");
    _builder.append(" Module Singelton...\"<<std::endl;");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("~");
    String _firstUpper_5 = StringExtensions.toFirstUpper(coordServiceDef.getName());
    _builder.append(_firstUpper_5, "\t");
    _builder.append("Core (){");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("std::cout<<\"Destroy ");
    String _firstUpper_6 = StringExtensions.toFirstUpper(coordServiceDef.getName());
    _builder.append(_firstUpper_6, "\t\t");
    _builder.append(" Module Singelton...\"<<std::endl;");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("std::map<std::string, ");
    String _firstUpper_7 = StringExtensions.toFirstUpper(coordServiceDef.getName());
    _builder.append(_firstUpper_7, "\t");
    _builder.append(", ciLessLibC> ciInstanceMap;");
    _builder.newLineIfNotEmpty();
    _builder.append("public:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("void addNewModuleInstance(const std::string& name);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("int initCiInstance(SmartACE::SmartComponent * component, const std::string& ciInstanceName, const std::map< std::string, CiConnection, ciLessLibC> &ciConnectionsMap);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("int finiCiInstance(const std::string& ciInstanceName);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("std::string switchCi(const std::string& ciInstanceName, const std::string& componentName, const std::string& componentInstanceName, const std::string& service, const std::string& parameter, const std::string& eventMode);");
    _builder.newLine();
    _builder.newLine();
    _builder.append(" ");
    _builder.append("};");
    _builder.newLine();
    _builder.append("#endif /* ");
    String _upperCase_2 = coordServiceDef.getName().toUpperCase();
    _builder.append(_upperCase_2);
    _builder.append("CORE_H_ */");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  /**
   * compileModuleCoreSource
   */
  public CharSequence compileCoordinationInterfaceSlaveCoreSource(final CoordinationServiceDefinition coordServiceDef) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("#include \"");
    String _firstUpper = StringExtensions.toFirstUpper(coordServiceDef.getName());
    _builder.append(_firstUpper);
    _builder.append("Core.hh\"");
    _builder.newLineIfNotEmpty();
    _builder.append("#include <string>");
    _builder.newLine();
    _builder.append("#include <ace/OS.h>");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#include <smartNumericCorrelationId.h>");
    _builder.newLine();
    _builder.newLine();
    _builder.append(" ");
    _builder.append("void ");
    String _firstUpper_1 = StringExtensions.toFirstUpper(coordServiceDef.getName());
    _builder.append(_firstUpper_1, " ");
    _builder.append("Core::addNewModuleInstance(const std::string& name){");
    _builder.newLineIfNotEmpty();
    _builder.append(" \t");
    _builder.append("std::cout<<\"addNewModuleInstance name:\"<<name<<std::endl;");
    _builder.newLine();
    _builder.append("\t");
    String _firstUpper_2 = StringExtensions.toFirstUpper(coordServiceDef.getName());
    _builder.append(_firstUpper_2, "\t");
    _builder.append(" mi;");
    _builder.newLineIfNotEmpty();
    _builder.append("\t ");
    _builder.append("ciInstanceMap.insert ( std::pair<std::string,");
    String _firstUpper_3 = StringExtensions.toFirstUpper(coordServiceDef.getName());
    _builder.append(_firstUpper_3, "\t ");
    _builder.append(">(name,mi));");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("}");
    _builder.newLine();
    _builder.append(" ");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("int ");
    String _firstUpper_4 = StringExtensions.toFirstUpper(coordServiceDef.getName());
    _builder.append(_firstUpper_4, " ");
    _builder.append("Core::initCiInstance(SmartACE::SmartComponent * component, const std::string& ciInstanceName, const std::map< std::string, CiConnection, ciLessLibC > &ciConnectionsMap){");
    _builder.newLineIfNotEmpty();
    _builder.append(" \t");
    _builder.append("std::map<std::string, ");
    String _firstUpper_5 = StringExtensions.toFirstUpper(coordServiceDef.getName());
    _builder.append(_firstUpper_5, " \t");
    _builder.append(", ciLessLibC>::iterator iter = ciInstanceMap.find(ciInstanceName);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("if(iter != ciInstanceMap.end()){");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("std::cout<<__FUNCTION__<<\" create ports and handlers...\"<<std::endl;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// create ports");
    _builder.newLine();
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("//component name: ");
    String _name = coordServiceDef.getName();
    _builder.append(_name, "\t");
    _builder.newLineIfNotEmpty();
    {
      final Function1<CommunicationServiceUsage, String> _function = (CommunicationServiceUsage e) -> {
        return e.getName();
      };
      List<CommunicationServiceUsage> _sortBy = IterableExtensions.<CommunicationServiceUsage, String>sortBy(coordServiceDef.getServices(), _function);
      for(final CommunicationServiceUsage service : _sortBy) {
        _builder.append("\t");
        CommunicationPattern pattern = ComponentDefinitionModelUtility.getPattern(service.getUses());
        _builder.newLineIfNotEmpty();
        {
          if ((pattern instanceof PushPattern)) {
            _builder.append("\t");
            _builder.append("//PUSH IS NOT USED!");
            _builder.newLine();
          } else {
            if ((pattern instanceof EventPattern)) {
              _builder.append("\t");
              _builder.append("//EVENT CLIENT");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("iter->second.");
              String _firstLower = StringExtensions.toFirstLower(coordServiceDef.getName());
              _builder.append(_firstLower, "\t");
              String _firstLower_1 = StringExtensions.toFirstLower(service.getName());
              _builder.append(_firstLower_1, "\t");
              _builder.append("Client = new SmartACE::EventClient<");
              CharSequence _fullyQualifiedNameCpp = this._commObjectGenHelpers.getFullyQualifiedNameCpp(((EventPattern)pattern).getActivationType());
              _builder.append(_fullyQualifiedNameCpp, "\t");
              _builder.append(",");
              CharSequence _fullyQualifiedNameCpp_1 = this._commObjectGenHelpers.getFullyQualifiedNameCpp(((EventPattern)pattern).getEventType());
              _builder.append(_fullyQualifiedNameCpp_1, "\t");
              _builder.append(">(component);");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("iter->second.");
              String _firstLower_2 = StringExtensions.toFirstLower(coordServiceDef.getName());
              _builder.append(_firstLower_2, "\t");
              String _firstLower_3 = StringExtensions.toFirstLower(service.getName());
              _builder.append(_firstLower_3, "\t");
              _builder.append("EventHandlerCore = new ");
              String _firstUpper_6 = StringExtensions.toFirstUpper(coordServiceDef.getName());
              _builder.append(_firstUpper_6, "\t");
              String _firstUpper_7 = StringExtensions.toFirstUpper(service.getName());
              _builder.append(_firstUpper_7, "\t");
              _builder.append("EventHandlerCore(iter->second.");
              String _firstLower_4 = StringExtensions.toFirstLower(coordServiceDef.getName());
              _builder.append(_firstLower_4, "\t");
              String _firstLower_5 = StringExtensions.toFirstLower(service.getName());
              _builder.append(_firstLower_5, "\t");
              _builder.append("Client, ciInstanceName);");
              _builder.newLineIfNotEmpty();
            } else {
              if ((pattern instanceof SendPattern)) {
                _builder.append("\t");
                _builder.append("//SEND CLIENT");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("iter->second.");
                String _firstLower_6 = StringExtensions.toFirstLower(coordServiceDef.getName());
                _builder.append(_firstLower_6, "\t");
                String _firstLower_7 = StringExtensions.toFirstLower(service.getName());
                _builder.append(_firstLower_7, "\t");
                _builder.append("Client = new SmartACE::SendClient<");
                CharSequence _fullyQualifiedNameCpp_2 = this._commObjectGenHelpers.getFullyQualifiedNameCpp(((SendPattern)pattern).getDataType());
                _builder.append(_fullyQualifiedNameCpp_2, "\t");
                _builder.append(">(component);");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("iter->second.");
                String _firstLower_8 = StringExtensions.toFirstLower(coordServiceDef.getName());
                _builder.append(_firstLower_8, "\t");
                String _firstLower_9 = StringExtensions.toFirstLower(service.getName());
                _builder.append(_firstLower_9, "\t");
                _builder.append("SendHandler = new ");
                String _firstUpper_8 = StringExtensions.toFirstUpper(coordServiceDef.getName());
                _builder.append(_firstUpper_8, "\t");
                String _firstUpper_9 = StringExtensions.toFirstUpper(service.getName());
                _builder.append(_firstUpper_9, "\t");
                _builder.append("SendHandler();");
                _builder.newLineIfNotEmpty();
              } else {
                if ((pattern instanceof QueryPattern)) {
                  _builder.append("\t");
                  _builder.append("//QUERY CLIENT");
                  _builder.newLine();
                  _builder.append("\t");
                  _builder.append("iter->second.");
                  String _firstLower_10 = StringExtensions.toFirstLower(coordServiceDef.getName());
                  _builder.append(_firstLower_10, "\t");
                  String _firstLower_11 = StringExtensions.toFirstLower(service.getName());
                  _builder.append(_firstLower_11, "\t");
                  _builder.append("Client = new SmartACE::QueryClient<");
                  CharSequence _fullyQualifiedNameCpp_3 = this._commObjectGenHelpers.getFullyQualifiedNameCpp(((QueryPattern)pattern).getRequestType());
                  _builder.append(_fullyQualifiedNameCpp_3, "\t");
                  _builder.append(",");
                  CharSequence _fullyQualifiedNameCpp_4 = this._commObjectGenHelpers.getFullyQualifiedNameCpp(((QueryPattern)pattern).getAnswerType());
                  _builder.append(_fullyQualifiedNameCpp_4, "\t");
                  _builder.append(">(component);");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t");
                  _builder.append("iter->second.");
                  String _firstLower_12 = StringExtensions.toFirstLower(coordServiceDef.getName());
                  _builder.append(_firstLower_12, "\t");
                  String _firstLower_13 = StringExtensions.toFirstLower(service.getName());
                  _builder.append(_firstLower_13, "\t");
                  _builder.append("QueryHandler = new ");
                  String _firstUpper_10 = StringExtensions.toFirstUpper(coordServiceDef.getName());
                  _builder.append(_firstUpper_10, "\t");
                  String _firstUpper_11 = StringExtensions.toFirstUpper(service.getName());
                  _builder.append(_firstUpper_11, "\t");
                  _builder.append("QueryHandler();");
                  _builder.newLineIfNotEmpty();
                }
              }
            }
          }
        }
      }
    }
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// connect ports");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("std::cout<<__FUNCTION__<<\" connect ports...\"<<std::endl; ");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("std::map< std::string, CiConnection, ciLessLibC>::const_iterator ci_inst_iter = ciConnectionsMap.find(ciInstanceName);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if(ci_inst_iter != ciConnectionsMap.end()){");
    _builder.newLine();
    {
      final Function1<CommunicationServiceUsage, String> _function_1 = (CommunicationServiceUsage e) -> {
        return e.getName();
      };
      List<CommunicationServiceUsage> _sortBy_1 = IterableExtensions.<CommunicationServiceUsage, String>sortBy(coordServiceDef.getServices(), _function_1);
      for(final CommunicationServiceUsage service_1 : _sortBy_1) {
        _builder.append("\t\t");
        CommunicationPattern pattern_1 = ComponentDefinitionModelUtility.getPattern(service_1.getUses());
        _builder.newLineIfNotEmpty();
        {
          if ((((pattern_1 instanceof EventPattern) || 
            (pattern_1 instanceof SendPattern)) || 
            (pattern_1 instanceof QueryPattern))) {
            _builder.append("\t\t");
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("std::map<std::string, std::string>::const_iterator service_iter = ci_inst_iter->second.serviceNameMap.find(\"");
            String _name_1 = service_1.getName();
            _builder.append(_name_1, "\t\t\t");
            _builder.append("\");");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("if(service_iter != ci_inst_iter->second.serviceNameMap.end()){");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t\t");
            _builder.append("std::string serviceName(service_iter->second);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t\t");
            _builder.append("Smart::StatusCode status;");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t\t");
            _builder.append("std::cout << \"connecting to: \" << ci_inst_iter->second.componentInstanceName << \"; \" << serviceName << std::endl;");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t\t");
            _builder.append("status = iter->second.");
            String _firstLower_14 = StringExtensions.toFirstLower(coordServiceDef.getName());
            _builder.append(_firstLower_14, "\t\t\t\t");
            String _firstLower_15 = StringExtensions.toFirstLower(service_1.getName());
            _builder.append(_firstLower_15, "\t\t\t\t");
            _builder.append("Client->connect(ci_inst_iter->second.componentInstanceName, serviceName);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t\t");
            _builder.append("while(status != Smart::SMART_OK)");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t\t");
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t\t\t");
            _builder.append("ACE_OS::sleep(ACE_Time_Value(0,500000));");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t\t\t");
            _builder.append("status = iter->second.");
            String _firstLower_16 = StringExtensions.toFirstLower(coordServiceDef.getName());
            _builder.append(_firstLower_16, "\t\t\t\t\t");
            String _firstLower_17 = StringExtensions.toFirstLower(service_1.getName());
            _builder.append(_firstLower_17, "\t\t\t\t\t");
            _builder.append("Client->connect(ci_inst_iter->second.componentInstanceName, serviceName);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t\t");
            _builder.append("std::cout << \"connected.\\n\";");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("} else {");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t\t");
            _builder.append("std::cout<<\"ERROR SERVICE NOT FOUND IN MAP!\"<<std::endl;");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t\t");
            _builder.append("return 1;");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
          }
        }
      }
    }
    _builder.append("\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("std::cout<<\"Was not able to find ci inst in ciComponent connection map!\"<<std::endl;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return 0;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("std::cout<<\"ERROR WAS NOT ABLE TO FIND CI INSTANCE IN MAP --> this should not have happend!\"<<std::endl;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return -1;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("}");
    _builder.newLine();
    _builder.append(" ");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("int ");
    String _firstUpper_12 = StringExtensions.toFirstUpper(coordServiceDef.getName());
    _builder.append(_firstUpper_12, " ");
    _builder.append("Core::finiCiInstance(const std::string& ciInstanceName){");
    _builder.newLineIfNotEmpty();
    _builder.append(" \t");
    _builder.append("std::map<std::string, ");
    String _firstUpper_13 = StringExtensions.toFirstUpper(coordServiceDef.getName());
    _builder.append(_firstUpper_13, " \t");
    _builder.append(">::iterator iter = ciInstanceMap.find(ciInstanceName);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("if(iter != ciInstanceMap.end()){");
    _builder.newLine();
    {
      final Function1<CommunicationServiceUsage, String> _function_2 = (CommunicationServiceUsage e) -> {
        return e.getName();
      };
      List<CommunicationServiceUsage> _sortBy_2 = IterableExtensions.<CommunicationServiceUsage, String>sortBy(coordServiceDef.getServices(), _function_2);
      for(final CommunicationServiceUsage service_2 : _sortBy_2) {
        _builder.append("\t\t\t");
        CommunicationPattern pattern_2 = ComponentDefinitionModelUtility.getPattern(service_2.getUses());
        _builder.newLineIfNotEmpty();
        {
          if ((pattern_2 instanceof PushPattern)) {
            _builder.append("\t\t\t");
            _builder.append("//PUSH IS NOT USED!");
            _builder.newLine();
          } else {
            if ((pattern_2 instanceof EventPattern)) {
              _builder.append("\t\t\t");
              _builder.append("delete iter->second.");
              String _firstLower_18 = StringExtensions.toFirstLower(coordServiceDef.getName());
              _builder.append(_firstLower_18, "\t\t\t");
              String _firstLower_19 = StringExtensions.toFirstLower(service_2.getName());
              _builder.append(_firstLower_19, "\t\t\t");
              _builder.append("EventHandlerCore;");
              _builder.newLineIfNotEmpty();
              _builder.append("\t\t\t");
              _builder.append("delete iter->second.");
              String _firstLower_20 = StringExtensions.toFirstLower(coordServiceDef.getName());
              _builder.append(_firstLower_20, "\t\t\t");
              String _firstLower_21 = StringExtensions.toFirstLower(service_2.getName());
              _builder.append(_firstLower_21, "\t\t\t");
              _builder.append("Client;");
              _builder.newLineIfNotEmpty();
            } else {
              if ((pattern_2 instanceof SendPattern)) {
                _builder.append("\t\t\t");
                _builder.append("delete iter->second.");
                String _firstLower_22 = StringExtensions.toFirstLower(coordServiceDef.getName());
                _builder.append(_firstLower_22, "\t\t\t");
                String _firstLower_23 = StringExtensions.toFirstLower(service_2.getName());
                _builder.append(_firstLower_23, "\t\t\t");
                _builder.append("SendHandler;");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t\t");
                _builder.append("delete iter->second.");
                String _firstLower_24 = StringExtensions.toFirstLower(coordServiceDef.getName());
                _builder.append(_firstLower_24, "\t\t\t");
                String _firstLower_25 = StringExtensions.toFirstLower(service_2.getName());
                _builder.append(_firstLower_25, "\t\t\t");
                _builder.append("Client;");
                _builder.newLineIfNotEmpty();
              } else {
                if ((pattern_2 instanceof QueryPattern)) {
                  _builder.append("\t\t\t");
                  _builder.append("delete iter->second.");
                  String _firstLower_26 = StringExtensions.toFirstLower(coordServiceDef.getName());
                  _builder.append(_firstLower_26, "\t\t\t");
                  String _firstLower_27 = StringExtensions.toFirstLower(service_2.getName());
                  _builder.append(_firstLower_27, "\t\t\t");
                  _builder.append("QueryHandler;");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t\t\t");
                  _builder.append("delete iter->second.");
                  String _firstLower_28 = StringExtensions.toFirstLower(coordServiceDef.getName());
                  _builder.append(_firstLower_28, "\t\t\t");
                  String _firstLower_29 = StringExtensions.toFirstLower(service_2.getName());
                  _builder.append(_firstLower_29, "\t\t\t");
                  _builder.append("Client;");
                  _builder.newLineIfNotEmpty();
                }
              }
            }
          }
        }
      }
    }
    _builder.append("\t\t");
    _builder.append("return 0;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("std::cout<<\"ERROR WAS NOT ABLE TO FIND CI INSTANCE IN MAP --> this should not have happend!\"<<std::endl;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return -1;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("std::string ");
    String _firstUpper_14 = StringExtensions.toFirstUpper(coordServiceDef.getName());
    _builder.append(_firstUpper_14);
    _builder.append("Core::switchCi(const std::string& ciInstanceName, const std::string& componentName, const std::string& componentInstanceName, const std::string& service, const std::string& parameter, const std::string& eventMode){");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("std::map<std::string, ");
    String _firstUpper_15 = StringExtensions.toFirstUpper(coordServiceDef.getName());
    _builder.append(_firstUpper_15, "\t");
    _builder.append(">::const_iterator iter = ciInstanceMap.find(ciInstanceName);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if(ciInstanceName == \"NIL\" && ciInstanceMap.size() == 1){");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("std::cout<<\"Fallback - no module-inst given, using the only existing module instance!\"<<std::endl;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("iter = ciInstanceMap.begin();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if(iter != ciInstanceMap.end()){");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("//std::cout<<\"switch");
    String _name_2 = coordServiceDef.getName();
    _builder.append(_name_2, "\t\t");
    _builder.append(" - compInstName: \"<<componentInstanceName<<\" parameter: \"<<parameter<<\" service: \"<<service<<std::endl;");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("std::ostringstream outString;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("outString << \"(error (unknown error))\";");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("// param");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if(ACE_OS::strcasecmp(service.c_str(), \"param\") == 0 )");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("outString.str(queryParam(componentInstanceName, parameter));");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if(ACE_OS::strcasecmp(service.c_str(), \"state\") == 0 )");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("outString.str(setState(componentInstanceName, parameter));");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if(ACE_OS::strcasecmp(service.c_str(), \"getstate\") == 0 )");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("outString.str(getState(componentInstanceName));");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if(ACE_OS::strcasecmp(service.c_str(), \"waitforlifecyclestate\") == 0 )");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("outString.str(waitForLifeCycleState(componentInstanceName, parameter));");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    {
      final Function1<CommunicationServiceUsage, String> _function_3 = (CommunicationServiceUsage e) -> {
        return e.getName();
      };
      List<CommunicationServiceUsage> _sortBy_3 = IterableExtensions.<CommunicationServiceUsage, String>sortBy(coordServiceDef.getServices(), _function_3);
      for(final CommunicationServiceUsage service_3 : _sortBy_3) {
        _builder.append("\t\t\t");
        CommunicationPattern pattern_3 = ComponentDefinitionModelUtility.getPattern(service_3.getUses());
        _builder.newLineIfNotEmpty();
        {
          if ((pattern_3 instanceof PushPattern)) {
            _builder.append("\t\t\t");
            _builder.append("//PUSH IS NOT USED!");
            _builder.newLine();
          } else {
            if ((pattern_3 instanceof QueryPattern)) {
              _builder.append("\t\t\t");
              _builder.append("if(ACE_OS::strcasecmp(service.c_str(), \"");
              String _name_3 = service_3.getName();
              _builder.append(_name_3, "\t\t\t");
              _builder.append("\") == 0 )");
              _builder.newLineIfNotEmpty();
              _builder.append("\t\t\t");
              _builder.append("{");
              _builder.newLine();
              _builder.append("\t\t\t");
              _builder.append("\t");
              CharSequence _fullyQualifiedNameCpp_5 = this._commObjectGenHelpers.getFullyQualifiedNameCpp(((QueryPattern)pattern_3).getRequestType());
              _builder.append(_fullyQualifiedNameCpp_5, "\t\t\t\t");
              _builder.append(" request;");
              _builder.newLineIfNotEmpty();
              _builder.append("\t\t\t");
              _builder.append("\t");
              CharSequence _fullyQualifiedNameCpp_6 = this._commObjectGenHelpers.getFullyQualifiedNameCpp(((QueryPattern)pattern_3).getAnswerType());
              _builder.append(_fullyQualifiedNameCpp_6, "\t\t\t\t");
              _builder.append(" answer;");
              _builder.newLineIfNotEmpty();
              _builder.append("\t\t\t");
              _builder.append("\t");
              _builder.newLine();
              _builder.append("\t\t\t");
              _builder.append("\t");
              _builder.append("Smart::StatusCode status;");
              _builder.newLine();
              _builder.append("\t\t\t");
              _builder.append("\t");
              _builder.append("request = iter->second.");
              String _firstLower_30 = StringExtensions.toFirstLower(coordServiceDef.getName());
              _builder.append(_firstLower_30, "\t\t\t\t");
              String _firstLower_31 = StringExtensions.toFirstLower(service_3.getName());
              _builder.append(_firstLower_31, "\t\t\t\t");
              _builder.append("QueryHandler->handleRequest(parameter);");
              _builder.newLineIfNotEmpty();
              _builder.append("\t\t\t");
              _builder.append("\t");
              _builder.newLine();
              _builder.append("\t\t\t");
              _builder.append("\t");
              _builder.append("status = iter->second.");
              String _firstLower_32 = StringExtensions.toFirstLower(coordServiceDef.getName());
              _builder.append(_firstLower_32, "\t\t\t\t");
              String _firstLower_33 = StringExtensions.toFirstLower(service_3.getName());
              _builder.append(_firstLower_33, "\t\t\t\t");
              _builder.append("Client->query(request,answer);");
              _builder.newLineIfNotEmpty();
              _builder.append("\t\t\t");
              _builder.append("\t");
              _builder.append("outString.str(\"\");");
              _builder.newLine();
              _builder.append("\t\t\t");
              _builder.append("\t");
              _builder.append("switch (status)");
              _builder.newLine();
              _builder.append("\t\t\t");
              _builder.append("\t");
              _builder.append("{");
              _builder.newLine();
              _builder.append("\t\t\t");
              _builder.append("\t\t");
              _builder.append("case Smart::SMART_OK:");
              _builder.newLine();
              _builder.append("\t\t\t");
              _builder.append("\t\t");
              _builder.append("{");
              _builder.newLine();
              _builder.append("\t\t\t");
              _builder.append("\t\t\t");
              _builder.append("std::string resString = iter->second.");
              String _firstLower_34 = StringExtensions.toFirstLower(coordServiceDef.getName());
              _builder.append(_firstLower_34, "\t\t\t\t\t\t");
              String _firstLower_35 = StringExtensions.toFirstLower(service_3.getName());
              _builder.append(_firstLower_35, "\t\t\t\t\t\t");
              _builder.append("QueryHandler->handleAnswer(answer);");
              _builder.newLineIfNotEmpty();
              _builder.append("\t\t\t");
              _builder.append("\t\t\t");
              _builder.append("outString << \"(ok \"<<resString<<\")\";");
              _builder.newLine();
              _builder.append("\t\t\t");
              _builder.append("\t\t\t");
              _builder.append("break;");
              _builder.newLine();
              _builder.append("\t\t\t");
              _builder.append("\t \t");
              _builder.append("}");
              _builder.newLine();
              _builder.append("\t\t\t");
              _builder.append("\t\t");
              _builder.append("case Smart::SMART_DISCONNECTED:");
              _builder.newLine();
              _builder.append("\t\t\t");
              _builder.append("\t\t\t");
              _builder.append("outString << \"(error (smart disconnected))\";");
              _builder.newLine();
              _builder.append("\t\t\t");
              _builder.append("\t\t\t");
              _builder.append("break;");
              _builder.newLine();
              _builder.append("\t\t\t");
              _builder.append("\t\t");
              _builder.append("case Smart::SMART_ERROR_COMMUNICATION:");
              _builder.newLine();
              _builder.append("\t\t\t");
              _builder.append("\t\t\t");
              _builder.append("outString << \"(error (smart communication error))\";");
              _builder.newLine();
              _builder.append("\t\t\t");
              _builder.append("\t\t\t");
              _builder.append("break;");
              _builder.newLine();
              _builder.append("\t\t\t");
              _builder.append("\t\t");
              _builder.append("case Smart::SMART_ERROR:");
              _builder.newLine();
              _builder.append("\t\t\t");
              _builder.append("\t\t\t");
              _builder.append("outString << \"(error (smart error))\";");
              _builder.newLine();
              _builder.append("\t\t\t");
              _builder.append("\t\t\t");
              _builder.append("break;");
              _builder.newLine();
              _builder.append("\t\t\t");
              _builder.append("\t\t");
              _builder.append("default:");
              _builder.newLine();
              _builder.append("\t\t\t");
              _builder.append("\t\t\t");
              _builder.append("outString << \"(error (unknown error))\";");
              _builder.newLine();
              _builder.append("\t\t\t");
              _builder.append("\t\t\t");
              _builder.append("break;");
              _builder.newLine();
              _builder.append("\t\t\t");
              _builder.append("\t");
              _builder.append("} // switch(status)");
              _builder.newLine();
              _builder.append("\t\t\t");
              _builder.append("}");
              _builder.newLine();
            } else {
              if ((pattern_3 instanceof SendPattern)) {
                _builder.append("\t\t\t");
                _builder.append("if(ACE_OS::strcasecmp(service.c_str(), \"");
                String _name_4 = service_3.getName();
                _builder.append(_name_4, "\t\t\t");
                _builder.append("\") == 0 )");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t\t");
                _builder.append("{");
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.append("\t");
                CharSequence _fullyQualifiedNameCpp_7 = this._commObjectGenHelpers.getFullyQualifiedNameCpp(((SendPattern)pattern_3).getDataType());
                _builder.append(_fullyQualifiedNameCpp_7, "\t\t\t\t");
                _builder.append(" com;");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t\t");
                _builder.append("\t");
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.append("\t");
                _builder.append("Smart::StatusCode status;");
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.append("\t");
                _builder.append("com = iter->second.");
                String _firstLower_36 = StringExtensions.toFirstLower(coordServiceDef.getName());
                _builder.append(_firstLower_36, "\t\t\t\t");
                String _firstLower_37 = StringExtensions.toFirstLower(service_3.getName());
                _builder.append(_firstLower_37, "\t\t\t\t");
                _builder.append("SendHandler->handleSend(parameter);");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.append("\t");
                _builder.append("// everything is ok");
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.append("\t");
                _builder.append("status = iter->second.");
                String _firstLower_38 = StringExtensions.toFirstLower(coordServiceDef.getName());
                _builder.append(_firstLower_38, "\t\t\t\t");
                String _firstLower_39 = StringExtensions.toFirstLower(service_3.getName());
                _builder.append(_firstLower_39, "\t\t\t\t");
                _builder.append("Client->send(com);");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t\t");
                _builder.append("\t");
                _builder.append("outString.str(\"\");");
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.append("\t");
                _builder.append("switch (status)");
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.append("\t");
                _builder.append("{");
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.append("\t\t\t");
                _builder.append("case Smart::SMART_OK:");
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.append("\t\t\t\t\t");
                _builder.append("outString << \"(ok ())\";");
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.append("\t\t\t\t\t");
                _builder.append("break;");
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.append("\t\t\t");
                _builder.append("case Smart::SMART_DISCONNECTED:");
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.append("\t\t\t\t\t");
                _builder.append("outString << \"(error (smart disconnected))\";");
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.append("\t\t\t\t\t");
                _builder.append("break;");
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.append("\t\t\t");
                _builder.append("case Smart::SMART_ERROR_COMMUNICATION:");
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.append("\t\t\t\t\t");
                _builder.append("outString << \"(error (smart communication error))\";");
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.append("\t\t\t\t\t");
                _builder.append("break;");
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.append("\t\t\t");
                _builder.append("case Smart::SMART_ERROR:");
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.append("\t\t\t\t\t");
                _builder.append("outString << \"(error (smart error))\";");
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.append("\t\t\t\t\t");
                _builder.append("break;");
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.append("\t\t\t");
                _builder.append("default:");
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.append("\t\t\t\t\t");
                _builder.append("outString << \"(error (unknown error))\";");
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.append("\t\t\t\t\t");
                _builder.append("break;");
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.append("}");
                _builder.newLine();
              } else {
                if ((pattern_3 instanceof EventPattern)) {
                  _builder.append("\t\t\t");
                  _builder.append("if(ACE_OS::strcasecmp(service.c_str(), \"");
                  String _name_5 = service_3.getName();
                  _builder.append(_name_5, "\t\t\t");
                  _builder.append("-activate\") == 0 )");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t\t\t");
                  _builder.append("{");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t");
                  _builder.append("Smart::StatusCode status;");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t");
                  _builder.append("Smart::EventIdPtr id = nullptr;");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t");
                  CharSequence _fullyQualifiedNameCpp_8 = this._commObjectGenHelpers.getFullyQualifiedNameCpp(((EventPattern)pattern_3).getActivationType());
                  _builder.append(_fullyQualifiedNameCpp_8, "\t\t\t\t");
                  _builder.append(" param;");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t\t\t");
                  _builder.append("\t");
                  _builder.append("param = iter->second.");
                  String _firstLower_40 = StringExtensions.toFirstLower(coordServiceDef.getName());
                  _builder.append(_firstLower_40, "\t\t\t\t");
                  String _firstLower_41 = StringExtensions.toFirstLower(service_3.getName());
                  _builder.append(_firstLower_41, "\t\t\t\t");
                  _builder.append("EventHandlerCore->activateEventParam(parameter);");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t");
                  _builder.append("// CONTINOUS");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t");
                  _builder.append("if( ACE_OS::strcasecmp(eventMode.c_str(), \"CONTINUOUS\") == 0 )");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t");
                  _builder.append("{");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t");
                  _builder.append("status = iter->second.");
                  String _firstLower_42 = StringExtensions.toFirstLower(coordServiceDef.getName());
                  _builder.append(_firstLower_42, "\t\t\t\t\t");
                  String _firstLower_43 = StringExtensions.toFirstLower(service_3.getName());
                  _builder.append(_firstLower_43, "\t\t\t\t\t");
                  _builder.append("Client->activate(Smart::continuous, param, id);");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t");
                  _builder.append("outString.str(\"\");");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t");
                  _builder.append("switch(status)");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t");
                  _builder.append("{");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t\t");
                  _builder.append("case Smart::SMART_OK:");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t\t\t");
                  _builder.append("outString << \"(ok (\"<<id<<\"))\";");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t\t\t");
                  _builder.append("break;");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t\t");
                  _builder.append("case Smart::SMART_DISCONNECTED:");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t\t\t");
                  _builder.append("outString << \"(error (smart disconnected))\";");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t\t\t");
                  _builder.append("break;");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t\t");
                  _builder.append("case Smart::SMART_ERROR_COMMUNICATION:");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t\t\t");
                  _builder.append("outString << \"(error (smart communication error))\";");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t\t\t");
                  _builder.append("break;");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t\t");
                  _builder.append("case Smart::SMART_ERROR:");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t\t\t");
                  _builder.append("outString << \"(error (unknown error))\";");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("       \t\t\t");
                  _builder.append("break;");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t\t");
                  _builder.append("default:");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t            ");
                  _builder.append("outString << \"(error (unknown error))\";");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t            ");
                  _builder.append("break;");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t");
                  _builder.append("} // switch");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t");
                  _builder.append("} // CONTINOUS");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t");
                  _builder.append("// SINGLE");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t");
                  _builder.append("else if( ACE_OS::strcasecmp(eventMode.c_str(), \"SINGLE\") == 0 )");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t");
                  _builder.append("{");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t");
                  _builder.append("status = iter->second.");
                  String _firstLower_44 = StringExtensions.toFirstLower(coordServiceDef.getName());
                  _builder.append(_firstLower_44, "\t\t\t\t\t");
                  String _firstLower_45 = StringExtensions.toFirstLower(service_3.getName());
                  _builder.append(_firstLower_45, "\t\t\t\t\t");
                  _builder.append("Client->activate(Smart::single, param, id);");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t");
                  _builder.append("outString.str(\"\");");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t");
                  _builder.append("switch(status)");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t");
                  _builder.append("{");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t\t");
                  _builder.append("case Smart::SMART_OK:");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t\t\t");
                  _builder.append("outString << \"(ok (\"<<id<<\"))\";");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t\t\t");
                  _builder.append("break;");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t\t");
                  _builder.append("case Smart::SMART_DISCONNECTED:");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t\t\t");
                  _builder.append("outString << \"(error (smart disconnected))\";");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t\t\t");
                  _builder.append("break;");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t\t");
                  _builder.append("case Smart::SMART_ERROR_COMMUNICATION:");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t\t\t");
                  _builder.append("outString << \"(error (smart communication error))\";");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t\t\t");
                  _builder.append("break;");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t\t");
                  _builder.append("case Smart::SMART_ERROR:");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t            ");
                  _builder.append("outString << \"(error (unknown error))\";");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t            ");
                  _builder.append("break;");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t\t");
                  _builder.append("default:");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t            ");
                  _builder.append("outString << \"(error (unknown error))\";");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t            ");
                  _builder.append("break;");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t");
                  _builder.append("} // switch");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t");
                  _builder.append("}");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("}");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("// goal event deactivate");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("if(ACE_OS::strcasecmp(service.c_str(), \"");
                  String _name_6 = service_3.getName();
                  _builder.append(_name_6, "\t\t\t");
                  _builder.append("-deactivate\") == 0)");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t\t\t");
                  _builder.append("{");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t");
                  _builder.append("Smart::StatusCode status;");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t");
                  _builder.append("Smart::EventIdPtr id = NULL;");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t");
                  _builder.append("try {");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t");
                  _builder.append("// TODO: <alex> this seems to be quite a hack, as ID is not always an int and will not work with other middlewares as ACE");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t");
                  _builder.append("id = std::make_shared<Smart::NumericCorrelationId>(std::stoi( parameter ));");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t");
                  _builder.append("}");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t");
                  _builder.append("catch (...) {");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t");
                  _builder.append("std::cout<<\"[FleetManagerCoordinationServiceCore] id int conversion error!\"<<std::endl;");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t");
                  _builder.append("outString << \"(error (unknown error))\";");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t");
                  _builder.append("return outString.str();");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t");
                  _builder.append("}");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t");
                  _builder.append("status = iter->second.");
                  String _firstLower_46 = StringExtensions.toFirstLower(coordServiceDef.getName());
                  _builder.append(_firstLower_46, "\t\t\t\t");
                  String _firstLower_47 = StringExtensions.toFirstLower(service_3.getName());
                  _builder.append(_firstLower_47, "\t\t\t\t");
                  _builder.append("Client->deactivate(id);");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t\t\t");
                  _builder.append("\t");
                  _builder.append("outString.str(\"\");");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t");
                  _builder.append("switch(status)");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t");
                  _builder.append("{");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t");
                  _builder.append("case Smart::SMART_OK:");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t");
                  _builder.append("outString << \"(ok (\"<<id<<\"))\";");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t");
                  _builder.append("break;");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t");
                  _builder.append("case Smart::SMART_WRONGID:");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t");
                  _builder.append("outString << \"(error (smart wrongid))\";");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t");
                  _builder.append("break;");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t");
                  _builder.append("case Smart::SMART_ERROR_COMMUNICATION:");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t");
                  _builder.append("outString << \"(error (smart communication error))\";");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t");
                  _builder.append("break;");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t");
                  _builder.append("case Smart::SMART_ERROR:");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t");
                  _builder.append("outString << \"(error (unknown error))\";");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t");
                  _builder.append("break;");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t");
                  _builder.append("default:");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t");
                  _builder.append("outString << \"(error (unknown error))\";");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t");
                  _builder.append("break;");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t");
                  _builder.append("} // switch");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("\t\t");
                  _builder.newLine();
                  _builder.append("\t\t\t");
                  _builder.append("}");
                  _builder.newLine();
                }
              }
            }
          }
        }
      }
    }
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return outString.str();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("std::cout<<\"ERROR WAS NOT ABLE TO FIND CI INSTANCE IN MAP --> this should not have happend!\"<<std::endl;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("std::ostringstream outString;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("outString << \"(fatal error)\";");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return outString.str();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  /**
   * compileModuleSource switchModule.cc
   */
  public CharSequence compileSwitchCoordinationServiceSource(final CoordinationServiceDefinition coordServiceDef) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("#include \"");
    String _firstUpper = StringExtensions.toFirstUpper(coordServiceDef.getName());
    _builder.append(_firstUpper);
    _builder.append("Core.hh\"");
    _builder.newLineIfNotEmpty();
    _builder.append("#include \"runTimeInterface.hh\"");
    _builder.newLine();
    _builder.newLine();
    _builder.append("typedef ACE_Singleton<");
    String _firstUpper_1 = StringExtensions.toFirstUpper(coordServiceDef.getName());
    _builder.append(_firstUpper_1);
    _builder.append("Core, ACE_Thread_Mutex> ");
    String _upperCase = coordServiceDef.getName().toUpperCase();
    _builder.append(_upperCase);
    _builder.append("_MODULE;");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("//INIT FUNCTION");
    _builder.newLine();
    _builder.newLine();
    _builder.append("extern \"C\" int init");
    String _name = coordServiceDef.getName();
    _builder.append(_name);
    _builder.append("(SmartACE::SmartComponent * component, const std::string& ciInstanceName, const std::map< std::string,  CiConnection, ciLessLibC > &ciConnectionsMap){");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    String _upperCase_1 = coordServiceDef.getName().toUpperCase();
    _builder.append(_upperCase_1, "\t");
    _builder.append("_MODULE::instance()->addNewModuleInstance(ciInstanceName);");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return ");
    String _upperCase_2 = coordServiceDef.getName().toUpperCase();
    _builder.append(_upperCase_2, "\t");
    _builder.append("_MODULE::instance()->initCiInstance(component,ciInstanceName,ciConnectionsMap);");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.newLine();
    _builder.newLine();
    _builder.append("//FINI FUNCTION");
    _builder.newLine();
    _builder.newLine();
    _builder.append("extern \"C\" int fini");
    String _name_1 = coordServiceDef.getName();
    _builder.append(_name_1);
    _builder.append("(const std::string& ciInstanceName){");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return ");
    String _upperCase_3 = coordServiceDef.getName().toUpperCase();
    _builder.append(_upperCase_3, "\t");
    _builder.append("_MODULE::instance()->finiCiInstance(ciInstanceName);");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.newLine();
    _builder.append("//SWITCH FUNCTION");
    _builder.newLine();
    _builder.newLine();
    _builder.append("extern \"C\" std::string switch");
    String _name_2 = coordServiceDef.getName();
    _builder.append(_name_2);
    _builder.append("(const std::string& ciInstanceName, const std::string& componentName, const std::string& componentInstanceName, const std::string& service, const std::string& parameter, const std::string& eventMode)");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return ");
    String _upperCase_4 = coordServiceDef.getName().toUpperCase();
    _builder.append(_upperCase_4, "\t");
    _builder.append("_MODULE::instance()->switchCi(ciInstanceName,componentName,componentInstanceName,service,parameter,eventMode);");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence compileEventHandlerSource(final CommunicationServiceUsage service, final EventPattern pattern, final String coordServiceDefName) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("#include \"");
    String _firstUpper = StringExtensions.toFirstUpper(coordServiceDefName);
    _builder.append(_firstUpper);
    String _firstUpper_1 = StringExtensions.toFirstUpper(service.getName());
    String _plus = (_firstUpper_1 + "EventHandler.hh");
    _builder.append(_plus);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("std::string ");
    String _firstUpper_2 = StringExtensions.toFirstUpper(coordServiceDefName);
    _builder.append(_firstUpper_2);
    String _firstUpper_3 = StringExtensions.toFirstUpper(service.getName());
    _builder.append(_firstUpper_3);
    _builder.append("EventHandler::handleEvent(const ");
    CharSequence _fullyQualifiedNameCpp = this._commObjectGenHelpers.getFullyQualifiedNameCpp(pattern.getEventType());
    _builder.append(_fullyQualifiedNameCpp);
    _builder.append(" &r) throw() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("std::string outString;");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("//convert the event result commObject to string representation outString (to TCL)");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("//std::ostringstream ss;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("//ss << \"(\"<< std::setprecision( 2 ) << answer_data<<\")\";");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("//outString = ss.str();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return outString;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _fullyQualifiedNameCpp_1 = this._commObjectGenHelpers.getFullyQualifiedNameCpp(pattern.getActivationType());
    _builder.append(_fullyQualifiedNameCpp_1);
    _builder.append(" ");
    String _firstUpper_4 = StringExtensions.toFirstUpper(coordServiceDefName);
    _builder.append(_firstUpper_4);
    String _firstUpper_5 = StringExtensions.toFirstUpper(service.getName());
    _builder.append(_firstUpper_5);
    _builder.append("EventHandler::activateEventParam(const std::string& parameterString){");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _fullyQualifiedNameCpp_2 = this._commObjectGenHelpers.getFullyQualifiedNameCpp(pattern.getActivationType());
    _builder.append(_fullyQualifiedNameCpp_2, "\t");
    _builder.append(" param;");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("//fill the event activation (parameter) commObject with the data provided via the inString (from TCL)");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("//e.g. param.setLisp(inString);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return param;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence compileEventHandlerHeader(final CommunicationServiceUsage port, final EventPattern pattern, final String coordServiceDefName) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("#ifndef _");
    String _upperCase = coordServiceDefName.toUpperCase();
    _builder.append(_upperCase);
    String _upperCase_1 = port.getName().toUpperCase();
    _builder.append(_upperCase_1);
    _builder.append("EVENTHANDLER_HH_");
    _builder.newLineIfNotEmpty();
    _builder.append("#define _");
    String _upperCase_2 = coordServiceDefName.toUpperCase();
    _builder.append(_upperCase_2);
    String _upperCase_3 = port.getName().toUpperCase();
    _builder.append(_upperCase_3);
    _builder.append("EVENTHANDLER_HH_");
    _builder.newLineIfNotEmpty();
    _builder.append("#include \"aceSmartSoft.hh\"");
    _builder.newLine();
    _builder.append("#include <string>");
    _builder.newLine();
    _builder.append("#include <iostream>");
    _builder.newLine();
    _builder.newLine();
    _builder.newLine();
    _builder.append("#include \"");
    CharSequence _userClassHeaderFileNameFQN = this._commObjectGenHelpers.getUserClassHeaderFileNameFQN(pattern.getEventType());
    _builder.append(_userClassHeaderFileNameFQN);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.append("#include \"");
    CharSequence _userClassHeaderFileNameFQN_1 = this._commObjectGenHelpers.getUserClassHeaderFileNameFQN(pattern.getActivationType());
    _builder.append(_userClassHeaderFileNameFQN_1);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("class ");
    String _firstUpper = StringExtensions.toFirstUpper(coordServiceDefName);
    _builder.append(_firstUpper);
    String _firstUpper_1 = StringExtensions.toFirstUpper(port.getName());
    _builder.append(_firstUpper_1);
    _builder.append("EventHandler");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("public:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("std::string handleEvent(const ");
    CharSequence _fullyQualifiedNameCpp = this._commObjectGenHelpers.getFullyQualifiedNameCpp(pattern.getEventType());
    _builder.append(_fullyQualifiedNameCpp, "\t");
    _builder.append(" &r) throw();");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _fullyQualifiedNameCpp_1 = this._commObjectGenHelpers.getFullyQualifiedNameCpp(pattern.getActivationType());
    _builder.append(_fullyQualifiedNameCpp_1, "\t");
    _builder.append(" activateEventParam(const std::string& parameterString);");
    _builder.newLineIfNotEmpty();
    _builder.append("};");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#endif");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence compileEventHandlerSourceCore(final CommunicationServiceUsage port, final EventPattern pattern, final String coordServiceDefName) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("#include \"");
    String _firstUpper = StringExtensions.toFirstUpper(coordServiceDefName);
    _builder.append(_firstUpper);
    String _firstUpper_1 = StringExtensions.toFirstUpper(port.getName());
    String _plus = (_firstUpper_1 + "EventHandlerCore.hh");
    _builder.append(_plus);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.append("#include \"runTimeInterface.hh\"");
    _builder.newLine();
    _builder.append("#include <cstdio>");
    _builder.newLine();
    _builder.append("#include <iostream>");
    _builder.newLine();
    _builder.newLine();
    String _firstUpper_2 = StringExtensions.toFirstUpper(coordServiceDefName);
    _builder.append(_firstUpper_2);
    String _firstUpper_3 = StringExtensions.toFirstUpper(port.getName());
    _builder.append(_firstUpper_3);
    _builder.append("EventHandlerCore::");
    String _firstUpper_4 = StringExtensions.toFirstUpper(coordServiceDefName);
    _builder.append(_firstUpper_4);
    String _firstUpper_5 = StringExtensions.toFirstUpper(port.getName());
    _builder.append(_firstUpper_5);
    _builder.append("EventHandlerCore(Smart::IEventClientPattern<");
    CharSequence _fullyQualifiedNameCpp = this._commObjectGenHelpers.getFullyQualifiedNameCpp(pattern.getActivationType());
    _builder.append(_fullyQualifiedNameCpp);
    _builder.append(", ");
    CharSequence _fullyQualifiedNameCpp_1 = this._commObjectGenHelpers.getFullyQualifiedNameCpp(pattern.getEventType());
    _builder.append(_fullyQualifiedNameCpp_1);
    _builder.append("> *client, std::string ciInstanceName)");
    _builder.newLineIfNotEmpty();
    _builder.append(": Smart::IEventHandler<");
    CharSequence _fullyQualifiedNameCpp_2 = this._commObjectGenHelpers.getFullyQualifiedNameCpp(pattern.getEventType());
    _builder.append(_fullyQualifiedNameCpp_2);
    _builder.append(">(client)");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("this->ciInstanceName = ciInstanceName;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("void ");
    String _firstUpper_6 = StringExtensions.toFirstUpper(coordServiceDefName);
    _builder.append(_firstUpper_6);
    String _firstUpper_7 = StringExtensions.toFirstUpper(port.getName());
    _builder.append(_firstUpper_7);
    _builder.append("EventHandlerCore::handleEvent(const Smart::EventIdPtr &id, const ");
    CharSequence _fullyQualifiedNameCpp_3 = this._commObjectGenHelpers.getFullyQualifiedNameCpp(pattern.getEventType());
    _builder.append(_fullyQualifiedNameCpp_3);
    _builder.append(" &r) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("std::string resultString;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("resultString = userHandler.handleEvent(r);");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("///////////////////////////////////////////");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/////////// ESCAPE \" in user data");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("std::string toSearch = \"\\\"\";");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("std::string replaceStr = \"\\\\\\\"\";");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// Get the first occurrence");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("size_t pos = resultString.find(toSearch);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("// Repeat till end is reached");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("while( pos != std::string::npos)");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("{");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("// Replace this occurrence of Sub String");
    _builder.newLine();
    _builder.append("    \t");
    _builder.append("resultString.replace(pos, toSearch.size(), replaceStr);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("// Get the next occurrence from the current position");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("pos =resultString.find(toSearch, pos + replaceStr.size());");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("///////////////////////////////////////////");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("std::ostringstream eventResult;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("eventResult<< \"(\";");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("eventResult<< \"( coordination-interfaces-type . \\\"");
    _builder.append(coordServiceDefName, "\t");
    _builder.append("\\\")\";");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("eventResult<< \"( coordination-interface-instance . \\\"\"<<this->ciInstanceName<<\"\\\")\";");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("eventResult<< \"( service-name . \\\"");
    String _name = port.getName();
    _builder.append(_name, "\t");
    _builder.append("\\\")\";");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("eventResult<< \"( id . \"<<id<<\")\";");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("eventResult<< \"( data . \\\"\"<<resultString<<\"\\\")\";");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("eventResult<< \")\";");
    _builder.newLine();
    _builder.append("//\teventResult<<\"((\\\"");
    _builder.append(coordServiceDefName);
    _builder.append("\\\" \"<<this->ciInstanceName<<\" \\\"");
    String _name_1 = port.getName();
    _builder.append(_name_1);
    _builder.append("\\\" \"<<id<<\") \"<<resultString<<\")\";");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("int result = appedEvent(eventResult.str());");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _fullyQualifiedNameCpp_4 = this._commObjectGenHelpers.getFullyQualifiedNameCpp(pattern.getActivationType());
    _builder.append(_fullyQualifiedNameCpp_4);
    _builder.append(" ");
    String _firstUpper_8 = StringExtensions.toFirstUpper(coordServiceDefName);
    _builder.append(_firstUpper_8);
    String _firstUpper_9 = StringExtensions.toFirstUpper(port.getName());
    _builder.append(_firstUpper_9);
    _builder.append("EventHandlerCore::activateEventParam(const std::string& parameterString){");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("std::cout<<\"Activate Event Parameter string: \"<<parameterString<<std::endl;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return userHandler.activateEventParam(parameterString);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence compileEventHandlerHeaderCore(final CommunicationServiceUsage port, final EventPattern pattern, final String coordServiceDefName) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("#ifndef _");
    String _upperCase = coordServiceDefName.toUpperCase();
    _builder.append(_upperCase);
    String _upperCase_1 = port.getName().toUpperCase();
    _builder.append(_upperCase_1);
    _builder.append("EVENTHANDLERCORE_HH_");
    _builder.newLineIfNotEmpty();
    _builder.append("#define _");
    String _upperCase_2 = coordServiceDefName.toUpperCase();
    _builder.append(_upperCase_2);
    String _upperCase_3 = port.getName().toUpperCase();
    _builder.append(_upperCase_3);
    _builder.append("EVENTHANDLERCORE_HH_");
    _builder.newLineIfNotEmpty();
    _builder.append("#include \"aceSmartSoft.hh\"");
    _builder.newLine();
    _builder.append("#include <string>");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#include \"");
    CharSequence _userClassHeaderFileNameFQN = this._commObjectGenHelpers.getUserClassHeaderFileNameFQN(pattern.getEventType());
    _builder.append(_userClassHeaderFileNameFQN);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.append("#include \"");
    CharSequence _userClassHeaderFileNameFQN_1 = this._commObjectGenHelpers.getUserClassHeaderFileNameFQN(pattern.getActivationType());
    _builder.append(_userClassHeaderFileNameFQN_1);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.append("#include \"");
    String _firstUpper = StringExtensions.toFirstUpper(coordServiceDefName);
    _builder.append(_firstUpper);
    String _firstUpper_1 = StringExtensions.toFirstUpper(port.getName());
    String _plus = (_firstUpper_1 + "EventHandler.hh");
    _builder.append(_plus);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("class ");
    String _firstUpper_2 = StringExtensions.toFirstUpper(coordServiceDefName);
    _builder.append(_firstUpper_2);
    String _firstUpper_3 = StringExtensions.toFirstUpper(port.getName());
    _builder.append(_firstUpper_3);
    _builder.append("EventHandlerCore : public Smart::IEventHandler<");
    CharSequence _fullyQualifiedNameCpp = this._commObjectGenHelpers.getFullyQualifiedNameCpp(pattern.getEventType());
    _builder.append(_fullyQualifiedNameCpp);
    _builder.append(">");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("public:");
    _builder.newLine();
    _builder.append("\t");
    String _firstUpper_4 = StringExtensions.toFirstUpper(coordServiceDefName);
    _builder.append(_firstUpper_4, "\t");
    String _firstUpper_5 = StringExtensions.toFirstUpper(port.getName());
    _builder.append(_firstUpper_5, "\t");
    _builder.append("EventHandlerCore(Smart::IEventClientPattern<");
    CharSequence _fullyQualifiedNameCpp_1 = this._commObjectGenHelpers.getFullyQualifiedNameCpp(pattern.getActivationType());
    _builder.append(_fullyQualifiedNameCpp_1, "\t");
    _builder.append(", ");
    CharSequence _fullyQualifiedNameCpp_2 = this._commObjectGenHelpers.getFullyQualifiedNameCpp(pattern.getEventType());
    _builder.append(_fullyQualifiedNameCpp_2, "\t");
    _builder.append("> *client, std::string moduleInstanceName);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("virtual void handleEvent(const Smart::EventIdPtr &id, const ");
    CharSequence _fullyQualifiedNameCpp_3 = this._commObjectGenHelpers.getFullyQualifiedNameCpp(pattern.getEventType());
    _builder.append(_fullyQualifiedNameCpp_3, "\t");
    _builder.append(" &r) override;");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _fullyQualifiedNameCpp_4 = this._commObjectGenHelpers.getFullyQualifiedNameCpp(pattern.getActivationType());
    _builder.append(_fullyQualifiedNameCpp_4, "\t");
    _builder.append(" activateEventParam(const std::string& parameterString);");
    _builder.newLineIfNotEmpty();
    _builder.append("private:");
    _builder.newLine();
    _builder.append("\t");
    String _firstUpper_6 = StringExtensions.toFirstUpper(coordServiceDefName);
    _builder.append(_firstUpper_6, "\t");
    String _firstUpper_7 = StringExtensions.toFirstUpper(port.getName());
    _builder.append(_firstUpper_7, "\t");
    _builder.append("EventHandler userHandler;");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("std::string ciInstanceName;");
    _builder.newLine();
    _builder.append("};");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#endif");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence compileQuerySource(final CommunicationServiceUsage port, final QueryPattern pattern, final String coordServiceDefName) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("#include \"");
    String _firstUpper = StringExtensions.toFirstUpper(coordServiceDefName);
    _builder.append(_firstUpper);
    String _firstUpper_1 = StringExtensions.toFirstUpper(port.getName());
    String _plus = (_firstUpper_1 + "QueryHandler.hh");
    _builder.append(_plus);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#include \"");
    CharSequence _repoNamespace = this._commObjectGenHelpers.getRepoNamespace(pattern.getRequestType());
    _builder.append(_repoNamespace);
    _builder.append("JSON/");
    CharSequence _userClassName = this._commObjectGenHelpers.getUserClassName(pattern.getRequestType());
    _builder.append(_userClassName);
    _builder.append("JSON.hh\"");
    _builder.newLineIfNotEmpty();
    _builder.append("#include \"");
    CharSequence _repoNamespace_1 = this._commObjectGenHelpers.getRepoNamespace(pattern.getAnswerType());
    _builder.append(_repoNamespace_1);
    _builder.append("JSON/");
    CharSequence _userClassName_1 = this._commObjectGenHelpers.getUserClassName(pattern.getAnswerType());
    _builder.append(_userClassName_1);
    _builder.append("JSON.hh\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _fullyQualifiedNameCpp = this._commObjectGenHelpers.getFullyQualifiedNameCpp(pattern.getRequestType());
    _builder.append(_fullyQualifiedNameCpp);
    _builder.append(" ");
    String _firstUpper_2 = StringExtensions.toFirstUpper(coordServiceDefName);
    _builder.append(_firstUpper_2);
    String _firstUpper_3 = StringExtensions.toFirstUpper(port.getName());
    _builder.append(_firstUpper_3);
    _builder.append("QueryHandler::handleRequest(const std::string& inString){");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _fullyQualifiedNameCpp_1 = this._commObjectGenHelpers.getFullyQualifiedNameCpp(pattern.getRequestType());
    _builder.append(_fullyQualifiedNameCpp_1, "\t");
    _builder.append(" request;");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("// parse the inString into an nlohmann::json object");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("nlohmann::json data = nlohmann::json::parse(inString);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// convert the parsed nlohmann::json object into the request communication object");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _repoNamespace_2 = this._commObjectGenHelpers.getRepoNamespace(pattern.getRequestType());
    _builder.append(_repoNamespace_2, "\t");
    _builder.append("IDL::from_json(data, request.set());");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("// return the coverted result object");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return request;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("std::string ");
    String _firstUpper_4 = StringExtensions.toFirstUpper(coordServiceDefName);
    _builder.append(_firstUpper_4);
    String _firstUpper_5 = StringExtensions.toFirstUpper(port.getName());
    _builder.append(_firstUpper_5);
    _builder.append("QueryHandler::handleAnswer(const ");
    CharSequence _fullyQualifiedNameCpp_2 = this._commObjectGenHelpers.getFullyQualifiedNameCpp(pattern.getAnswerType());
    _builder.append(_fullyQualifiedNameCpp_2);
    _builder.append("& answer){");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("nlohmann::json data;");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _repoNamespace_3 = this._commObjectGenHelpers.getRepoNamespace(pattern.getAnswerType());
    _builder.append(_repoNamespace_3, "\t");
    _builder.append("IDL::to_json(answer.get(), data);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return data.dump();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence compileQueryHeader(final CommunicationServiceUsage port, final QueryPattern pattern, final String coordServiceDefName) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("#ifndef _");
    String _upperCase = coordServiceDefName.toUpperCase();
    _builder.append(_upperCase);
    String _upperCase_1 = port.getName().toUpperCase();
    _builder.append(_upperCase_1);
    _builder.append("QUERYHANDLER_HH_");
    _builder.newLineIfNotEmpty();
    _builder.append("#define _");
    String _upperCase_2 = coordServiceDefName.toUpperCase();
    _builder.append(_upperCase_2);
    String _upperCase_3 = port.getName().toUpperCase();
    _builder.append(_upperCase_3);
    _builder.append("QUERYHANDLER_HH_");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#include \"");
    CharSequence _userClassHeaderFileNameFQN = this._commObjectGenHelpers.getUserClassHeaderFileNameFQN(pattern.getRequestType());
    _builder.append(_userClassHeaderFileNameFQN);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.append("#include \"");
    CharSequence _userClassHeaderFileNameFQN_1 = this._commObjectGenHelpers.getUserClassHeaderFileNameFQN(pattern.getAnswerType());
    _builder.append(_userClassHeaderFileNameFQN_1);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.append("#include <string>");
    _builder.newLine();
    _builder.newLine();
    _builder.append("class ");
    String _firstUpper = StringExtensions.toFirstUpper(coordServiceDefName);
    _builder.append(_firstUpper);
    String _firstUpper_1 = StringExtensions.toFirstUpper(port.getName());
    _builder.append(_firstUpper_1);
    _builder.append("QueryHandler");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("public:");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    String _firstUpper_2 = StringExtensions.toFirstUpper(coordServiceDefName);
    _builder.append(_firstUpper_2, "\t");
    String _firstUpper_3 = StringExtensions.toFirstUpper(port.getName());
    _builder.append(_firstUpper_3, "\t");
    _builder.append("QueryHandler(){");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _fullyQualifiedNameCpp = this._commObjectGenHelpers.getFullyQualifiedNameCpp(pattern.getRequestType());
    _builder.append(_fullyQualifiedNameCpp, "\t");
    _builder.append(" handleRequest(const std::string& inString);");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("std::string handleAnswer(const ");
    CharSequence _fullyQualifiedNameCpp_1 = this._commObjectGenHelpers.getFullyQualifiedNameCpp(pattern.getAnswerType());
    _builder.append(_fullyQualifiedNameCpp_1, "\t");
    _builder.append("& answer);");
    _builder.newLineIfNotEmpty();
    _builder.append("};");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#endif");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence compileSendHeader(final CommunicationServiceUsage port, final SendPattern pattern, final String coordServiceDefName) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("#ifndef _");
    String _upperCase = coordServiceDefName.toUpperCase();
    _builder.append(_upperCase);
    String _upperCase_1 = port.getName().toUpperCase();
    _builder.append(_upperCase_1);
    _builder.append("SENDHANDLER_HH_");
    _builder.newLineIfNotEmpty();
    _builder.append("#define _");
    String _upperCase_2 = coordServiceDefName.toUpperCase();
    _builder.append(_upperCase_2);
    String _upperCase_3 = port.getName().toUpperCase();
    _builder.append(_upperCase_3);
    _builder.append("SENDHANDLER_HH_");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#include \"");
    CharSequence _userClassHeaderFileNameFQN = this._commObjectGenHelpers.getUserClassHeaderFileNameFQN(pattern.getDataType());
    _builder.append(_userClassHeaderFileNameFQN);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.append("#include <string>");
    _builder.newLine();
    _builder.newLine();
    _builder.append("class ");
    String _firstUpper = StringExtensions.toFirstUpper(coordServiceDefName);
    _builder.append(_firstUpper);
    String _firstUpper_1 = StringExtensions.toFirstUpper(port.getName());
    _builder.append(_firstUpper_1);
    _builder.append("SendHandler");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("public:");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    String _firstUpper_2 = StringExtensions.toFirstUpper(coordServiceDefName);
    _builder.append(_firstUpper_2, "\t");
    String _firstUpper_3 = StringExtensions.toFirstUpper(port.getName());
    _builder.append(_firstUpper_3, "\t");
    _builder.append("SendHandler(){");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _fullyQualifiedNameCpp = this._commObjectGenHelpers.getFullyQualifiedNameCpp(pattern.getDataType());
    _builder.append(_fullyQualifiedNameCpp, "\t");
    _builder.append(" handleSend(std::string inString);");
    _builder.newLineIfNotEmpty();
    _builder.append("};");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#endif");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence compileSendSource(final CommunicationServiceUsage port, final SendPattern pattern, final String coordServiceDefName) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("#include \"");
    String _firstUpper = StringExtensions.toFirstUpper(coordServiceDefName);
    _builder.append(_firstUpper);
    String _firstUpper_1 = StringExtensions.toFirstUpper(port.getName());
    String _plus = (_firstUpper_1 + "SendHandler.hh");
    _builder.append(_plus);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.append("  ");
    _builder.newLine();
    CharSequence _fullyQualifiedNameCpp = this._commObjectGenHelpers.getFullyQualifiedNameCpp(pattern.getDataType());
    _builder.append(_fullyQualifiedNameCpp);
    _builder.append(" ");
    String _firstUpper_2 = StringExtensions.toFirstUpper(coordServiceDefName);
    _builder.append(_firstUpper_2);
    String _firstUpper_3 = StringExtensions.toFirstUpper(port.getName());
    _builder.append(_firstUpper_3);
    _builder.append("SendHandler::handleSend(std::string inString){");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _fullyQualifiedNameCpp_1 = this._commObjectGenHelpers.getFullyQualifiedNameCpp(pattern.getDataType());
    _builder.append(_fullyQualifiedNameCpp_1, "\t");
    _builder.append(" sendCommObject;");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("//fill the send commObject with the data provided via the inString (from TCL)");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("//sendCommObject.setData(inString);");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return sendCommObject;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    return _builder;
  }
}
