/**
 * Copyright (c) 2019 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtend.datasheet.generator.domainModels;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.smartmdsd.ecore.service.domainModelsDatasheet.DomainModelsDatasheet;
import org.eclipse.xtext.generator.AbstractGenerator;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

@SuppressWarnings("all")
public class DomainModelsDatasheetGeneratorImpl extends AbstractGenerator {
  @Inject
  @Extension
  private DomainModelsRDFGenerator _domainModelsRDFGenerator;
  
  @Override
  public void doGenerate(final Resource input, final IFileSystemAccess2 fsa, final IGeneratorContext context) {
    Iterable<DomainModelsDatasheet> _filter = Iterables.<DomainModelsDatasheet>filter(IteratorExtensions.<EObject>toIterable(input.getAllContents()), DomainModelsDatasheet.class);
    for (final DomainModelsDatasheet datasheet : _filter) {
      fsa.generateFile(this._domainModelsRDFGenerator.getRdfDatasheetFilename(datasheet), this._domainModelsRDFGenerator.compileRdfDatasheet(datasheet));
    }
  }
}
