/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtend.datasheet.generator.component;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.AbstractDatasheetElement;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.DatasheetProperty;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.DefaultDatasheetProperties;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.GenericDatasheetModel;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.MandatoryDatasheetElement;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.MandatoryDatasheetElementNames;
import org.eclipse.smartmdsd.ecore.component.componentDatasheet.ComponentDatasheet;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.AnswerPort;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinitionModelUtility;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentPort;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.InputPort;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.OutputPort;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.RequestPort;
import org.eclipse.smartmdsd.ecore.service.domainModelsDatasheet.DomainModelsDatasheet;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.CommunicationServiceDefinition;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.ForkingServiceDefinition;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.JoiningServiceDefinition;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.OneWayCommunicationService;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.ServiceDefRepository;
import org.eclipse.smartmdsd.xtext.service.domainModelsDatasheet.ui.internal.DomainModelsDatasheetActivator;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.documentation.IEObjectDocumentationProvider;
import org.eclipse.xtext.generator.AbstractGenerator;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class ComponentDatasheetGeneratorImpl
extends AbstractGenerator {
    @Inject
    private IEObjectDocumentationProvider doc;

    public String getRdfDatasheetFilename(ComponentDatasheet ds) {
        String _name = ds.getComponent().getName();
        return String.valueOf(_name) + ".ttl";
    }

    public void doGenerate(Resource input, IFileSystemAccess2 fsa, IGeneratorContext context) {
        Iterable _filter = Iterables.filter((Iterable)IteratorExtensions.toIterable((Iterator)input.getAllContents()), ComponentDatasheet.class);
        for (ComponentDatasheet datasheet : _filter) {
            fsa.generateFile(this.getRdfDatasheetFilename(datasheet), this.compileRdfDatasheet(datasheet));
        }
    }

    public DomainModelsDatasheet getDomainModelsDatasheet(ServiceDefRepository repo) {
        Injector injector = DomainModelsDatasheetActivator.getInstance().getInjector("org.eclipse.smartmdsd.xtext.service.domainModelsDatasheet.DomainModelsDatasheet");
        XtextResourceSet resourceSet = (XtextResourceSet)injector.getInstance(XtextResourceSet.class);
        resourceSet.addLoadOption((Object)XtextResource.OPTION_RESOLVE_ALL, (Object)Boolean.TRUE);
        URI baseUri = repo.eResource().getURI().trimFileExtension();
        FileExtensionProvider fileExtProvider = (FileExtensionProvider)injector.getInstance(FileExtensionProvider.class);
        URI xtextResourceUri = baseUri.appendFileExtension(fileExtProvider.getPrimaryFileExtension());
        boolean resourceExists = resourceSet.getURIConverter().exists(xtextResourceUri, null);
        if (resourceExists) {
            EObject root_obj;
            Resource resource = resourceSet.getResource(xtextResourceUri, true);
            boolean _isLoaded = resource.isLoaded();
            boolean _equals = _isLoaded;
            if (_equals && (root_obj = (EObject)resource.getContents().get(0)) instanceof DomainModelsDatasheet) {
                return (DomainModelsDatasheet)root_obj;
            }
        } else {
            InputOutput.println((Object)("non-existing resource: " + xtextResourceUri));
        }
        return null;
    }

    public ServiceDefRepository getRepo(CommunicationServiceDefinition svc) {
        EObject _eContainer = svc.eContainer();
        return (ServiceDefRepository)_eContainer;
    }

    public String getBaseURI(GenericDatasheetModel ds) {
        Functions.Function1 _function = it -> it.getName().equals((Object)MandatoryDatasheetElementNames.BASE_URI);
        MandatoryDatasheetElement base_uri = (MandatoryDatasheetElement)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)ds.getElements(), MandatoryDatasheetElement.class), (Functions.Function1)_function);
        if (base_uri != null) {
            return base_uri.getValue();
        }
        return "";
    }

    public String getShortDescription(GenericDatasheetModel ds) {
        Functions.Function1 _function = it -> it.getName().equals((Object)MandatoryDatasheetElementNames.SHORT_DESCRIPTION);
        MandatoryDatasheetElement base_uri = (MandatoryDatasheetElement)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)ds.getElements(), MandatoryDatasheetElement.class), (Functions.Function1)_function);
        if (base_uri != null) {
            return base_uri.getValue();
        }
        return "";
    }

    public CharSequence compile(AbstractDatasheetElement element) {
        StringConcatenation _xifexpression = null;
        if (element instanceof DatasheetProperty) {
            String _literal_2;
            String _literal_1;
            StringConcatenation _switchResult = null;
            String _name = ((DatasheetProperty)element).getName();
            boolean _matched = false;
            String _literal = DefaultDatasheetProperties.SPDX_LICENSE.getLiteral();
            if (Objects.equal((Object)_name, (Object)_literal)) {
                _matched = true;
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("# License will contain SPDX License Identifier");
                _builder.newLine();
                _builder.append("# see https://spdx.org/licenses/");
                _builder.newLine();
                _builder.append("t1:license <http://spdx.org/licenses/");
                String _value = ((DatasheetProperty)element).getValue();
                _builder.append(_value);
                _builder.append(".html>;");
                _builder.newLineIfNotEmpty();
                _switchResult = _builder;
            }
            if (!_matched && Objects.equal((Object)_name, (Object)(_literal_1 = DefaultDatasheetProperties.TECHNOLOGY_READINESS_LEVEL.getLiteral()))) {
                _matched = true;
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("# Technology Readiness Scale, e.g.");
                _builder_1.newLine();
                _builder_1.append("# http://www.innovationseeds.eu/Virtual_Library/Knowledge/TLR_Scale.kl");
                _builder_1.newLine();
                _builder_1.append("# Level 1 to level 9.");
                _builder_1.newLine();
                _builder_1.append("# plus trl:undefined for undefined TRL");
                _builder_1.newLine();
                _builder_1.append("t1:trl t1:TRL_Level");
                String _value_1 = ((DatasheetProperty)element).getValue();
                int _length = ((DatasheetProperty)element).getValue().length();
                int _minus = _length - 1;
                String _substring = _value_1.substring(_minus);
                _builder_1.append(_substring);
                _builder_1.append(";");
                _builder_1.newLineIfNotEmpty();
                _switchResult = _builder_1;
            }
            if (!_matched && Objects.equal((Object)_name, (Object)(_literal_2 = DefaultDatasheetProperties.HOMEPAGE.getLiteral()))) {
                _matched = true;
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("# The webpage with additional information about this component");
                _builder_2.newLine();
                _builder_2.append("t1:homepage \"");
                String _value_2 = ((DatasheetProperty)element).getValue();
                _builder_2.append(_value_2);
                _builder_2.append("\"^^xsd:anyURI;");
                _builder_2.newLineIfNotEmpty();
                _switchResult = _builder_2;
            }
            if (!_matched) {
                StringConcatenation _builder_3 = new StringConcatenation();
                _builder_3.append("# DatasheetProperty ");
                String _name_1 = ((DatasheetProperty)element).getName();
                _builder_3.append(_name_1);
                _builder_3.newLineIfNotEmpty();
                _builder_3.append("t1:");
                String _firstLower = StringExtensions.toFirstLower((String)((DatasheetProperty)element).getName());
                _builder_3.append(_firstLower);
                _builder_3.append("Description \"");
                String _value_3 = ((DatasheetProperty)element).getValue();
                _builder_3.append(_value_3);
                _builder_3.append("\";");
                _builder_3.newLineIfNotEmpty();
                _switchResult = _builder_3;
            }
            _xifexpression = _switchResult;
        }
        return _xifexpression;
    }

    public CharSequence compileRdfDatasheet(ComponentDatasheet ds) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("# baseURI: ");
        String _baseURI = this.getBaseURI((GenericDatasheetModel)ds);
        _builder.append(_baseURI);
        _builder.append("/ComponentsAndSystems#");
        String _name = ds.getComponent().getName();
        _builder.append(_name);
        _builder.newLineIfNotEmpty();
        _builder.append("# imports: http://robmosys.eu/rdf/composition-structures");
        _builder.newLine();
        _builder.append("# imports: http://seronet-projekt.de/models/t2#Navigation");
        _builder.newLine();
        _builder.newLine();
        Functions.Function1 _function = c -> c.getName().toString();
        List _sortBy = IterableExtensions.sortBy(this.getAllDomainModelDatasheets(ds), (Functions.Function1)_function);
        for (DomainModelsDatasheet dm_ds : _sortBy) {
            _builder.append("# imports: ");
            String _baseURI_1 = this.getBaseURI((GenericDatasheetModel)dm_ds);
            _builder.append(_baseURI_1);
            _builder.append("/DomainModels/");
            String _name_1 = dm_ds.getName();
            _builder.append(_name_1);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("#######################################");
        _builder.newLine();
        _builder.append("# Technical Data Sheet");
        _builder.newLine();
        _builder.append("# for a SeRoNet Software Component as ");
        _builder.newLine();
        _builder.append("# exported by the SmartMDSD Toolchain");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.append("# erste Zeile des .ttl muss enthalten: \"# ComponentID: <id uri>\"");
        _builder.newLine();
        _builder.append("# This file will be placed in:");
        _builder.newLine();
        _builder.append("# <componentName>/datasheet-gen/<componentName>.ttl");
        _builder.newLine();
        _builder.append("#######################################");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# all generated files use these prefixes");
        _builder.newLine();
        _builder.append("@prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> .");
        _builder.newLine();
        _builder.append("@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .");
        _builder.newLine();
        _builder.append("@prefix t1: <http://seronet-projekt.de/models/t1#> .");
        _builder.newLine();
        _builder.append("@prefix spdx: <http://spdx.org/rdf/terms#> .");
        _builder.newLine();
        _builder.append("@prefix spdx-lic: <http://spdx.org/licenses/> .");
        _builder.newLine();
        _builder.newLine();
        _builder.append("@prefix owl: <http://www.w3.org/2002/07/owl#> .");
        _builder.newLine();
        _builder.append("@prefix sh: <http://www.w3.org/ns/shacl#> .");
        _builder.newLine();
        _builder.append("@prefix xsd: <http://www.w3.org/2001/XMLSchema#> .");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# TODO past \u201cDurchstich\u201d: exactly identify which elements belong to SeRoNet and which belong to RobMoSys");
        _builder.newLine();
        _builder.append("@prefix robmosys: <http://robmosys.eu/rdf/composition-structures#> .");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# these namespaces can be different in generated files");
        _builder.newLine();
        _builder.append("@prefix t3: <");
        String _baseURI_2 = this.getBaseURI((GenericDatasheetModel)ds);
        _builder.append(_baseURI_2);
        _builder.append("/ComponentsAndSystems#> .");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        Functions.Function1 _function_1 = c -> c.getName().toString();
        List _sortBy_1 = IterableExtensions.sortBy(this.getAllDomainModelDatasheets(ds), (Functions.Function1)_function_1);
        for (DomainModelsDatasheet dm_ds_1 : _sortBy_1) {
            _builder.append("@prefix ");
            String _name_2 = dm_ds_1.getName();
            _builder.append(_name_2);
            _builder.append(": <");
            Iterator _baseURI_3 = this.getBaseURI((GenericDatasheetModel)dm_ds_1);
            _builder.append((String)((Object)_baseURI_3));
            _builder.append("/DomainModels/");
            String _name_3 = dm_ds_1.getName();
            _builder.append(_name_3);
            _builder.append("#> .");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("##### Software Component ");
        String _name_4 = ds.getComponent().getName();
        _builder.append(_name_4);
        _builder.newLineIfNotEmpty();
        _builder.append("# see https://robmosys.eu/wiki/modeling:metamodels:component");
        _builder.newLine();
        _builder.append("t3:");
        String _name_5 = ds.getComponent().getName();
        _builder.append(_name_5);
        _builder.append(" a robmosys:ComponentDefinition;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("a owl:Ontology ;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("owl:imports <http://robmosys.eu/rdf/composition-structures> ;");
        _builder.newLine();
        Functions.Function1 _function_2 = it -> it.getName().equals(DefaultDatasheetProperties.SPDX_LICENSE.getLiteral());
        Iterable _filter = IterableExtensions.filter((Iterable)Iterables.filter((Iterable)ds.getElements(), DatasheetProperty.class), (Functions.Function1)_function_2);
        for (DatasheetProperty license : _filter) {
            _builder.append("\t");
            _builder.append("owl:imports <http://spdx.org/licenses/");
            String _value = license.getValue();
            _builder.append(_value, "\t");
            _builder.append(">;");
            _builder.newLineIfNotEmpty();
        }
        Functions.Function1 _function_3 = c -> c.getName().toString();
        List _sortBy_2 = IterableExtensions.sortBy(this.getAllDomainModelDatasheets(ds), (Functions.Function1)_function_3);
        for (DomainModelsDatasheet dm_ds_2 : _sortBy_2) {
            _builder.append("\t");
            _builder.append("owl:imports <");
            String _baseURI_4 = this.getBaseURI((GenericDatasheetModel)dm_ds_2);
            _builder.append(_baseURI_4, "\t");
            _builder.append("/DomainModels/");
            String _name_6 = dm_ds_2.getName();
            _builder.append(_name_6, "\t");
            _builder.append("> ;");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("# Human readable name of this component");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("# Equals with the project name");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("rdfs:label \"");
        String _name_7 = ds.getComponent().getName();
        _builder.append(_name_7, "\t");
        _builder.append("\";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("# Abstract. 1-sentence, very brief, description about this component.");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("t1:shortDescription \"");
        String _shortDescription = this.getShortDescription((GenericDatasheetModel)ds);
        _builder.append(_shortDescription, "\t");
        _builder.append("\";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        if (ds.getComponent() != null && ds.getComponent().getDocumentation() != null) {
            _builder.append("\t");
            _builder.append("# A long description of this component");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("t1:description \"\"\"");
            _builder.newLine();
            _builder.append("\t");
            String _multilineHtmlDocumentation = ds.getComponent().getMultilineHtmlDocumentation();
            _builder.append(_multilineHtmlDocumentation, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\"\"\";");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.newLine();
        EList _elements = ds.getElements();
        for (AbstractDatasheetElement element : _elements) {
            _builder.append("\t");
            CharSequence _compile = this.compile(element);
            _builder.append((Object)_compile, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append("# Services this component provides or requires");
        _builder.newLine();
        Iterable _filter_1 = Iterables.filter((Iterable)ds.getComponent().getElements(), ComponentPort.class);
        for (ComponentPort port : _filter_1) {
            _builder.append("\t");
            _builder.append("# ComponentPort ");
            String _name_8 = port.getName();
            _builder.append(_name_8, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("t1:");
            String _serviceType = this.getServiceType(port);
            _builder.append(_serviceType, "\t");
            _builder.append(" t3:");
            String _name_9 = ds.getComponent().getName();
            _builder.append(_name_9, "\t");
            _builder.append("_");
            String _name_10 = port.getName();
            _builder.append(_name_10, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append(".");
        _builder.newLine();
        _builder.newLine();
        Iterable _filter_2 = Iterables.filter((Iterable)ds.getComponent().getElements(), ComponentPort.class);
        for (ComponentPort port_1 : _filter_2) {
            CharSequence _compileComponentPort = this.compileComponentPort(ds, port_1);
            _builder.append((Object)_compileComponentPort);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public String getServiceType(ComponentPort port) {
        OneWayCommunicationService svc;
        OneWayCommunicationService _service;
        if (port instanceof OutputPort ? (_service = ((OutputPort)port).getService()) instanceof ForkingServiceDefinition : (port instanceof InputPort ? (svc = ((InputPort)port).getService()) instanceof JoiningServiceDefinition : port instanceof AnswerPort)) {
            return "providedService";
        }
        return "requiredService";
    }

    public CharSequence compileComponentPort(ComponentDatasheet ds, ComponentPort port) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("# a service definition usage. Here: provided service");
        _builder.newLine();
        _builder.append("# see https://robmosys.eu/wiki/modeling:metamodels:component");
        _builder.newLine();
        _builder.append("t3:");
        String _name = ds.getComponent().getName();
        _builder.append(_name);
        _builder.append("_");
        String _name_1 = port.getName();
        _builder.append(_name_1);
        _builder.append(" ");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("rdf:type ");
        String _name_2 = this.getRepo(ComponentDefinitionModelUtility.getService((ComponentPort)port)).getName();
        _builder.append(_name_2, "\t");
        _builder.append(":");
        String _name_3 = ComponentDefinitionModelUtility.getService((ComponentPort)port).getName();
        _builder.append(_name_3, "\t");
        _builder.append(" ;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("# name of this service definition as from the model");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("rdfs:label \"");
        String _name_4 = port.getName();
        _builder.append(_name_4, "\t");
        _builder.append("\";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _documentation = this.doc.getDocumentation((EObject)port);
        boolean bl = _tripleNotEquals = _documentation != null;
        if (_tripleNotEquals) {
            _builder.append("\t");
            _builder.append("# verbose description about this service");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("t1:description \"");
            String _documentation_1 = this.doc.getDocumentation((EObject)port);
            _builder.append(_documentation_1, "\t");
            _builder.append("\";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append(".");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    public CommunicationServiceDefinition getServiceDefinition(ComponentPort port) {
        OneWayCommunicationService _switchResult = null;
        boolean _matched = false;
        if (port instanceof OutputPort) {
            _matched = true;
            _switchResult = ((OutputPort)port).getService();
        }
        if (!_matched && port instanceof InputPort) {
            _matched = true;
            _switchResult = ((InputPort)port).getService();
        }
        if (!_matched && port instanceof AnswerPort) {
            _matched = true;
            _switchResult = ((AnswerPort)port).getService();
        }
        if (!_matched && port instanceof RequestPort) {
            _matched = true;
            _switchResult = ((RequestPort)port).getService();
        }
        return _switchResult;
    }

    public Collection<DomainModelsDatasheet> getAllDomainModelDatasheets(ComponentDatasheet ds) {
        HashSet<DomainModelsDatasheet> dm_datasheets = new HashSet<DomainModelsDatasheet>();
        Iterable _filter = Iterables.filter((Iterable)ds.getComponent().getElements(), ComponentPort.class);
        for (ComponentPort port : _filter) {
            boolean _not;
            DomainModelsDatasheet dm_ds = this.getDomainModelsDatasheet(this.getRepo(ComponentDefinitionModelUtility.getService((ComponentPort)port)));
            if (dm_ds == null) continue;
            Functions.Function1 _function = it -> {
                String _name = it.getName();
                String _name_1 = dm_ds.getName();
                return Objects.equal((Object)_name, (Object)_name_1);
            };
            boolean _exists = IterableExtensions.exists(dm_datasheets, (Functions.Function1)_function);
            boolean bl = _not = !_exists;
            if (!_not) continue;
            dm_datasheets.add(dm_ds);
        }
        return dm_datasheets;
    }
}

