/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtend.smartsoft.generator.component;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.AbstractComponentElement;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.Activity;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.AnswerPort;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinition;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinitionModelUtility;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentPort;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentSubNodeObserver;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.DerivedComponentElement;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.InputPort;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.NamedComponentElement;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.OutputPort;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.RequestPort;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ComponentParametersRef;
import org.eclipse.smartmdsd.ecore.component.performanceExtension.ActivationConstraints;
import org.eclipse.smartmdsd.ecore.component.seronetExtension.PlainOpcUaPort;
import org.eclipse.smartmdsd.ecore.component.seronetExtension.SupportedMiddleware;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommObjectsRepository;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommunicationObject;
import org.eclipse.smartmdsd.ecore.service.communicationPattern.CommunicationPattern;
import org.eclipse.smartmdsd.ecore.service.communicationPattern.EventPattern;
import org.eclipse.smartmdsd.ecore.service.communicationPattern.ForkingPattern;
import org.eclipse.smartmdsd.ecore.service.communicationPattern.PushPattern;
import org.eclipse.smartmdsd.ecore.service.communicationPattern.QueryPattern;
import org.eclipse.smartmdsd.ecore.service.communicationPattern.SendPattern;
import org.eclipse.smartmdsd.ecore.service.roboticMiddleware.ACE_SmartSoft;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.CommunicationServiceDefinition;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.ForkingServiceDefinition;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.JoiningServiceDefinition;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.OneWayCommunicationService;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.commObj.CommObjectGenHelpers;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.ActivityGeneratorExtension;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.ComponentGeneratorExtension;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.SmartTimerDummy;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class ComponentGenHelpers {
    @Inject
    private CommObjectGenHelpers comm;

    public String nameClass(ComponentDefinition c) {
        return StringExtensions.toFirstUpper((String)c.getName());
    }

    public String nameClass(AbstractComponentElement elem) {
        String _switchResult = null;
        boolean _matched = false;
        if (elem instanceof NamedComponentElement) {
            _matched = true;
            _switchResult = StringExtensions.toFirstUpper((String)((NamedComponentElement)elem).getName());
        }
        if (!_matched && elem instanceof DerivedComponentElement) {
            _matched = true;
            _switchResult = StringExtensions.toFirstUpper((String)((DerivedComponentElement)elem).getName());
        }
        if (!_matched && elem instanceof PlainOpcUaPort) {
            _matched = true;
            _switchResult = StringExtensions.toFirstUpper((String)((PlainOpcUaPort)elem).getName());
        }
        return _switchResult;
    }

    public String nameClass(SmartTimerDummy p) {
        return StringExtensions.toFirstUpper((String)p.getName());
    }

    public String getNameClass(ComponentSubNodeObserver obs) {
        return StringExtensions.toFirstUpper((String)obs.getSubject().getName());
    }

    public String nameInstance(ComponentDefinition c) {
        return StringExtensions.toFirstLower((String)c.getName());
    }

    public String nameInstance(AbstractComponentElement elem) {
        String _switchResult = null;
        boolean _matched = false;
        if (elem instanceof NamedComponentElement) {
            _matched = true;
            _switchResult = StringExtensions.toFirstLower((String)((NamedComponentElement)elem).getName());
        }
        if (!_matched && elem instanceof DerivedComponentElement) {
            _matched = true;
            _switchResult = StringExtensions.toFirstLower((String)((DerivedComponentElement)elem).getName());
        }
        if (!_matched && elem instanceof PlainOpcUaPort) {
            _matched = true;
            _switchResult = StringExtensions.toFirstLower((String)((PlainOpcUaPort)elem).getName());
        }
        return _switchResult;
    }

    public String nameInstance(SmartTimerDummy p) {
        return StringExtensions.toFirstLower((String)p.getName());
    }

    public String nameInstance(ComponentSubNodeObserver obs) {
        return StringExtensions.toFirstLower((String)obs.getSubject().getName());
    }

    public String nameOriginal(ComponentDefinition c) {
        return c.getName();
    }

    public String nameOriginal(AbstractComponentElement elem) {
        String _switchResult = null;
        boolean _matched = false;
        if (elem instanceof NamedComponentElement) {
            _matched = true;
            _switchResult = ((NamedComponentElement)elem).getName();
        }
        if (!_matched && elem instanceof DerivedComponentElement) {
            _matched = true;
            _switchResult = ((DerivedComponentElement)elem).getName();
        }
        if (!_matched && elem instanceof PlainOpcUaPort) {
            _matched = true;
            _switchResult = ((PlainOpcUaPort)elem).getName();
        }
        return _switchResult;
    }

    public String nameOriginal(SmartTimerDummy p) {
        return p.getName();
    }

    public String nameOriginal(ComponentSubNodeObserver obs) {
        return obs.getSubject().getName();
    }

    public CommunicationPattern getPattern(ComponentPort port) {
        CommunicationServiceDefinition service = ComponentDefinitionModelUtility.getService((ComponentPort)port);
        return ComponentDefinitionModelUtility.getPattern((CommunicationServiceDefinition)service);
    }

    public Double getMinActFreq(Activity task) {
        boolean _equals;
        int _size = IterableExtensions.size((Iterable)Iterables.filter((Iterable)task.getExtensions(), ActivationConstraints.class));
        boolean bl = _equals = _size == 0;
        if (_equals) {
            return 0.0;
        }
        return ((ActivationConstraints[])Conversions.unwrapArray((Object)Iterables.filter((Iterable)task.getExtensions(), ActivationConstraints.class), ActivationConstraints.class))[0].getMinActFreq();
    }

    public Double getMaxActFreq(Activity task) {
        boolean _equals;
        int _size = IterableExtensions.size((Iterable)Iterables.filter((Iterable)task.getExtensions(), ActivationConstraints.class));
        boolean bl = _equals = _size == 0;
        if (_equals) {
            return 0.0;
        }
        return ((ActivationConstraints[])Conversions.unwrapArray((Object)Iterables.filter((Iterable)task.getExtensions(), ActivationConstraints.class), ActivationConstraints.class))[0].getMaxActFreq();
    }

    public Double getUpdateRate(Activity task) {
        boolean _greaterThan_1;
        boolean _greaterThan;
        Double _minActFreq = this.getMinActFreq(task);
        boolean bl = _greaterThan = _minActFreq > 0.0;
        if (_greaterThan) {
            return this.getMinActFreq(task);
        }
        Double _maxActFreq = this.getMaxActFreq(task);
        boolean bl2 = _greaterThan_1 = _maxActFreq > 0.0;
        if (_greaterThan_1) {
            return this.getMaxActFreq(task);
        }
        return 1.0;
    }

    public Boolean hasParameters(ComponentDefinition component) {
        int _size = IterableExtensions.size((Iterable)Iterables.filter((Iterable)component.getElements(), ComponentParametersRef.class));
        return _size > 0;
    }

    public CharSequence getCommObjectCppList(CommunicationPattern pattern, Boolean isSource) {
        if (pattern instanceof PushPattern) {
            return this.comm.getFullyQualifiedNameCpp(((PushPattern)pattern).getDataType());
        }
        if (pattern instanceof SendPattern) {
            return this.comm.getFullyQualifiedNameCpp(((SendPattern)pattern).getDataType());
        }
        if (pattern instanceof QueryPattern) {
            String name;
            String _name = name = this.comm.getFullyQualifiedNameCpp(((QueryPattern)pattern).getRequestType()).toString();
            String _string = this.comm.getFullyQualifiedNameCpp(((QueryPattern)pattern).getAnswerType()).toString();
            String _plus = ", " + _string;
            name = String.valueOf(_name) + _plus;
            return name;
        }
        if (pattern instanceof EventPattern) {
            String name_1;
            String _name_1 = name_1 = this.comm.getFullyQualifiedNameCpp(((EventPattern)pattern).getActivationType()).toString();
            String _string_1 = this.comm.getFullyQualifiedNameCpp(((EventPattern)pattern).getEventType()).toString();
            String _plus_1 = ", " + _string_1;
            name_1 = String.valueOf(_name_1) + _plus_1;
            if (isSource.booleanValue()) {
                String _name_2 = name_1;
                String _string_2 = this.comm.getFullyQualifiedNameCpp(((EventPattern)pattern).getEventStateType()).toString();
                String _plus_2 = ", " + _string_2;
                name_1 = String.valueOf(_name_2) + _plus_2;
            }
            return name_1;
        }
        return null;
    }

    public boolean isEventServer(AbstractComponentElement element) {
        if (element instanceof OutputPort) {
            CommunicationPattern pattern = this.getPattern((ComponentPort)element);
            return pattern instanceof EventPattern;
        }
        return false;
    }

    public CharSequence getEventServerStateObject(AbstractComponentElement element) {
        if (element instanceof OutputPort) {
            CommunicationPattern pattern = this.getPattern((ComponentPort)element);
            return this.comm.getFullyQualifiedNameCpp(((EventPattern)pattern).getEventStateType());
        }
        return "";
    }

    public CharSequence getInputHandlerCommObject(ComponentPort service) {
        CommunicationPattern pattern;
        if (service instanceof InputPort && (pattern = this.getPattern(service)) instanceof EventPattern) {
            CharSequence _fullyQualifiedNameCpp = this.comm.getFullyQualifiedNameCpp(((EventPattern)pattern).getEventType());
            String _plus = "Smart::EventInputType<" + _fullyQualifiedNameCpp;
            return String.valueOf(_plus) + ">";
        }
        return this.getCommObjectCppList(service, (Boolean)false);
    }

    public CharSequence getCommObjectCppList(ComponentPort service, Boolean isSource) {
        CommunicationPattern pattern = this.getPattern(service);
        return this.getCommObjectCppList(pattern, isSource);
    }

    protected String _getPortDefinition(OutputPort port) {
        CharSequence _commObjectCppList;
        StringConcatenation _builder;
        String _xblockexpression = null;
        CommunicationPattern pattern = this.getPattern((ComponentPort)port);
        String _switchResult = null;
        boolean _matched = false;
        if (pattern instanceof PushPattern) {
            _matched = true;
            _builder = new StringConcatenation();
            _builder.append("Smart::IPushServerPattern<");
            _commObjectCppList = this.getCommObjectCppList(pattern, (Boolean)true);
            _builder.append((Object)_commObjectCppList);
            _builder.append(">");
            _switchResult = _builder.toString();
        }
        if (!_matched && pattern instanceof EventPattern) {
            _matched = true;
            _builder = new StringConcatenation();
            _builder.append("Smart::IEventServerPattern<");
            _commObjectCppList = this.getCommObjectCppList(pattern, (Boolean)true);
            _builder.append((Object)_commObjectCppList);
            _builder.append(">");
            _switchResult = _builder.toString();
        }
        if (!_matched && pattern instanceof SendPattern) {
            _matched = true;
            _builder = new StringConcatenation();
            _builder.append("Smart::ISendClientPattern<");
            _commObjectCppList = this.getCommObjectCppList(pattern, (Boolean)true);
            _builder.append((Object)_commObjectCppList);
            _builder.append(">");
            _switchResult = _builder.toString();
        }
        if (!_matched) {
            _switchResult = "";
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    protected String _getPortDefinition(InputPort port) {
        CharSequence _commObjectCppList;
        StringConcatenation _builder;
        String _xblockexpression = null;
        CommunicationPattern pattern = this.getPattern((ComponentPort)port);
        String _switchResult = null;
        boolean _matched = false;
        if (pattern instanceof PushPattern) {
            _matched = true;
            _builder = new StringConcatenation();
            _builder.append("Smart::IPushClientPattern<");
            _commObjectCppList = this.getCommObjectCppList(pattern, (Boolean)false);
            _builder.append((Object)_commObjectCppList);
            _builder.append(">");
            _switchResult = _builder.toString();
        }
        if (!_matched && pattern instanceof EventPattern) {
            _matched = true;
            _builder = new StringConcatenation();
            _builder.append("Smart::IEventClientPattern<");
            _commObjectCppList = this.getCommObjectCppList(pattern, (Boolean)false);
            _builder.append((Object)_commObjectCppList);
            _builder.append(">");
            _switchResult = _builder.toString();
        }
        if (!_matched && pattern instanceof SendPattern) {
            _matched = true;
            _builder = new StringConcatenation();
            _builder.append("Smart::ISendServerPattern<");
            _commObjectCppList = this.getCommObjectCppList(pattern, (Boolean)false);
            _builder.append((Object)_commObjectCppList);
            _builder.append(">");
            _switchResult = _builder.toString();
        }
        if (!_matched) {
            _switchResult = "";
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    protected String _getPortDefinition(RequestPort port) {
        String _xblockexpression = null;
        CommunicationPattern pattern = this.getPattern((ComponentPort)port);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Smart::IQueryClientPattern<");
        CharSequence _commObjectCppList = this.getCommObjectCppList(pattern, (Boolean)true);
        _builder.append((Object)_commObjectCppList);
        _builder.append(">");
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    protected String _getPortDefinition(AnswerPort port) {
        String _xblockexpression = null;
        CommunicationPattern pattern = this.getPattern((ComponentPort)port);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Smart::IQueryServerPattern<");
        CharSequence _commObjectCppList = this.getCommObjectCppList(pattern, (Boolean)false);
        _builder.append((Object)_commObjectCppList);
        _builder.append(">");
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    protected String _getPortImplementation(OutputPort port) {
        CharSequence _commObjectCppList;
        StringConcatenation _builder;
        String _xblockexpression = null;
        CommunicationPattern pattern = this.getPattern((ComponentPort)port);
        String _switchResult = null;
        boolean _matched = false;
        if (pattern instanceof PushPattern) {
            _matched = true;
            _builder = new StringConcatenation();
            _builder.append("SmartACE::PushServer<");
            _commObjectCppList = this.getCommObjectCppList(pattern, (Boolean)true);
            _builder.append((Object)_commObjectCppList);
            _builder.append(">");
            _switchResult = _builder.toString();
        }
        if (!_matched && pattern instanceof EventPattern) {
            _matched = true;
            _builder = new StringConcatenation();
            _builder.append("SmartACE::EventServer<");
            _commObjectCppList = this.getCommObjectCppList(pattern, (Boolean)true);
            _builder.append((Object)_commObjectCppList);
            _builder.append(">");
            _switchResult = _builder.toString();
        }
        if (!_matched && pattern instanceof SendPattern) {
            _matched = true;
            _builder = new StringConcatenation();
            _builder.append("SmartACE::SendClient<");
            _commObjectCppList = this.getCommObjectCppList(pattern, (Boolean)true);
            _builder.append((Object)_commObjectCppList);
            _builder.append(">");
            _switchResult = _builder.toString();
        }
        if (!_matched) {
            _switchResult = "";
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    protected String _getPortImplementation(InputPort port) {
        CharSequence _commObjectCppList;
        StringConcatenation _builder;
        String _xblockexpression = null;
        CommunicationPattern pattern = this.getPattern((ComponentPort)port);
        String _switchResult = null;
        boolean _matched = false;
        if (pattern instanceof PushPattern) {
            _matched = true;
            _builder = new StringConcatenation();
            _builder.append("SmartACE::PushClient<");
            _commObjectCppList = this.getCommObjectCppList(pattern, (Boolean)false);
            _builder.append((Object)_commObjectCppList);
            _builder.append(">");
            _switchResult = _builder.toString();
        }
        if (!_matched && pattern instanceof EventPattern) {
            _matched = true;
            _builder = new StringConcatenation();
            _builder.append("SmartACE::EventClient<");
            _commObjectCppList = this.getCommObjectCppList(pattern, (Boolean)false);
            _builder.append((Object)_commObjectCppList);
            _builder.append(">");
            _switchResult = _builder.toString();
        }
        if (!_matched && pattern instanceof SendPattern) {
            _matched = true;
            _builder = new StringConcatenation();
            _builder.append("SmartACE::SendServer<");
            _commObjectCppList = this.getCommObjectCppList(pattern, (Boolean)false);
            _builder.append((Object)_commObjectCppList);
            _builder.append(">");
            _switchResult = _builder.toString();
        }
        if (!_matched) {
            _switchResult = "";
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    protected String _getPortImplementation(RequestPort port) {
        String _xblockexpression = null;
        CommunicationPattern pattern = this.getPattern((ComponentPort)port);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("SmartACE::QueryClient<");
        CharSequence _commObjectCppList = this.getCommObjectCppList(pattern, (Boolean)true);
        _builder.append((Object)_commObjectCppList);
        _builder.append(">");
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    protected String _getPortImplementation(AnswerPort port) {
        String _xblockexpression = null;
        CommunicationPattern pattern = this.getPattern((ComponentPort)port);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("SmartACE::QueryServer<");
        CharSequence _commObjectCppList = this.getCommObjectCppList(pattern, (Boolean)false);
        _builder.append((Object)_commObjectCppList);
        _builder.append(">");
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    protected Map<String, CommunicationObject> _getCommunicationObjects(OutputPort port) {
        HashMap<String, CommunicationObject> objects = new HashMap<String, CommunicationObject>();
        CommunicationPattern pattern = this.getPattern((ComponentPort)port);
        boolean _matched = false;
        if (pattern instanceof PushPattern) {
            _matched = true;
            objects.put("Data", ((PushPattern)pattern).getDataType());
        }
        if (!_matched && pattern instanceof EventPattern) {
            _matched = true;
            objects.put("Activation", ((EventPattern)pattern).getActivationType());
            objects.put("Event", ((EventPattern)pattern).getEventType());
            objects.put("EventState", ((EventPattern)pattern).getEventStateType());
        }
        if (!_matched && pattern instanceof SendPattern) {
            _matched = true;
            objects.put("Data", ((SendPattern)pattern).getDataType());
        }
        return objects;
    }

    protected Map<String, CommunicationObject> _getCommunicationObjects(InputPort port) {
        HashMap<String, CommunicationObject> objects = new HashMap<String, CommunicationObject>();
        CommunicationPattern pattern = this.getPattern((ComponentPort)port);
        boolean _matched = false;
        if (pattern instanceof PushPattern) {
            _matched = true;
            objects.put("Data", ((PushPattern)pattern).getDataType());
        }
        if (!_matched && pattern instanceof EventPattern) {
            _matched = true;
            objects.put("Activation", ((EventPattern)pattern).getActivationType());
            objects.put("Event", ((EventPattern)pattern).getEventType());
        }
        if (!_matched && pattern instanceof SendPattern) {
            _matched = true;
            objects.put("Data", ((SendPattern)pattern).getDataType());
        }
        return objects;
    }

    protected Map<String, CommunicationObject> _getCommunicationObjects(RequestPort port) {
        HashMap<String, CommunicationObject> objects = new HashMap<String, CommunicationObject>();
        CommunicationPattern pattern = this.getPattern((ComponentPort)port);
        if (pattern instanceof QueryPattern) {
            objects.put("Request", ((QueryPattern)pattern).getRequestType());
            objects.put("Answer", ((QueryPattern)pattern).getAnswerType());
        }
        return objects;
    }

    protected Map<String, CommunicationObject> _getCommunicationObjects(AnswerPort port) {
        HashMap<String, CommunicationObject> objects = new HashMap<String, CommunicationObject>();
        CommunicationPattern pattern = this.getPattern((ComponentPort)port);
        if (pattern instanceof QueryPattern) {
            objects.put("Request", ((QueryPattern)pattern).getRequestType());
            objects.put("Answer", ((QueryPattern)pattern).getAnswerType());
        }
        return objects;
    }

    public String getSourceMainMethod(ComponentPort port) {
        String _xblockexpression = null;
        CommunicationPattern pattern = this.getPattern(port);
        String _switchResult = null;
        boolean _matched = false;
        if (pattern instanceof PushPattern) {
            _matched = true;
            _switchResult = "put";
        }
        if (!_matched && pattern instanceof EventPattern) {
            _matched = true;
            _switchResult = "put";
        }
        if (!_matched && pattern instanceof SendPattern) {
            _matched = true;
            _switchResult = "send";
        }
        if (!_matched && pattern instanceof QueryPattern) {
            _matched = true;
            _switchResult = "query";
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    public String getCommObjectsParameterList(OutputPort port) {
        String result = "";
        Set<Map.Entry<String, CommunicationObject>> entrySet = this.getCommunicationObjects((ComponentPort)port).entrySet();
        for (Map.Entry<String, CommunicationObject> obj : entrySet) {
            Map.Entry _head;
            boolean _tripleNotEquals;
            boolean bl = _tripleNotEquals = obj != (_head = (Map.Entry)IterableExtensions.head(entrySet));
            if (_tripleNotEquals) {
                String _result = result;
                result = String.valueOf(_result) + ", ";
            }
            String _result_1 = result;
            CharSequence _fullyQualifiedNameCpp = this.comm.getFullyQualifiedNameCpp(obj.getValue());
            String _plus = _fullyQualifiedNameCpp + " &";
            String _nameInstance = this.nameInstance((AbstractComponentElement)port);
            String _plus_1 = String.valueOf(_plus) + _nameInstance;
            String _key = obj.getKey();
            String _plus_2 = String.valueOf(_plus_1) + _key;
            String _plus_3 = String.valueOf(_plus_2) + "Object";
            result = String.valueOf(_result_1) + _plus_3;
        }
        return result;
    }

    public String getCommObjectsParameterList(InputPort port) {
        String _plus_3;
        String _plus_2;
        String _nameInstance;
        String _plus_1;
        String _plus;
        CharSequence _fullyQualifiedNameCpp;
        String result = "";
        CommunicationPattern pattern = this.getPattern((ComponentPort)port);
        boolean _matched = false;
        if (pattern instanceof PushPattern) {
            _matched = true;
            _fullyQualifiedNameCpp = this.comm.getFullyQualifiedNameCpp(((PushPattern)pattern).getDataType());
            _plus = "const " + _fullyQualifiedNameCpp;
            _plus_1 = String.valueOf(_plus) + " &";
            _nameInstance = this.nameInstance((AbstractComponentElement)port);
            _plus_2 = String.valueOf(_plus_1) + _nameInstance;
            result = _plus_3 = String.valueOf(_plus_2) + "DataObject";
        }
        if (!_matched && pattern instanceof SendPattern) {
            _matched = true;
            _fullyQualifiedNameCpp = this.comm.getFullyQualifiedNameCpp(((SendPattern)pattern).getDataType());
            _plus = "const " + _fullyQualifiedNameCpp;
            _plus_1 = String.valueOf(_plus) + " &";
            _nameInstance = this.nameInstance((AbstractComponentElement)port);
            _plus_2 = String.valueOf(_plus_1) + _nameInstance;
            result = _plus_3 = String.valueOf(_plus_2) + "DataObject";
        }
        if (!_matched && pattern instanceof QueryPattern) {
            String _plus_4;
            _matched = true;
            _fullyQualifiedNameCpp = this.comm.getFullyQualifiedNameCpp(((QueryPattern)pattern).getRequestType());
            _plus = "const " + _fullyQualifiedNameCpp;
            _plus_1 = String.valueOf(_plus) + " &";
            _nameInstance = this.nameInstance((AbstractComponentElement)port);
            _plus_2 = String.valueOf(_plus_1) + _nameInstance;
            String _name = ((QueryPattern)pattern).getRequestType().getName();
            String _plus_32 = String.valueOf(_plus_2) + _name;
            String _result = result = (_plus_4 = String.valueOf(_plus_32) + "RequestObject, ");
            CharSequence _fullyQualifiedNameCpp_1 = this.comm.getFullyQualifiedNameCpp(((QueryPattern)pattern).getAnswerType());
            String _plus_5 = "const " + _fullyQualifiedNameCpp_1;
            String _plus_6 = String.valueOf(_plus_5) + " &";
            String _nameInstance_1 = this.nameInstance((AbstractComponentElement)port);
            String _plus_7 = String.valueOf(_plus_6) + _nameInstance_1;
            String _name_1 = ((QueryPattern)pattern).getAnswerType().getName();
            String _plus_8 = String.valueOf(_plus_7) + _name_1;
            String _plus_9 = String.valueOf(_plus_8) + "AnswerObject";
            result = String.valueOf(_result) + _plus_9;
        }
        if (!_matched && pattern instanceof EventPattern) {
            _matched = true;
            _fullyQualifiedNameCpp = this.comm.getFullyQualifiedNameCpp(((EventPattern)pattern).getActivationType());
            String _result = result = (_plus = _fullyQualifiedNameCpp + " &parameter, ");
            CharSequence _fullyQualifiedNameCpp_1 = this.comm.getFullyQualifiedNameCpp(((EventPattern)pattern).getEventType());
            String _plus_12 = _fullyQualifiedNameCpp_1 + " &event, ";
            String _result_1 = result = String.valueOf(_result) + _plus_12;
            CharSequence _fullyQualifiedNameCpp_2 = this.comm.getFullyQualifiedNameCpp(((EventPattern)pattern).getEventStateType());
            String _plus_22 = "const " + _fullyQualifiedNameCpp_2;
            String _plus_33 = String.valueOf(_plus_22) + " &state";
            result = String.valueOf(_result_1) + _plus_33;
        }
        return result;
    }

    public String getCommObjectsCallerList(ComponentPort port) {
        String result = "";
        Set<Map.Entry<String, CommunicationObject>> entrySet = this.getCommunicationObjects(port).entrySet();
        for (Map.Entry<String, CommunicationObject> obj : entrySet) {
            Map.Entry _head;
            boolean _tripleNotEquals;
            boolean bl = _tripleNotEquals = obj != (_head = (Map.Entry)IterableExtensions.head(entrySet));
            if (_tripleNotEquals) {
                String _result = result;
                result = String.valueOf(_result) + ", ";
            }
            String _result_1 = result;
            String _nameInstance = this.nameInstance((AbstractComponentElement)port);
            String _key = obj.getKey();
            String _plus = String.valueOf(_nameInstance) + _key;
            String _plus_1 = String.valueOf(_plus) + "Object";
            result = String.valueOf(_result_1) + _plus_1;
        }
        return result;
    }

    public HashSet<CommObjectsRepository> getReferencedCommObjRepos(Collection<CommunicationObject> comms) {
        HashSet<CommObjectsRepository> repoNames = new HashSet<CommObjectsRepository>();
        for (CommunicationObject co : comms) {
            EObject _eContainer = co.eContainer();
            repoNames.add((CommObjectsRepository)_eContainer);
        }
        return repoNames;
    }

    public HashSet<ComponentPort> getAllClientPorts(ComponentDefinition comp) {
        HashSet<ComponentPort> clients = new HashSet<ComponentPort>();
        Functions.Function1 _function = it -> {
            OneWayCommunicationService _service = it.getService();
            return _service instanceof ForkingServiceDefinition;
        };
        Iterables.addAll(clients, (Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)comp.getElements(), InputPort.class), (Functions.Function1)_function));
        Iterables.addAll(clients, (Iterable)Iterables.filter((Iterable)comp.getElements(), RequestPort.class));
        Functions.Function1 _function_1 = it -> {
            OneWayCommunicationService _service = it.getService();
            return _service instanceof JoiningServiceDefinition;
        };
        Iterables.addAll(clients, (Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)comp.getElements(), OutputPort.class), (Functions.Function1)_function_1));
        return clients;
    }

    public boolean isSubscriber(ComponentPort svc) {
        ForkingPattern _pattern;
        OneWayCommunicationService sdef;
        return svc instanceof InputPort && (sdef = ((InputPort)svc).getService()) instanceof ForkingServiceDefinition && (_pattern = ((ForkingServiceDefinition)sdef).getPattern()) instanceof PushPattern;
    }

    public Iterable<InputPort> getAllPushClients(ComponentDefinition comp) {
        Functions.Function1 _function = it -> {
            CommunicationPattern _pattern = this.getPattern((ComponentPort)it);
            return _pattern instanceof PushPattern;
        };
        return IterableExtensions.filter((Iterable)Iterables.filter((Iterable)comp.getElements(), InputPort.class), (Functions.Function1)_function);
    }

    public HashSet<ComponentPort> getAllServerPorts(ComponentDefinition comp) {
        HashSet<ComponentPort> servers = new HashSet<ComponentPort>();
        Functions.Function1 _function = it -> {
            OneWayCommunicationService _service = it.getService();
            return _service instanceof JoiningServiceDefinition;
        };
        Iterables.addAll(servers, (Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)comp.getElements(), InputPort.class), (Functions.Function1)_function));
        Iterables.addAll(servers, (Iterable)Iterables.filter((Iterable)comp.getElements(), AnswerPort.class));
        Functions.Function1 _function_1 = it -> {
            OneWayCommunicationService _service = it.getService();
            return _service instanceof ForkingServiceDefinition;
        };
        Iterables.addAll(servers, (Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)comp.getElements(), OutputPort.class), (Functions.Function1)_function_1));
        return servers;
    }

    public String getDefaultMiddlewareString(ComponentPort port) {
        Iterable _filter = Iterables.filter((Iterable)port.getExtensions(), SupportedMiddleware.class);
        for (SupportedMiddleware mw : _filter) {
            boolean _isDefault = mw.isDefault();
            if (!_isDefault) continue;
            return mw.getMiddleware().eClass().getName();
        }
        return ACE_SmartSoft.class.getSimpleName();
    }

    public Collection<ComponentGeneratorExtension> getComponentGeneratorExtensions() {
        try {
            IConfigurationElement[] config;
            ArrayList<ComponentGeneratorExtension> result = new ArrayList<ComponentGeneratorExtension>();
            IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.smartmdsd.xtend.smartsoft.generator.ComponentGeneratorExtension");
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement ext = iConfigurationElementArray[n2];
                Object obj = ext.createExecutableExtension("class");
                if (obj instanceof ComponentGeneratorExtension) {
                    result.add((ComponentGeneratorExtension)obj);
                }
                ++n2;
            }
            return result;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public Collection<ActivityGeneratorExtension> getActivityGeneratorExtensions() {
        try {
            IConfigurationElement[] config;
            ArrayList<ActivityGeneratorExtension> result = new ArrayList<ActivityGeneratorExtension>();
            IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.smartmdsd.xtend.smartsoft.generator.ComponentGeneratorExtension");
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement ext = iConfigurationElementArray[n2];
                Object obj = ext.createExecutableExtension("class");
                if (obj instanceof ActivityGeneratorExtension) {
                    result.add((ActivityGeneratorExtension)obj);
                }
                ++n2;
            }
            return result;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public String getPortDefinition(ComponentPort port) {
        if (port instanceof AnswerPort) {
            return this._getPortDefinition((AnswerPort)port);
        }
        if (port instanceof InputPort) {
            return this._getPortDefinition((InputPort)port);
        }
        if (port instanceof OutputPort) {
            return this._getPortDefinition((OutputPort)port);
        }
        if (port instanceof RequestPort) {
            return this._getPortDefinition((RequestPort)port);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(port).toString());
    }

    public String getPortImplementation(ComponentPort port) {
        if (port instanceof AnswerPort) {
            return this._getPortImplementation((AnswerPort)port);
        }
        if (port instanceof InputPort) {
            return this._getPortImplementation((InputPort)port);
        }
        if (port instanceof OutputPort) {
            return this._getPortImplementation((OutputPort)port);
        }
        if (port instanceof RequestPort) {
            return this._getPortImplementation((RequestPort)port);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(port).toString());
    }

    public Map<String, CommunicationObject> getCommunicationObjects(ComponentPort port) {
        if (port instanceof AnswerPort) {
            return this._getCommunicationObjects((AnswerPort)port);
        }
        if (port instanceof InputPort) {
            return this._getCommunicationObjects((InputPort)port);
        }
        if (port instanceof OutputPort) {
            return this._getCommunicationObjects((OutputPort)port);
        }
        if (port instanceof RequestPort) {
            return this._getCommunicationObjects((RequestPort)port);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(port).toString());
    }
}

