/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtend.smartsoft.generator.component;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.AbstractComponentElement;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.Activity;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinition;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinitionModelUtility;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentPort;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentSubNode;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentSubNodeObserver;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.InputHandler;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.InputPort;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.InputPortLink;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.OutputPort;
import org.eclipse.smartmdsd.ecore.component.coordinationExtension.OperationModeBinding;
import org.eclipse.smartmdsd.ecore.component.seronetExtension.OpcUaReadServer;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommunicationObject;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.CopyrightHelpers;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.commObj.CommObjectGenHelpers;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.ActivityGeneratorExtension;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.ComponentGenHelpers;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.InteractionObserver;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.SmartComponent;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.SmartInputHandler;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class SmartTask {
    @Inject
    @Extension
    private ComponentGenHelpers _componentGenHelpers;
    @Inject
    @Extension
    private CommObjectGenHelpers _commObjectGenHelpers;
    @Inject
    @Extension
    private CopyrightHelpers _copyrightHelpers;
    @Inject
    @Extension
    private SmartComponent _smartComponent;
    @Inject
    @Extension
    private SmartInputHandler _smartInputHandler;
    @Inject
    @Extension
    private InteractionObserver _interactionObserver;

    public String TaskHeaderFileName(Activity h) {
        String _nameClass = this._componentGenHelpers.nameClass((AbstractComponentElement)h);
        return String.valueOf(_nameClass) + "Core.hh";
    }

    public String TaskSourceFileName(Activity h) {
        String _nameClass = this._componentGenHelpers.nameClass((AbstractComponentElement)h);
        return String.valueOf(_nameClass) + "Core.cc";
    }

    public String TaskUserHeaderFileName(Activity h) {
        String _nameClass = this._componentGenHelpers.nameClass((AbstractComponentElement)h);
        return String.valueOf(_nameClass) + ".hh";
    }

    public String TaskUserSourceFileName(Activity h) {
        String _nameClass = this._componentGenHelpers.nameClass((AbstractComponentElement)h);
        return String.valueOf(_nameClass) + ".cc";
    }

    public void CreateSmartTask(Activity t, IFileSystemAccess fsa) {
        fsa.generateFile(this.TaskHeaderFileName(t), this.TaskHeaderFileContent(t));
        fsa.generateFile(this.TaskSourceFileName(t), this.TaskSourceFileContent(t));
        fsa.generateFile(this.TaskUserSourceFileName(t), "SRC_OUTPUT", this.TaskUserSourceFileContent(t));
        fsa.generateFile(this.TaskUserHeaderFileName(t), "SRC_OUTPUT", this.TaskUserHeaderFileContent(t));
    }

    public CharSequence TaskHeaderFileContent(Activity task) {
        Iterator _nameClass_2;
        StringConcatenation _builder = new StringConcatenation();
        String _copyright = this._copyrightHelpers.getCopyright();
        _builder.append(_copyright);
        _builder.newLineIfNotEmpty();
        _builder.append("#ifndef _");
        String _upperCase = this._componentGenHelpers.nameClass((AbstractComponentElement)task).toUpperCase();
        _builder.append(_upperCase);
        _builder.append("_CORE_HH");
        _builder.newLineIfNotEmpty();
        _builder.append("#define _");
        String _upperCase_1 = this._componentGenHelpers.nameClass((AbstractComponentElement)task).toUpperCase();
        _builder.append(_upperCase_1);
        _builder.append("_CORE_HH");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("#include \"aceSmartSoft.hh\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("// include upcall interface");
        _builder.newLine();
        Functions.Function1 _function = it -> it.getName();
        List _sortBy = IterableExtensions.sortBy((Iterable)ComponentDefinitionModelUtility.getInputLinks((ComponentSubNode)task), (Functions.Function1)_function);
        for (InputPortLink inLink : _sortBy) {
            _builder.append("#include \"");
            String _UpcallInterfaceHeaderFileName = this._smartInputHandler.UpcallInterfaceHeaderFileName(inLink.getInputPort());
            _builder.append(_UpcallInterfaceHeaderFileName);
            _builder.append("\"");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("// include communication-objects for output ports");
        _builder.newLine();
        EObject _eContainer = task.eContainer();
        Functions.Function1 _function_1 = it -> {
            Activity _activity = it.getActivity();
            return Objects.equal((Object)_activity, (Object)task);
        };
        Functions.Function1 _function_2 = it -> it.getName();
        List _sortBy_1 = IterableExtensions.sortBy((Iterable)IterableExtensions.filter((Iterable)ComponentDefinitionModelUtility.getOutputPorts((ComponentDefinition)((ComponentDefinition)_eContainer)), (Functions.Function1)_function_1), (Functions.Function1)_function_2);
        for (Object initiator : _sortBy_1) {
            Functions.Function1 _function_3 = it -> it.getName();
            List _sortBy_2 = IterableExtensions.sortBy((Iterable)ComponentDefinitionModelUtility.getAllCommObjects((ComponentPort)initiator), (Functions.Function1)_function_3);
            for (CommunicationObject commObj : _sortBy_2) {
                _builder.append("#include <");
                CharSequence _userClassHeaderFileNameFQN = this._commObjectGenHelpers.getUserClassHeaderFileNameFQN(commObj);
                _builder.append((Object)_userClassHeaderFileNameFQN);
                _builder.append(">");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        _builder.append("// include all interaction-observer interfaces");
        _builder.newLine();
        _builder.append("#include <");
        String _nodeObserverInterfaceHeaderFileName = this._interactionObserver.getNodeObserverInterfaceHeaderFileName((ComponentSubNode)task);
        _builder.append(_nodeObserverInterfaceHeaderFileName);
        _builder.append(">");
        _builder.newLineIfNotEmpty();
        Functions.Function1 _function_4 = it -> this._componentGenHelpers.getNameClass((ComponentSubNodeObserver)it);
        List _sortBy_3 = IterableExtensions.sortBy((Iterable)ComponentDefinitionModelUtility.getObservers((ComponentSubNode)task), (Functions.Function1)_function_4);
        for (Object obs : _sortBy_3) {
            _builder.append("#include <");
            Iterator _nodeObserverInterfaceHeaderFileName_1 = this._interactionObserver.getNodeObserverInterfaceHeaderFileName(obs.getSubject());
            _builder.append((String)((Object)_nodeObserverInterfaceHeaderFileName_1));
            _builder.append(">");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        Collection<ActivityGeneratorExtension> _activityGeneratorExtensions = this._componentGenHelpers.getActivityGeneratorExtensions();
        for (ActivityGeneratorExtension ext : _activityGeneratorExtensions) {
            CharSequence _headerIncludes = ext.getHeaderIncludes(task);
            _builder.append((Object)_headerIncludes);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("class ");
        String _nameClass = this._componentGenHelpers.nameClass((AbstractComponentElement)task);
        _builder.append(_nameClass);
        _builder.append("Core");
        _builder.newLineIfNotEmpty();
        _builder.append(":\tpublic SmartACE::ManagedTask");
        _builder.newLine();
        _builder.append(",\tpublic Smart::TaskTriggerSubject");
        _builder.newLine();
        Functions.Function1 _function_5 = it -> this._componentGenHelpers.getNameClass((ComponentSubNodeObserver)it);
        List _sortBy_4 = IterableExtensions.sortBy((Iterable)ComponentDefinitionModelUtility.getObservers((ComponentSubNode)task), (Functions.Function1)_function_5);
        for (ComponentSubNodeObserver obs_1 : _sortBy_4) {
            _builder.append(",\tpublic ");
            String _nodeObserverInterfaceClassName = this._interactionObserver.getNodeObserverInterfaceClassName(obs_1.getSubject());
            _builder.append(_nodeObserverInterfaceClassName);
            _builder.newLineIfNotEmpty();
        }
        Functions.Function1 _function_6 = it -> it.getName();
        List _sortBy_5 = IterableExtensions.sortBy((Iterable)ComponentDefinitionModelUtility.getInputLinks((ComponentSubNode)task), (Functions.Function1)_function_6);
        for (InputPortLink inLink_1 : _sortBy_5) {
            _builder.append(",\tpublic ");
            String _nameClass_1 = this._componentGenHelpers.nameClass((AbstractComponentElement)inLink_1.getInputPort());
            _builder.append(_nameClass_1);
            _builder.append("UpcallInterface");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("{");
        _builder.newLine();
        _builder.append("private:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("bool useDefaultState; ");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("bool useLogging;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("int taskLoggingId;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("unsigned int currentUpdateCount;");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        Functions.Function1 _function_7 = it -> it.getName();
        List _sortBy_6 = IterableExtensions.sortBy((Iterable)ComponentDefinitionModelUtility.getInputLinks((ComponentSubNode)task), (Functions.Function1)_function_7);
        for (Object inLink_2 : _sortBy_6) {
            _builder.append("\t");
            _builder.append("Smart::StatusCode ");
            String _nameInstance = this._componentGenHelpers.nameInstance((AbstractComponentElement)inLink_2.getInputPort());
            _builder.append(_nameInstance, "\t");
            _builder.append("Status;");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            CharSequence _inputHandlerCommObject = this._componentGenHelpers.getInputHandlerCommObject((ComponentPort)inLink_2.getInputPort());
            _builder.append((Object)_inputHandlerCommObject, "\t");
            _builder.append(" ");
            String _nameInstance_1 = this._componentGenHelpers.nameInstance((AbstractComponentElement)inLink_2.getInputPort());
            _builder.append(_nameInstance_1, "\t");
            _builder.append("Object;");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.newLine();
        Collection<ActivityGeneratorExtension> _activityGeneratorExtensions_1 = this._componentGenHelpers.getActivityGeneratorExtensions();
        for (ActivityGeneratorExtension ext_1 : _activityGeneratorExtensions_1) {
            _builder.append("\t");
            CharSequence _classMemberPrivateDefinition = ext_1.getClassMemberPrivateDefinition(task);
            _builder.append((Object)_classMemberPrivateDefinition, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.newLine();
        _builder.append("protected:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("virtual int execute_protected_region();");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("virtual void updateAllCommObjects();");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("virtual int getPreviousCommObjId();");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("void triggerLogEntry(const int& idOffset);");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        Functions.Function1 _function_8 = it -> this._componentGenHelpers.getNameClass((ComponentSubNodeObserver)it);
        List _sortBy_7 = IterableExtensions.sortBy((Iterable)ComponentDefinitionModelUtility.getObservers((ComponentSubNode)task), (Functions.Function1)_function_8);
        for (ComponentSubNodeObserver obs_2 : _sortBy_7) {
            _builder.append("\t");
            _builder.append("// overload this method in derived classes!");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("virtual void on_update_from(const ");
            _nameClass_2 = this._componentGenHelpers.nameClass((AbstractComponentElement)obs_2.getSubject());
            _builder.append((String)((Object)_nameClass_2), "\t");
            _builder.append("* subject) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("// no-op");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.newLine();
        Functions.Function1 _function_9 = it -> it.getInputPort();
        Functions.Function1 _function_10 = it -> it.getName();
        List _sortBy_8 = IterableExtensions.sortBy((Iterable)IterableExtensions.map((Iterable)ComponentDefinitionModelUtility.getInputLinks((ComponentSubNode)task), (Functions.Function1)_function_9), (Functions.Function1)_function_10);
        for (InputPort input : _sortBy_8) {
            _builder.append("\t");
            _builder.append("// overload and implement this method in derived classes to immediately get all incoming updates from ");
            String _name = input.getName();
            _builder.append(_name, "\t");
            _builder.append(" (as soon as they arrive)");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("virtual void on_");
            String _name_1 = input.getName();
            _builder.append(_name_1, "\t");
            _builder.append("(const ");
            CharSequence _inputHandlerCommObject_1 = this._componentGenHelpers.getInputHandlerCommObject((ComponentPort)input);
            _builder.append((Object)_inputHandlerCommObject_1, "\t");
            _builder.append(" &input) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("// no-op");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("// this method can be safely used from the thread in derived classes");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("inline Smart::StatusCode ");
            String _nameInstance_2 = this._componentGenHelpers.nameInstance((AbstractComponentElement)input);
            _builder.append(_nameInstance_2, "\t");
            _builder.append("GetUpdate(");
            CharSequence _inputHandlerCommObject_2 = this._componentGenHelpers.getInputHandlerCommObject((ComponentPort)input);
            _builder.append((Object)_inputHandlerCommObject_2, "\t");
            _builder.append(" &");
            String _nameInstance_3 = this._componentGenHelpers.nameInstance((AbstractComponentElement)input);
            _builder.append(_nameInstance_3, "\t");
            _builder.append("Object) const");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("// copy local object buffer and return the last status code");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            String _nameInstance_4 = this._componentGenHelpers.nameInstance((AbstractComponentElement)input);
            _builder.append(_nameInstance_4, "\t\t");
            _builder.append("Object = this->");
            String _nameInstance_5 = this._componentGenHelpers.nameInstance((AbstractComponentElement)input);
            _builder.append(_nameInstance_5, "\t\t");
            _builder.append("Object;");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("return ");
            String _nameInstance_6 = this._componentGenHelpers.nameInstance((AbstractComponentElement)input);
            _builder.append(_nameInstance_6, "\t\t");
            _builder.append("Status;");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.newLine();
        EObject _eContainer_1 = task.eContainer();
        Functions.Function1 _function_11 = it -> it.getName();
        List _sortBy_9 = IterableExtensions.sortBy((Iterable)ComponentDefinitionModelUtility.getOutputPorts((ComponentDefinition)((ComponentDefinition)_eContainer_1)), (Functions.Function1)_function_11);
        _nameClass_2 = _sortBy_9.iterator();
        while (_nameClass_2.hasNext()) {
            OutputPort output = (OutputPort)_nameClass_2.next();
            boolean _equals = output.getActivity().equals(task);
            if (!_equals) continue;
            _builder.append("\t");
            _builder.append("// this method is meant to be used in derived classes");
            _builder.newLine();
            boolean _isEventServer = this._componentGenHelpers.isEventServer((AbstractComponentElement)output);
            if (_isEventServer) {
                _builder.append("\t");
                _builder.append("Smart::StatusCode ");
                String _nameInstance_7 = this._componentGenHelpers.nameInstance((AbstractComponentElement)output);
                _builder.append(_nameInstance_7, "\t");
                _builder.append("Put(");
                CharSequence _eventServerStateObject = this._componentGenHelpers.getEventServerStateObject((AbstractComponentElement)output);
                _builder.append((Object)_eventServerStateObject, "\t");
                _builder.append(" &eventState);");
                _builder.newLineIfNotEmpty();
                continue;
            }
            _builder.append("\t");
            _builder.append("Smart::StatusCode ");
            String _nameInstance_8 = this._componentGenHelpers.nameInstance((AbstractComponentElement)output);
            _builder.append(_nameInstance_8, "\t");
            _builder.append("Put(");
            String _commObjectsParameterList = this._componentGenHelpers.getCommObjectsParameterList(output);
            _builder.append(_commObjectsParameterList, "\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.newLine();
        Collection<ActivityGeneratorExtension> _activityGeneratorExtensions_2 = this._componentGenHelpers.getActivityGeneratorExtensions();
        for (ActivityGeneratorExtension ext_2 : _activityGeneratorExtensions_2) {
            _builder.append("\t");
            CharSequence _classMemberProtectedDefinition = ext_2.getClassMemberProtectedDefinition(task);
            _builder.append((Object)_classMemberProtectedDefinition, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.newLine();
        CharSequence _compileNodeSubjectHeader = this._interactionObserver.compileNodeSubjectHeader((ComponentSubNode)task);
        _builder.append((Object)_compileNodeSubjectHeader);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("public:");
        _builder.newLine();
        _builder.append("\t");
        String _nameClass_3 = this._componentGenHelpers.nameClass((AbstractComponentElement)task);
        _builder.append(_nameClass_3, "\t");
        _builder.append("Core(Smart::IComponent *comp, const bool &useDefaultState=true);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("virtual ~");
        String _nameClass_4 = this._componentGenHelpers.nameClass((AbstractComponentElement)task);
        _builder.append(_nameClass_4, "\t");
        _builder.append("Core();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("inline void setUpLogging(const int &taskNbr, const bool &useLogging=true) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this->taskLoggingId = taskNbr;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this->useLogging = useLogging;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("inline bool isLoggingActive() const {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return useLogging;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("inline int getLoggingID() const {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return taskLoggingId;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("inline int getCurrentUpdateCount() const {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return currentUpdateCount;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        Collection<ActivityGeneratorExtension> _activityGeneratorExtensions_3 = this._componentGenHelpers.getActivityGeneratorExtensions();
        for (ActivityGeneratorExtension ext_3 : _activityGeneratorExtensions_3) {
            _builder.append("\t");
            CharSequence _classMemberPublicDefinition = ext_3.getClassMemberPublicDefinition(task);
            _builder.append((Object)_classMemberPublicDefinition, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("};");
        _builder.newLine();
        _builder.append("#endif");
        _builder.newLine();
        return _builder;
    }

    public CharSequence TaskSourceFileContent(Activity task) {
        StringConcatenation _builder = new StringConcatenation();
        String _copyright = this._copyrightHelpers.getCopyright();
        _builder.append(_copyright);
        _builder.newLineIfNotEmpty();
        _builder.append("#include \"");
        String _TaskHeaderFileName = this.TaskHeaderFileName(task);
        _builder.append(_TaskHeaderFileName);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("#include \"");
        String _TaskUserHeaderFileName = this.TaskUserHeaderFileName(task);
        _builder.append(_TaskUserHeaderFileName);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("#include \"");
        EObject _eContainer = task.eContainer();
        String _compHeaderFilename = this._smartComponent.getCompHeaderFilename((ComponentDefinition)_eContainer);
        _builder.append(_compHeaderFilename);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("//FIXME: use logging");
        _builder.newLine();
        _builder.append("//#include \"smartGlobalLogger.hh\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("// include observers");
        _builder.newLine();
        Functions.Function1 _function = it -> this._componentGenHelpers.getNameClass((ComponentSubNodeObserver)it);
        List _sortBy = IterableExtensions.sortBy((Iterable)ComponentDefinitionModelUtility.getObservers((ComponentSubNode)task), (Functions.Function1)_function);
        for (Object observer : _sortBy) {
            ComponentSubNode _subject = observer.getSubject();
            if (_subject instanceof Activity) {
                _builder.append("#include \"");
                ComponentSubNode _subject_1 = observer.getSubject();
                String _TaskUserHeaderFileName_1 = this.TaskUserHeaderFileName((Activity)_subject_1);
                _builder.append(_TaskUserHeaderFileName_1);
                _builder.append("\"");
                _builder.newLineIfNotEmpty();
                continue;
            }
            ComponentSubNode _subject_2 = observer.getSubject();
            if (!(_subject_2 instanceof InputHandler)) continue;
            _builder.append("#include \"");
            ComponentSubNode _subject_3 = observer.getSubject();
            String _InputHandlerUserHeaderFileName = this._smartInputHandler.InputHandlerUserHeaderFileName((InputHandler)_subject_3);
            _builder.append(_InputHandlerUserHeaderFileName);
            _builder.append("\"");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        Collection<ActivityGeneratorExtension> _activityGeneratorExtensions = this._componentGenHelpers.getActivityGeneratorExtensions();
        for (ActivityGeneratorExtension ext : _activityGeneratorExtensions) {
            CharSequence _sourceIncludes = ext.getSourceIncludes(task);
            _builder.append((Object)_sourceIncludes);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        String _nameClass = this._componentGenHelpers.nameClass((AbstractComponentElement)task);
        _builder.append(_nameClass);
        _builder.append("Core::");
        String _nameClass_1 = this._componentGenHelpers.nameClass((AbstractComponentElement)task);
        _builder.append(_nameClass_1);
        _builder.append("Core(Smart::IComponent *comp, const bool &useDefaultState) ");
        _builder.newLineIfNotEmpty();
        _builder.append(":\tSmartACE::ManagedTask(comp)");
        _builder.newLine();
        _builder.append(",\tuseDefaultState(useDefaultState)");
        _builder.newLine();
        _builder.append(",\tuseLogging(false)");
        _builder.newLine();
        _builder.append(",\ttaskLoggingId(0)");
        _builder.newLine();
        _builder.append(",\tcurrentUpdateCount(0)");
        _builder.newLine();
        Functions.Function1 _function_1 = it -> it.getName();
        List _sortBy_1 = IterableExtensions.sortBy((Iterable)ComponentDefinitionModelUtility.getInputLinks((ComponentSubNode)task), (Functions.Function1)_function_1);
        for (Object inLink : _sortBy_1) {
            _builder.append(",\t");
            Iterator<ActivityGeneratorExtension> _nameInstance = this._componentGenHelpers.nameInstance((AbstractComponentElement)inLink.getInputPort());
            _builder.append((String)((Object)_nameInstance));
            _builder.append("Status(Smart::SMART_DISCONNECTED)");
            _builder.newLineIfNotEmpty();
            _builder.append(",\t");
            String _nameInstance_1 = this._componentGenHelpers.nameInstance((AbstractComponentElement)inLink.getInputPort());
            _builder.append(_nameInstance_1);
            _builder.append("Object()");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("{");
        _builder.newLine();
        Collection<ActivityGeneratorExtension> _activityGeneratorExtensions_1 = this._componentGenHelpers.getActivityGeneratorExtensions();
        for (ActivityGeneratorExtension ext_1 : _activityGeneratorExtensions_1) {
            _builder.append("\t");
            CharSequence _classMemberConstruction = ext_1.getClassMemberConstruction(task);
            _builder.append((Object)_classMemberConstruction, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        String _nameClass_2 = this._componentGenHelpers.nameClass((AbstractComponentElement)task);
        _builder.append(_nameClass_2);
        _builder.append("Core::~");
        String _nameClass_3 = this._componentGenHelpers.nameClass((AbstractComponentElement)task);
        _builder.append(_nameClass_3);
        _builder.append("Core()");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        Collection<ActivityGeneratorExtension> _activityGeneratorExtensions_2 = this._componentGenHelpers.getActivityGeneratorExtensions();
        for (ActivityGeneratorExtension ext_2 : _activityGeneratorExtensions_2) {
            _builder.append("\t");
            CharSequence _classMemberDestruction = ext_2.getClassMemberDestruction(task);
            _builder.append((Object)_classMemberDestruction, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        Collection<ActivityGeneratorExtension> _activityGeneratorExtensions_3 = this._componentGenHelpers.getActivityGeneratorExtensions();
        for (ActivityGeneratorExtension ext_3 : _activityGeneratorExtensions_3) {
            CharSequence _sourceImplementation = ext_3.getSourceImplementation(task);
            _builder.append((Object)_sourceImplementation);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        CharSequence _compileNodeSubjectSource = this._interactionObserver.compileNodeSubjectSource((ComponentSubNode)task);
        _builder.append((Object)_compileNodeSubjectSource);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("int ");
        String _nameClass_4 = this._componentGenHelpers.nameClass((AbstractComponentElement)task);
        _builder.append(_nameClass_4);
        _builder.append("Core::execute_protected_region()");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        Iterable _filter = Iterables.filter((Iterable)task.getExtensions(), OperationModeBinding.class);
        for (OperationModeBinding state : _filter) {
            _builder.append("\t");
            _builder.append("if(useDefaultState) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("Smart::StatusCode status = COMP->stateSlave->acquire(\"");
            String _name = state.getName();
            _builder.append(_name, "\t\t");
            _builder.append("\");");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("if(status != Smart::SMART_OK) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("std::cerr << \"");
            String _nameClass_5 = this._componentGenHelpers.nameClass((AbstractComponentElement)task);
            _builder.append(_nameClass_5, "\t\t\t");
            _builder.append("Core: ERROR acquiring state active: \" << status << std::endl;");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("return 0;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// update of comm-objects must be within the protected region to prevent aged comm-object values");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("this->updateAllCommObjects();");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if(useLogging == true) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//FIXME: use logging");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//Smart::LOGGER->log(taskLoggingId, getCurrentUpdateCount(), getPreviousCommObjId());");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// this is the user code (should not internally use the state-pattern any more)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("int retval = this->on_execute();");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// notify all attached interaction observers");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("this->notify_all_interaction_observers();");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// inform all associated tasks about a new update");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("this->trigger_all_tasks();");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// increment current currentUpdateCount for the next iteration");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("currentUpdateCount++;");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        Iterable _filter_1 = Iterables.filter((Iterable)task.getExtensions(), OperationModeBinding.class);
        for (OperationModeBinding state_1 : _filter_1) {
            _builder.append("\t");
            _builder.append("if(useDefaultState) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("COMP->stateSlave->release(\"");
            String _name_1 = state_1.getName();
            _builder.append(_name_1, "\t\t");
            _builder.append("\");");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("return retval;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("void ");
        String _nameClass_6 = this._componentGenHelpers.nameClass((AbstractComponentElement)task);
        _builder.append(_nameClass_6);
        _builder.append("Core::updateAllCommObjects()");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        Functions.Function1 _function_2 = it -> it.getInputPort();
        Functions.Function1 _function_3 = it -> it.getName();
        List _sortBy_2 = IterableExtensions.sortBy((Iterable)IterableExtensions.map((Iterable)ComponentDefinitionModelUtility.getInputLinks((ComponentSubNode)task), (Functions.Function1)_function_2), (Functions.Function1)_function_3);
        Iterator iterator = _sortBy_2.iterator();
        while (iterator.hasNext()) {
            InputPort input = (InputPort)iterator.next();
            _builder.append("\t");
            String _nameInstance_2 = this._componentGenHelpers.nameInstance((AbstractComponentElement)input);
            _builder.append(_nameInstance_2, "\t");
            _builder.append("Status = COMP->");
            String _nameInstance_3 = this._componentGenHelpers.nameInstance((AbstractComponentElement)input);
            _builder.append(_nameInstance_3, "\t");
            _builder.append("InputTaskTrigger->getUpdate(");
            String _nameInstance_4 = this._componentGenHelpers.nameInstance((AbstractComponentElement)input);
            _builder.append(_nameInstance_4, "\t");
            _builder.append("Object);");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.newLine();
        Collection<ActivityGeneratorExtension> _activityGeneratorExtensions_4 = this._componentGenHelpers.getActivityGeneratorExtensions();
        for (ActivityGeneratorExtension ext_4 : _activityGeneratorExtensions_4) {
            _builder.append("\t");
            CharSequence _updateValuesImplementation = ext_4.getUpdateValuesImplementation(task);
            _builder.append((Object)_updateValuesImplementation, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        EObject _eContainer_1 = task.eContainer();
        Functions.Function1 _function_4 = it -> it.getName();
        List _sortBy_3 = IterableExtensions.sortBy((Iterable)ComponentDefinitionModelUtility.getOutputPorts((ComponentDefinition)((ComponentDefinition)_eContainer_1)), (Functions.Function1)_function_4);
        for (OutputPort output : _sortBy_3) {
            boolean _equals = output.getActivity().equals(task);
            if (!_equals) continue;
            _builder.append("// this method is meant to be used in derived classes");
            _builder.newLine();
            _builder.append("Smart::StatusCode ");
            String _nameClass_7 = this._componentGenHelpers.nameClass((AbstractComponentElement)task);
            _builder.append(_nameClass_7);
            _builder.append("Core::");
            String _nameInstance_5 = this._componentGenHelpers.nameInstance((AbstractComponentElement)output);
            _builder.append(_nameInstance_5);
            _builder.append("Put(");
            boolean _isEventServer = this._componentGenHelpers.isEventServer((AbstractComponentElement)output);
            if (_isEventServer) {
                CharSequence _eventServerStateObject = this._componentGenHelpers.getEventServerStateObject((AbstractComponentElement)output);
                _builder.append((Object)_eventServerStateObject);
                _builder.append(" &eventState");
            } else {
                String _commObjectsParameterList = this._componentGenHelpers.getCommObjectsParameterList(output);
                _builder.append(_commObjectsParameterList);
            }
            _builder.append(")");
            _builder.newLineIfNotEmpty();
            _builder.append("{");
            _builder.newLine();
            EObject _eContainer_2 = task.eContainer();
            Functions.Function1 _function_5 = it -> {
                OutputPort _outPort = it.getOutPort();
                return Objects.equal((Object)_outPort, (Object)output);
            };
            Iterable _filter_2 = IterableExtensions.filter((Iterable)Iterables.filter((Iterable)((ComponentDefinition)_eContainer_2).getElements(), OpcUaReadServer.class), (Functions.Function1)_function_5);
            for (OpcUaReadServer opcStatusServer : _filter_2) {
                _builder.append("\t");
                _builder.append("COMP->");
                String _firstLower = StringExtensions.toFirstLower((String)opcStatusServer.getName());
                _builder.append(_firstLower, "\t");
                _builder.append("->put(");
                String _commObjectsCallerList = this._componentGenHelpers.getCommObjectsCallerList((ComponentPort)output);
                _builder.append(_commObjectsCallerList, "\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("Smart::StatusCode result = COMP->");
            String _nameInstance_6 = this._componentGenHelpers.nameInstance((AbstractComponentElement)output);
            _builder.append(_nameInstance_6, "\t");
            _builder.append("->");
            String _sourceMainMethod = this._componentGenHelpers.getSourceMainMethod((ComponentPort)output);
            _builder.append(_sourceMainMethod, "\t");
            _builder.append("(");
            boolean _isEventServer_1 = this._componentGenHelpers.isEventServer((AbstractComponentElement)output);
            if (_isEventServer_1) {
                _builder.append("eventState");
            } else {
                String _commObjectsCallerList_1 = this._componentGenHelpers.getCommObjectsCallerList((ComponentPort)output);
                _builder.append(_commObjectsCallerList_1, "\t");
            }
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("if(useLogging == true) {");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("//FIXME: use logging");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("//Smart::LOGGER->log(pushLoggingId+1, getCurrentUpdateCount(), getPreviousCommObjId());");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("return result;");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("void ");
        String _nameClass_8 = this._componentGenHelpers.nameClass((AbstractComponentElement)task);
        _builder.append(_nameClass_8);
        _builder.append("Core::triggerLogEntry(const int& idOffset)");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if(useLogging == true) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("int logId = taskLoggingId + 2*");
        EObject _eContainer_3 = task.eContainer();
        int _size = IterableExtensions.size((Iterable)ComponentDefinitionModelUtility.getOutputPorts((ComponentDefinition)((ComponentDefinition)_eContainer_3)));
        _builder.append((Object)_size, "\t\t");
        _builder.append(" + idOffset;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("//FIXME: use logging");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//Smart::LOGGER->log(logId, getCurrentUpdateCount(), getPreviousCommObjId());");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("int ");
        String _nameClass_9 = this._componentGenHelpers.nameClass((AbstractComponentElement)task);
        _builder.append(_nameClass_9);
        _builder.append("Core::getPreviousCommObjId()");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// this method needs to be overloaded and implemented in derived classes");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return 0;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence TaskUserHeaderFileContent(Activity task) {
        StringConcatenation _builder = new StringConcatenation();
        String _copyrightWriteOnce = this._copyrightHelpers.getCopyrightWriteOnce();
        _builder.append(_copyrightWriteOnce);
        _builder.newLineIfNotEmpty();
        _builder.append("#ifndef _");
        String _upperCase = this._componentGenHelpers.nameClass((AbstractComponentElement)task).toUpperCase();
        _builder.append(_upperCase);
        _builder.append("_HH");
        _builder.newLineIfNotEmpty();
        _builder.append("#define _");
        String _upperCase_1 = this._componentGenHelpers.nameClass((AbstractComponentElement)task).toUpperCase();
        _builder.append(_upperCase_1);
        _builder.append("_HH");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#include \"");
        String _TaskHeaderFileName = this.TaskHeaderFileName(task);
        _builder.append(_TaskHeaderFileName);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        Collection<ActivityGeneratorExtension> _activityGeneratorExtensions = this._componentGenHelpers.getActivityGeneratorExtensions();
        for (ActivityGeneratorExtension ext : _activityGeneratorExtensions) {
            CharSequence _userHeaderIncludes = ext.getUserHeaderIncludes(task);
            _builder.append((Object)_userHeaderIncludes);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("class ");
        String _nameClass = this._componentGenHelpers.nameClass((AbstractComponentElement)task);
        _builder.append(_nameClass);
        _builder.append("  : public ");
        String _nameClass_1 = this._componentGenHelpers.nameClass((AbstractComponentElement)task);
        _builder.append(_nameClass_1);
        _builder.append("Core");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("private:");
        _builder.newLine();
        Functions.Function1 _function = it -> this._componentGenHelpers.getNameClass((ComponentSubNodeObserver)it);
        List _sortBy = IterableExtensions.sortBy((Iterable)ComponentDefinitionModelUtility.getObservers((ComponentSubNode)task), (Functions.Function1)_function);
        for (ComponentSubNodeObserver obs : _sortBy) {
            _builder.append("\t");
            _builder.append("virtual void on_update_from(const ");
            String _nameClass_2 = this._componentGenHelpers.getNameClass(obs);
            _builder.append(_nameClass_2, "\t");
            _builder.append("* ");
            String _nameInstance = this._componentGenHelpers.nameInstance(obs);
            _builder.append(_nameInstance, "\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        Functions.Function1 _function_1 = it -> it.getName();
        List _sortBy_1 = IterableExtensions.sortBy((Iterable)ComponentDefinitionModelUtility.getInputLinks((ComponentSubNode)task), (Functions.Function1)_function_1);
        for (InputPortLink inLink : _sortBy_1) {
            _builder.append("\t");
            _builder.append("virtual void on_");
            String _name = inLink.getInputPort().getName();
            _builder.append(_name, "\t");
            _builder.append("(const ");
            CharSequence _inputHandlerCommObject = this._componentGenHelpers.getInputHandlerCommObject((ComponentPort)inLink.getInputPort());
            _builder.append((Object)_inputHandlerCommObject, "\t");
            _builder.append(" &input);");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("public:");
        _builder.newLine();
        _builder.append("\t");
        String _nameClass_3 = this._componentGenHelpers.nameClass((AbstractComponentElement)task);
        _builder.append(_nameClass_3, "\t");
        _builder.append("(SmartACE::SmartComponent *comp);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("virtual ~");
        String _nameClass_4 = this._componentGenHelpers.nameClass((AbstractComponentElement)task);
        _builder.append(_nameClass_4, "\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("virtual int on_entry();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("virtual int on_execute();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("virtual int on_exit();");
        _builder.newLine();
        Collection<ActivityGeneratorExtension> _activityGeneratorExtensions_1 = this._componentGenHelpers.getActivityGeneratorExtensions();
        for (ActivityGeneratorExtension ext_1 : _activityGeneratorExtensions_1) {
            _builder.append("\t");
            CharSequence _userClassMemberPublicDefinition = ext_1.getUserClassMemberPublicDefinition(task);
            _builder.append((Object)_userClassMemberPublicDefinition, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("};");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#endif");
        _builder.newLine();
        return _builder;
    }

    public CharSequence TaskUserSourceFileContent(Activity task) {
        StringConcatenation _builder = new StringConcatenation();
        String _copyrightWriteOnce = this._copyrightHelpers.getCopyrightWriteOnce();
        _builder.append(_copyrightWriteOnce);
        _builder.newLineIfNotEmpty();
        _builder.append("#include \"");
        String _TaskUserHeaderFileName = this.TaskUserHeaderFileName(task);
        _builder.append(_TaskUserHeaderFileName);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("#include \"");
        EObject _eContainer = task.eContainer();
        String _compHeaderFilename = this._smartComponent.getCompHeaderFilename((ComponentDefinition)_eContainer);
        _builder.append(_compHeaderFilename);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#include <iostream>");
        _builder.newLine();
        _builder.newLine();
        String _nameClass = this._componentGenHelpers.nameClass((AbstractComponentElement)task);
        _builder.append(_nameClass);
        _builder.append("::");
        String _nameClass_1 = this._componentGenHelpers.nameClass((AbstractComponentElement)task);
        _builder.append(_nameClass_1);
        _builder.append("(SmartACE::SmartComponent *comp) ");
        _builder.newLineIfNotEmpty();
        _builder.append(":\t");
        String _nameClass_2 = this._componentGenHelpers.nameClass((AbstractComponentElement)task);
        _builder.append(_nameClass_2);
        _builder.append("Core(comp)");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("std::cout << \"constructor ");
        String _nameClass_3 = this._componentGenHelpers.nameClass((AbstractComponentElement)task);
        _builder.append(_nameClass_3, "\t");
        _builder.append("\\n\";");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        String _nameClass_4 = this._componentGenHelpers.nameClass((AbstractComponentElement)task);
        _builder.append(_nameClass_4);
        _builder.append("::~");
        String _nameClass_5 = this._componentGenHelpers.nameClass((AbstractComponentElement)task);
        _builder.append(_nameClass_5);
        _builder.append("() ");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("std::cout << \"destructor ");
        String _nameClass_6 = this._componentGenHelpers.nameClass((AbstractComponentElement)task);
        _builder.append(_nameClass_6, "\t");
        _builder.append("\\n\";");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        Functions.Function1 _function = it -> this._componentGenHelpers.getNameClass((ComponentSubNodeObserver)it);
        List _sortBy = IterableExtensions.sortBy((Iterable)ComponentDefinitionModelUtility.getObservers((ComponentSubNode)task), (Functions.Function1)_function);
        for (ComponentSubNodeObserver observer : _sortBy) {
            _builder.append("void ");
            String _nameClass_7 = this._componentGenHelpers.nameClass((AbstractComponentElement)task);
            _builder.append(_nameClass_7);
            _builder.append("::on_update_from(const ");
            String _nameClass_8 = this._componentGenHelpers.nameClass((AbstractComponentElement)observer.getSubject());
            _builder.append(_nameClass_8);
            _builder.append("* ");
            String _nameInstance = this._componentGenHelpers.nameInstance((AbstractComponentElement)observer.getSubject());
            _builder.append(_nameInstance);
            _builder.append(")");
            _builder.newLineIfNotEmpty();
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("// update triggered from ");
            String _nameClass_9 = this._componentGenHelpers.nameClass((AbstractComponentElement)observer.getSubject());
            _builder.append(_nameClass_9, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("// (use a local mutex here, because this method is called from within the thread of ");
            String _name = observer.getSubject().getName();
            _builder.append(_name, "\t");
            _builder.append(")");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        Functions.Function1 _function_1 = it -> it.getName();
        List _sortBy_1 = IterableExtensions.sortBy((Iterable)ComponentDefinitionModelUtility.getInputLinks((ComponentSubNode)task), (Functions.Function1)_function_1);
        for (Object inLink : _sortBy_1) {
            _builder.append("void ");
            String _nameClass_10 = this._componentGenHelpers.nameClass((AbstractComponentElement)task);
            _builder.append(_nameClass_10);
            _builder.append("::on_");
            String _name_1 = inLink.getInputPort().getName();
            _builder.append(_name_1);
            _builder.append("(const ");
            CharSequence _inputHandlerCommObject = this._componentGenHelpers.getInputHandlerCommObject((ComponentPort)inLink.getInputPort());
            _builder.append((Object)_inputHandlerCommObject);
            _builder.append(" &input)");
            _builder.newLineIfNotEmpty();
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("// upcall triggered from InputPort ");
            String _name_2 = inLink.getInputPort().getName();
            _builder.append(_name_2, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("// - use a local mutex here, because this upcal is called asynchroneously from outside of this task");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("// - do not use longer blocking calls here since this upcall blocks the InputPort ");
            String _name_3 = inLink.getInputPort().getName();
            _builder.append(_name_3, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("// - if you need to implement a long-running procedure, do so within the on_execute() method and in");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("//   there, use the method ");
            String _nameInstance_1 = this._componentGenHelpers.nameInstance((AbstractComponentElement)inLink.getInputPort());
            _builder.append(_nameInstance_1, "\t");
            _builder.append("GetUpdate(input) to get a copy of the input object");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
        }
        Collection<ActivityGeneratorExtension> _activityGeneratorExtensions = this._componentGenHelpers.getActivityGeneratorExtensions();
        for (ActivityGeneratorExtension ext : _activityGeneratorExtensions) {
            CharSequence _userSourceImplementation = ext.getUserSourceImplementation(task);
            _builder.append((Object)_userSourceImplementation);
            _builder.newLineIfNotEmpty();
        }
        _builder.append("int ");
        String _nameClass_11 = this._componentGenHelpers.nameClass((AbstractComponentElement)task);
        _builder.append(_nameClass_11);
        _builder.append("::on_entry()");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// do initialization procedures here, which are called once, each time the task is started");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// it is possible to return != 0 (e.g. when initialization fails) then the task is not executed further");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return 0;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.append("int ");
        String _nameClass_12 = this._componentGenHelpers.nameClass((AbstractComponentElement)task);
        _builder.append(_nameClass_12);
        _builder.append("::on_execute()");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// this method is called from an outside loop,");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// hence, NEVER use an infinite loop (like \"while(1)\") here inside!!!");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// also do not use blocking calls which do not result from smartsoft kernel");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// to get the incoming data, use this methods:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("Smart::StatusCode status;");
        _builder.newLine();
        Functions.Function1 _function_2 = it -> it.getInputPort();
        Functions.Function1 _function_3 = it -> it.getName();
        List _sortBy_2 = IterableExtensions.sortBy((Iterable)IterableExtensions.map((Iterable)ComponentDefinitionModelUtility.getInputLinks((ComponentSubNode)task), (Functions.Function1)_function_2), (Functions.Function1)_function_3);
        for (InputPort input : _sortBy_2) {
            _builder.append("\t");
            CharSequence _inputHandlerCommObject_1 = this._componentGenHelpers.getInputHandlerCommObject((ComponentPort)input);
            _builder.append((Object)_inputHandlerCommObject_1, "\t");
            _builder.append(" ");
            String _nameInstance_2 = this._componentGenHelpers.nameInstance((AbstractComponentElement)input);
            _builder.append(_nameInstance_2, "\t");
            _builder.append("Object;");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("status = this->");
            String _nameInstance_3 = this._componentGenHelpers.nameInstance((AbstractComponentElement)input);
            _builder.append(_nameInstance_3, "\t");
            _builder.append("GetUpdate(");
            String _nameInstance_4 = this._componentGenHelpers.nameInstance((AbstractComponentElement)input);
            _builder.append(_nameInstance_4, "\t");
            _builder.append("Object);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("if(status != Smart::SMART_OK) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("std::cerr << status << std::endl;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("// return 0;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("} else {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("std::cout << \"received: \" << ");
            String _nameInstance_5 = this._componentGenHelpers.nameInstance((AbstractComponentElement)input);
            _builder.append(_nameInstance_5, "\t\t");
            _builder.append("Object << std::endl;");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append("std::cout << \"Hello from ");
        String _nameClass_13 = this._componentGenHelpers.nameClass((AbstractComponentElement)task);
        _builder.append(_nameClass_13, "\t");
        _builder.append(" \" << std::endl;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// it is possible to return != 0 (e.g. when the task detects errors), then the outer loop breaks and the task stops");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return 0;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.append("int ");
        String _nameClass_14 = this._componentGenHelpers.nameClass((AbstractComponentElement)task);
        _builder.append(_nameClass_14);
        _builder.append("::on_exit()");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// use this method to clean-up resources which are initialized in on_entry() and needs to be freed before the on_execute() can be called again");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return 0;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }
}

