/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtext.component.componentDefinition.ui.contentassist;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.Activity;
import org.eclipse.smartmdsd.ecore.component.performanceExtension.ActivationConstraints;
import org.eclipse.smartmdsd.ecore.component.performanceExtension.DefaultPeriodicTimer;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.ServiceDefinitionPackage;
import org.eclipse.smartmdsd.xtext.component.componentDefinition.ui.contentassist.AbstractComponentDefinitionProposalProvider;
import org.eclipse.smartmdsd.xtext.indexer.XtextResourceIndex;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;

public class ComponentDefinitionProposalProvider
extends AbstractComponentDefinitionProposalProvider {
    @Inject
    private XtextResourceIndex index;

    @Override
    public void completeComponentDefinition_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        URI uri = model.eResource().getURI();
        boolean _isPlatform = uri.isPlatform();
        if (_isPlatform) {
            String projectName = uri.segment(1);
            acceptor.accept(this.createCompletionProposal(projectName, String.valueOf(projectName) + " - ProjectName", this.getImage(model), context));
        }
    }

    @Override
    public void completeServiceRepoImport_ImportedNamespace(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        Iterable repos = this.index.getVisibleEObjectDescriptions(model, ServiceDefinitionPackage.eINSTANCE.getServiceDefRepository());
        Consumer<IEObjectDescription> _function = repo -> {
            String name = repo.getName().toString();
            String text = String.valueOf(name) + ".*;";
            acceptor.accept(this.createCompletionProposal(text, String.valueOf(name) + " - ServiceRepositoryImport", this.getImage((IEObjectDescription)repo), context));
        };
        repos.forEach(_function);
    }

    @Override
    public void completeDefaultPeriodicTimer_PeriodicActFreq(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeDefaultPeriodicTimer_PeriodicActFreq(model, assignment, context, acceptor);
        if (model instanceof DefaultPeriodicTimer) {
            EObject parent = ((DefaultPeriodicTimer)model).eContainer();
            if (parent instanceof Activity) {
                Iterable _filter = Iterables.filter((Iterable)((Activity)parent).getExtensions(), ActivationConstraints.class);
                for (ActivationConstraints ac : _filter) {
                    double _maxActFreq;
                    boolean _greaterThan_1;
                    boolean _greaterThan;
                    double _minActFreq = ac.getMinActFreq();
                    boolean bl = _greaterThan = _minActFreq > 0.0;
                    if (_greaterThan) {
                        String _string = Double.valueOf(ac.getMinActFreq()).toString();
                        String _plus = String.valueOf(_string) + " Hz";
                        acceptor.accept(this.createCompletionProposal(_plus, context));
                    }
                    boolean bl2 = _greaterThan_1 = (_maxActFreq = ac.getMaxActFreq()) > 0.0;
                    if (!_greaterThan_1) continue;
                    String _string_1 = Double.valueOf(ac.getMaxActFreq()).toString();
                    String _plus_1 = String.valueOf(_string_1) + " Hz";
                    acceptor.accept(this.createCompletionProposal(_plus_1, context));
                }
            }
        } else {
            acceptor.accept(this.createCompletionProposal("10.0 Hz", context));
        }
    }
}

