/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtext.component.componentParameter.validation;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeDefinition;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinition;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ComponentParameter;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ComponentParameterBase;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ComponentParameterPackage;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ParameterInstance;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ParameterSetInstance;
import org.eclipse.smartmdsd.ecore.component.coordinationExtension.CoordinationSlavePort;
import org.eclipse.smartmdsd.ecore.service.coordinationPattern.ParameterPattern;
import org.eclipse.smartmdsd.ecore.service.parameterDefinition.ParameterSetDefinition;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.CoordinationServiceDefinition;
import org.eclipse.smartmdsd.xtext.component.componentParameter.validation.AbstractComponentParameterValidator;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ComponentParameterValidator
extends AbstractComponentParameterValidator {
    @Inject
    private IQualifiedNameProvider fqn;
    protected static final String COMP_PARAM_ISSUE_PREFIX = "org.xtext.component.componentParameter.";
    public static final String MISSING_ATTRIBUTE_REFINEMENTS = "org.xtext.component.componentParameter.MissingAttributeRefinements";
    public static final String SINGLE_PARAM_SET_INSTANCE = "org.xtext.component.componentParameter.SingleParamSetInstance";
    public static final String PARAM_SET_INSTANCE_MATCH_BEHAVIOR_INTERFACE = "org.xtext.component.componentParameter.ParameterSetInstanceMatchBehaviorInterface";
    public static final String MISSING_ATTRIBUTE_VALUE = "org.xtext.component.componentParameter.MissingAttributeValue";

    @Check
    public void checkAllAttributesRefined(ParameterInstance param) {
        boolean _not;
        Functions.Function1 _function = attr -> {
            Functions.Function1 _function_1 = ref -> ref.getAttribute().equals(attr);
            return IterableExtensions.exists((Iterable)param.getAttributes(), (Functions.Function1)_function_1);
        };
        boolean _forall = IterableExtensions.forall((Iterable)param.getParameterDef().getAttributes(), (Functions.Function1)_function);
        boolean bl = _not = !_forall;
        if (_not) {
            this.warning("Missing attribute-refinements", (EStructuralFeature)ComponentParameterPackage.Literals.PARAMETER_INSTANCE__PARAMETER_DEF, MISSING_ATTRIBUTE_REFINEMENTS, new String[0]);
        }
    }

    @Check
    public void checkSingleParamSetInstance(ParameterSetInstance param) {
        EObject parent = param.eContainer();
        if (parent instanceof ComponentParameter) {
            boolean _greaterThan;
            int _size = IterableExtensions.size((Iterable)Iterables.filter((Iterable)((ComponentParameter)parent).getParameters(), ParameterSetInstance.class));
            boolean bl = _greaterThan = _size > 1;
            if (_greaterThan) {
                this.error("Multiple ParameterSetInstances are defined, only one (at most) is allowed.", (EStructuralFeature)ComponentParameterPackage.Literals.PARAMETER_SET_INSTANCE__PARAM_SET, SINGLE_PARAM_SET_INSTANCE, new String[]{param.getParamSet().getName()});
            }
        }
    }

    @Check
    public void checkParameterSetInstanceMatchComponentBehaviorSlaveInterface(ParameterSetInstance paramSetInstance) {
        EObject parent = paramSetInstance.eContainer();
        if (parent instanceof ComponentParameter) {
            CoordinationSlavePort slavePort;
            boolean _tripleNotEquals;
            ComponentDefinition _component = ((ComponentParameter)parent).getComponent();
            boolean bl = _tripleNotEquals = _component != null;
            if (_tripleNotEquals && (slavePort = (CoordinationSlavePort)IterableExtensions.head((Iterable)Iterables.filter((Iterable)((ComponentParameter)parent).getComponent().getElements(), CoordinationSlavePort.class))) != null) {
                ParameterSetDefinition paramSet;
                CoordinationServiceDefinition _service = slavePort.getService();
                ParameterPattern _parameterPattern = null;
                if (_service != null) {
                    _parameterPattern = _service.getParameterPattern();
                }
                ParameterSetDefinition _parameterSet = null;
                if (_parameterPattern != null) {
                    _parameterSet = _parameterPattern.getParameterSet();
                }
                if ((paramSet = _parameterSet) != null) {
                    boolean _not;
                    boolean _equals = paramSet.equals(paramSetInstance.getParamSet());
                    boolean bl2 = _not = !_equals;
                    if (_not) {
                        String _name = paramSetInstance.getParamSet().getName();
                        String _plus = "ParameterSetInstance " + _name;
                        String _plus_1 = String.valueOf(_plus) + " does not match ParameterSet ";
                        String _name_1 = paramSet.getName();
                        String _plus_2 = String.valueOf(_plus_1) + _name_1;
                        String _plus_3 = String.valueOf(_plus_2) + " specified within BehaviorSlaveInterface of Component ";
                        String _name_2 = ((ComponentParameter)parent).getComponent().getName();
                        String _plus_4 = String.valueOf(_plus_3) + _name_2;
                        this.warning(_plus_4, (EStructuralFeature)ComponentParameterPackage.Literals.PARAMETER_SET_INSTANCE__PARAM_SET, PARAM_SET_INSTANCE_MATCH_BEHAVIOR_INTERFACE, new String[]{this.fqn.getFullyQualifiedName((EObject)paramSet).toString()});
                    }
                }
            }
        }
    }

    @Check
    public void checkAttributeHasDefaultValue(AttributeDefinition attr) {
        EObject parent = attr.eContainer();
        if (parent instanceof ComponentParameterBase) {
            boolean _tripleEquals;
            AbstractValue _defaultvalue = attr.getDefaultvalue();
            boolean bl = _tripleEquals = _defaultvalue == null;
            if (_tripleEquals) {
                this.warning("You should assign a default value.", null, MISSING_ATTRIBUTE_VALUE, new String[0]);
            }
        }
    }
}

