/**
 * Copyright (c) 2018 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz
 */
package org.eclipse.smartmdsd.xtext.system.activityArchitecture.ide;

import com.google.inject.Guice;
import com.google.inject.Injector;
import org.eclipse.smartmdsd.xtext.system.activityArchitecture.ActivityArchitectureRuntimeModule;
import org.eclipse.smartmdsd.xtext.system.activityArchitecture.ActivityArchitectureStandaloneSetup;
import org.eclipse.xtext.util.Modules2;

/**
 * Initialization support for running Xtext languages as language servers.
 */
@SuppressWarnings("all")
public class ActivityArchitectureIdeSetup extends ActivityArchitectureStandaloneSetup {
  @Override
  public Injector createInjector() {
    ActivityArchitectureRuntimeModule _activityArchitectureRuntimeModule = new ActivityArchitectureRuntimeModule();
    ActivityArchitectureIdeModule _activityArchitectureIdeModule = new ActivityArchitectureIdeModule();
    return Guice.createInjector(Modules2.mixin(_activityArchitectureRuntimeModule, _activityArchitectureIdeModule));
  }
}
