/**
 * Copyright (c) 2019 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.system.datasheetPropertyChecks.ui.contentassist;

import java.util.Collection;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.datasheet.indexer.WorkspaceDatasheetIndexer;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.DefaultDatasheetProperties;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.TechnologyReadinessLevel;
import org.eclipse.smartmdsd.ecore.system.datasheetPropertyChecks.DatasheetPropertyCheck;
import org.eclipse.smartmdsd.xtext.base.genericDatasheet.GenericDatasheetUtils;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;

/**
 * See https://www.eclipse.org/Xtext/documentation/310_eclipse_support.html#content-assist
 * on how to customize the content assistant.
 */
@SuppressWarnings("all")
public class SystemDatasheetPropertyChecksProposalProvider extends AbstractSystemDatasheetPropertyChecksProposalProvider {
  @Override
  public void completeDatasheetPropertyCheck_PropertyName(final EObject model, final Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
    super.completeDatasheetPropertyCheck_PropertyName(model, assignment, context, acceptor);
    final Set<String> custom_properties = WorkspaceDatasheetIndexer.getInstance().getAllIndexedPropertyNames();
    for (final String property : custom_properties) {
      {
        final String text = (property + " - DatasheetProperty");
        acceptor.accept(this.createCompletionProposal(property, text, null, context));
      }
    }
  }
  
  @Override
  public void completeDatasheetPropertyCheck_PropertyValue(final EObject model, final Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
    super.completeDatasheetPropertyCheck_PropertyValue(model, assignment, context, acceptor);
    if ((model instanceof DatasheetPropertyCheck)) {
      boolean _equals = ((DatasheetPropertyCheck)model).getPropertyName().equals(DefaultDatasheetProperties.SPDX_LICENSE.getLiteral());
      if (_equals) {
        Collection<String> _spdxLicenseNames = GenericDatasheetUtils.getSpdxLicenseNames();
        for (final String license : _spdxLicenseNames) {
          {
            final String text = ("\"" + license);
            acceptor.accept(this.createCompletionProposal(text, context));
          }
        }
      } else {
        boolean _equals_1 = ((DatasheetPropertyCheck)model).getPropertyName().equals(DefaultDatasheetProperties.TECHNOLOGY_READINESS_LEVEL.getLiteral());
        if (_equals_1) {
          for (final TechnologyReadinessLevel trl : TechnologyReadinessLevel.VALUES) {
            {
              String _literal = trl.getLiteral();
              String _plus = ("\"" + _literal);
              final String text = (_plus + "\"");
              acceptor.accept(this.createCompletionProposal(text, context));
            }
          }
        } else {
          final Set<String> all_values = WorkspaceDatasheetIndexer.getInstance().getAllMatchingPropertyValues(((DatasheetPropertyCheck)model).getPropertyName());
          for (final String value : all_values) {
            {
              final String text = (("\"" + value) + "\"");
              acceptor.accept(this.createCompletionProposal(text, context));
            }
          }
        }
      }
    }
  }
}
