/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.system.deployment;

import java.util.List;
import org.eclipse.smartmdsd.ecore.system.deployment.ComponentArtefact;
import org.eclipse.smartmdsd.ecore.system.deployment.DeploymentPackage;
import org.eclipse.smartmdsd.ecore.system.deployment.LoginAccountSelection;
import org.eclipse.smartmdsd.ecore.system.deployment.NetworkInterfaceSelection;
import org.eclipse.xtext.naming.DefaultDeclarativeQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

@SuppressWarnings("all")
public class DeploymentQNameProvider extends DefaultDeclarativeQualifiedNameProvider {
  public QualifiedName qualifiedName(final ComponentArtefact artefact) {
    final QualifiedName parent = super.getFullyQualifiedName(artefact.eContainer());
    final List<INode> nodes = NodeModelUtils.findNodesForFeature(artefact, DeploymentPackage.Literals.COMPONENT_ARTEFACT__COMPONENT);
    boolean _isEmpty = nodes.isEmpty();
    boolean _not = (!_isEmpty);
    if (_not) {
      return parent.append(NodeModelUtils.getTokenText(nodes.get(0)));
    } else {
      boolean _eIsSet = artefact.eIsSet(DeploymentPackage.Literals.COMPONENT_ARTEFACT__COMPONENT);
      if (_eIsSet) {
        return parent.append(artefact.getComponent().getName());
      }
    }
    return QualifiedName.EMPTY;
  }
  
  public QualifiedName qualifiedName(final NetworkInterfaceSelection selection) {
    final QualifiedName parent = super.getFullyQualifiedName(selection.eContainer());
    final List<INode> nodes = NodeModelUtils.findNodesForFeature(selection, DeploymentPackage.Literals.NETWORK_INTERFACE_SELECTION__NETWORK);
    boolean _isEmpty = nodes.isEmpty();
    boolean _not = (!_isEmpty);
    if (_not) {
      return parent.append(NodeModelUtils.getTokenText(nodes.get(0)));
    } else {
      boolean _eIsSet = selection.eIsSet(DeploymentPackage.Literals.NETWORK_INTERFACE_SELECTION__NETWORK);
      if (_eIsSet) {
        return parent.append(selection.getNetwork().getName());
      }
    }
    return QualifiedName.EMPTY;
  }
  
  public QualifiedName qualifiedName(final LoginAccountSelection selection) {
    final QualifiedName parent = super.getFullyQualifiedName(selection.eContainer());
    final List<INode> nodes = NodeModelUtils.findNodesForFeature(selection, DeploymentPackage.Literals.LOGIN_ACCOUNT_SELECTION__LOGIN);
    boolean _isEmpty = nodes.isEmpty();
    boolean _not = (!_isEmpty);
    if (_not) {
      return parent.append(NodeModelUtils.getTokenText(nodes.get(0)));
    } else {
      boolean _eIsSet = selection.eIsSet(DeploymentPackage.Literals.LOGIN_ACCOUNT_SELECTION__LOGIN);
      if (_eIsSet) {
        return parent.append(selection.getLogin().getName());
      }
    }
    return QualifiedName.EMPTY;
  }
}
