/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtext.system.deployment.ui.contentassist;

import com.google.inject.Inject;
import java.util.function.Consumer;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.system.targetPlatform.TargetPlatformPackage;
import org.eclipse.smartmdsd.xtext.indexer.XtextResourceIndex;
import org.eclipse.smartmdsd.xtext.system.deployment.ui.contentassist.AbstractDeploymentProposalProvider;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;

public class DeploymentProposalProvider
extends AbstractDeploymentProposalProvider {
    @Inject
    private XtextResourceIndex index;

    @Override
    public void completeDeploymentModel_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeDeploymentModel_Name(model, assignment, context, acceptor);
        if (model != null) {
            URI uri = model.eResource().getURI();
            boolean _isPlatform = uri.isPlatform();
            if (_isPlatform) {
                String projectName = uri.segment(1);
                acceptor.accept(this.createCompletionProposal(projectName, String.valueOf(projectName) + " - ProjectName", this.getImage(model), context));
            }
        } else {
            IWorkbench iworkbench = PlatformUI.getWorkbench();
            if (iworkbench != null) {
                IWorkbenchWindow iworkbenchwindow = iworkbench.getActiveWorkbenchWindow();
                IWorkbenchPage iworkbenchpage = iworkbenchwindow.getActivePage();
                String resourceName = ((IResource)iworkbenchpage.getActiveEditor().getEditorInput().getAdapter(IResource.class)).getName();
                String projectName_1 = resourceName.substring(0, resourceName.indexOf("."));
                acceptor.accept(this.createCompletionProposal(projectName_1, String.valueOf(projectName_1) + " - ProjectName", null, context));
            }
        }
    }

    @Override
    public void completeTargetPlatformReference_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        Iterable platforms = this.index.getVisibleEObjectDescriptions(model, TargetPlatformPackage.eINSTANCE.getTargetPlatformDefinition());
        Consumer<IEObjectDescription> _function = platform -> {
            String fqn = platform.getName().toString();
            String simpleName = platform.getName().getLastSegment();
            String text = String.valueOf(simpleName) + " using " + fqn;
            acceptor.accept(this.createCompletionProposal(text, String.valueOf(fqn) + " - TargetPlatform", this.getImage((IEObjectDescription)platform), context));
        };
        platforms.forEach(_function);
    }
}

