/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.system.systemParameter.formatting2;

import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeDefinition;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeRefinement;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.InlineEnumerationType;
import org.eclipse.smartmdsd.ecore.system.systemParameter.ComponentParameterInstance;
import org.eclipse.smartmdsd.ecore.system.systemParameter.ParameterRefinement;
import org.eclipse.smartmdsd.ecore.system.systemParameter.SystemParamModel;
import org.eclipse.smartmdsd.xtext.base.basicAttributes.formatting2.BasicAttributesFormatter;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;

@SuppressWarnings("all")
public class SystemParameterFormatter extends BasicAttributesFormatter {
  protected void _format(final SystemParamModel systemParamModel, @Extension final IFormattableDocument document) {
    EList<ComponentParameterInstance> _components = systemParamModel.getComponents();
    for (final ComponentParameterInstance componentParameterInstance : _components) {
      document.<ComponentParameterInstance>format(componentParameterInstance);
    }
  }
  
  protected void _format(final ComponentParameterInstance componentParameterInstance, @Extension final IFormattableDocument document) {
    EList<ParameterRefinement> _parameters = componentParameterInstance.getParameters();
    for (final ParameterRefinement parameterRefinement : _parameters) {
      document.<ParameterRefinement>format(parameterRefinement);
    }
  }
  
  public void format(final Object componentParameterInstance, final IFormattableDocument document) {
    if (componentParameterInstance instanceof XtextResource) {
      _format((XtextResource)componentParameterInstance, document);
      return;
    } else if (componentParameterInstance instanceof AttributeDefinition) {
      _format((AttributeDefinition)componentParameterInstance, document);
      return;
    } else if (componentParameterInstance instanceof AttributeRefinement) {
      _format((AttributeRefinement)componentParameterInstance, document);
      return;
    } else if (componentParameterInstance instanceof InlineEnumerationType) {
      _format((InlineEnumerationType)componentParameterInstance, document);
      return;
    } else if (componentParameterInstance instanceof ComponentParameterInstance) {
      _format((ComponentParameterInstance)componentParameterInstance, document);
      return;
    } else if (componentParameterInstance instanceof SystemParamModel) {
      _format((SystemParamModel)componentParameterInstance, document);
      return;
    } else if (componentParameterInstance instanceof EObject) {
      _format((EObject)componentParameterInstance, document);
      return;
    } else if (componentParameterInstance == null) {
      _format((Void)null, document);
      return;
    } else if (componentParameterInstance != null) {
      _format(componentParameterInstance, document);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(componentParameterInstance, document).toString());
    }
  }
}
