/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.system.systemParameter.scoping;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeRefinement;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.BasicAttributesPackage;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ComponentParameter;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ComponentParameterBase;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ComponentParameterModelUtility;
import org.eclipse.smartmdsd.ecore.system.systemParameter.ComponentParameterInstance;
import org.eclipse.smartmdsd.ecore.system.systemParameter.ParameterRefinement;
import org.eclipse.smartmdsd.ecore.system.systemParameter.SystemParamModel;
import org.eclipse.smartmdsd.ecore.system.systemParameter.SystemParameterPackage;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

/**
 * This class contains custom scoping description.
 * 
 * See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#scoping
 * on how and when to use it.
 */
@SuppressWarnings("all")
public class SystemParameterScopeProvider extends AbstractSystemParameterScopeProvider {
  @Inject
  private ComponentParameterModelUtility util;
  
  @Override
  public IScope getScope(final EObject context, final EReference reference) {
    EReference _componentParameterInstance_ComponentInstance = SystemParameterPackage.eINSTANCE.getComponentParameterInstance_ComponentInstance();
    boolean _equals = Objects.equal(reference, _componentParameterInstance_ComponentInstance);
    if (_equals) {
      final EObject parent = context.eContainer();
      if ((parent instanceof SystemParamModel)) {
        return Scopes.scopeFor(((SystemParamModel)parent).getSystem().getComponents());
      }
    } else {
      EReference _parameterRefinement_Parameter = SystemParameterPackage.eINSTANCE.getParameterRefinement_Parameter();
      boolean _equals_1 = Objects.equal(reference, _parameterRefinement_Parameter);
      if (_equals_1) {
        final EObject parent_1 = context.eContainer();
        if ((parent_1 instanceof ComponentParameterInstance)) {
          ComponentParameter _componentParam = ((ComponentParameterInstance)parent_1).getComponentParam();
          boolean _tripleNotEquals = (_componentParam != null);
          if (_tripleNotEquals) {
            return Scopes.scopeFor(Iterables.<ComponentParameterBase>filter(IteratorExtensions.<EObject>toIterable(((ComponentParameterInstance)parent_1).getComponentParam().eAllContents()), ComponentParameterBase.class));
          } else {
            return IScope.NULLSCOPE;
          }
        }
      } else {
        EReference _attributeRefinement_Attribute = BasicAttributesPackage.eINSTANCE.getAttributeRefinement_Attribute();
        boolean _equals_2 = Objects.equal(reference, _attributeRefinement_Attribute);
        if (_equals_2) {
          EObject paramRefinement = context;
          if ((paramRefinement instanceof AttributeRefinement)) {
            paramRefinement = context.eContainer();
          }
          if ((paramRefinement instanceof ParameterRefinement)) {
            return Scopes.scopeFor(this.util.getAttributeDefs(((ParameterRefinement)paramRefinement).getParameter()));
          }
        }
      }
    }
    return super.getScope(context, reference);
  }
}
