/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.system.systemParameter.validation;

import com.google.common.collect.Iterables;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ComponentParametersRef;
import org.eclipse.smartmdsd.ecore.system.systemParameter.ComponentParameterInstance;
import org.eclipse.smartmdsd.ecore.system.systemParameter.SystemParameterPackage;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * This class contains custom validation rules.
 * 
 * See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#validation
 */
@SuppressWarnings("all")
public class SystemParameterValidator extends AbstractSystemParameterValidator {
  protected static final String SYS_PARAM_ISSUE_PREFIX = "org.xtext.system.systemParameter.";
  
  public static final String INVALID_COMP_PARAM = (SystemParameterValidator.SYS_PARAM_ISSUE_PREFIX + "InvalidComponentParameter");
  
  @Check
  public void checkComponentParameter(final ComponentParameterInstance instance) {
    final ComponentParametersRef componentParams = IterableExtensions.<ComponentParametersRef>head(Iterables.<ComponentParametersRef>filter(instance.getComponentInstance().getComponent().getElements(), ComponentParametersRef.class));
    if ((componentParams != null)) {
      boolean _equals = instance.getComponentParam().equals(componentParams.getParameter());
      boolean _not = (!_equals);
      if (_not) {
        this.error("Invalid ComponentParameter", 
          SystemParameterPackage.Literals.COMPONENT_PARAMETER_INSTANCE__COMPONENT_PARAM, 
          SystemParameterValidator.INVALID_COMP_PARAM, 
          componentParams.getParameter().getName());
      }
    }
  }
}
