/**
 * Copyright (c) 2021 Toolify Robotics GmbH
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Matthias Lutz, Alex Lotz, Dennis Stampfer
 */
package eu.toolify.xtend.generators.domainmodels.json;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import eu.toolify.xtend.generators.CopyrightHelpers;
import org.eclipse.emf.common.util.EList;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractAttributeType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeDefinition;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.InlineEnumerationType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.PRIMITIVE_TYPE_NAME;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.PrimitiveType;
import org.eclipse.smartmdsd.ecore.service.communicationObject.AbstractCommElement;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommElementReference;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommunicationObject;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommunicationObjectUtility;
import org.eclipse.smartmdsd.ecore.service.communicationObject.Enumeration;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.commObj.CommObjectGenHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class JsonTransformation {
  @Inject
  @Extension
  private CopyrightHelpers _copyrightHelpers;
  
  @Inject
  @Extension
  private CommObjectGenHelpers _commObjectGenHelpers;
  
  @Inject
  @Extension
  private CommunicationObjectUtility _communicationObjectUtility;
  
  public String getJsonHeaderFileName(final CommunicationObject co) {
    String _firstUpper = StringExtensions.toFirstUpper(co.getName());
    return (_firstUpper + "JSON.hh");
  }
  
  public String getJsonSourceFileName(final CommunicationObject co) {
    String _firstUpper = StringExtensions.toFirstUpper(co.getName());
    return (_firstUpper + "JSON.cc");
  }
  
  public String getUserClassHeaderFileName(final CommunicationObject co) {
    String _firstUpper = StringExtensions.toFirstUpper(co.getName());
    return (_firstUpper + ".hh");
  }
  
  public CharSequence generateJsonHeaderFile(final CommunicationObject co) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyright = this._copyrightHelpers.getCopyright();
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#ifndef ");
    String _upperCase = co.getName().toUpperCase();
    _builder.append(_upperCase);
    _builder.append("_JSON_TRANSFORMATION_H_");
    _builder.newLineIfNotEmpty();
    _builder.append("#define ");
    String _upperCase_1 = co.getName().toUpperCase();
    _builder.append(_upperCase_1);
    _builder.append("_JSON_TRANSFORMATION_H_");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#include <nlohmann/json.hpp>");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#include <");
    CharSequence _repoNamespace = this._commObjectGenHelpers.getRepoNamespace(co);
    _builder.append(_repoNamespace);
    _builder.append("/");
    CharSequence _idlHeaderFileName = this._commObjectGenHelpers.getIdlHeaderFileName(co);
    _builder.append(_idlHeaderFileName);
    _builder.append(">");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("namespace ");
    CharSequence _repoNamespace_1 = this._commObjectGenHelpers.getRepoNamespace(co);
    _builder.append(_repoNamespace_1);
    _builder.append("IDL {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("void to_json(const ");
    CharSequence _repoNamespace_2 = this._commObjectGenHelpers.getRepoNamespace(co);
    _builder.append(_repoNamespace_2, "\t");
    _builder.append("IDL::");
    CharSequence _userClassName = this._commObjectGenHelpers.getUserClassName(co);
    _builder.append(_userClassName, "\t");
    _builder.append("& obj, nlohmann::json& j);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("void from_json(const nlohmann::json& j, ");
    CharSequence _repoNamespace_3 = this._commObjectGenHelpers.getRepoNamespace(co);
    _builder.append(_repoNamespace_3, "\t");
    _builder.append("IDL::");
    CharSequence _userClassName_1 = this._commObjectGenHelpers.getUserClassName(co);
    _builder.append(_userClassName_1, "\t");
    _builder.append("& obj);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("} // end namespace ");
    CharSequence _repoNamespace_4 = this._commObjectGenHelpers.getRepoNamespace(co);
    _builder.append(_repoNamespace_4);
    _builder.append("IDL");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#endif // ");
    String _upperCase_2 = co.getName().toUpperCase();
    _builder.append(_upperCase_2);
    _builder.append("_JSON_TRANSFORMATION_H_");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public String getEnumerationInclude(final AbstractAttributeType attrType) {
    if ((attrType instanceof CommElementReference)) {
      final AbstractCommElement typeName = ((CommElementReference)attrType).getTypeName();
      if ((typeName instanceof Enumeration)) {
        CharSequence _repoNamespace = this._commObjectGenHelpers.getRepoNamespace(typeName);
        String _plus = ("#include <" + _repoNamespace);
        String _plus_1 = (_plus + "/");
        CharSequence _enumClassFileName = this._commObjectGenHelpers.getEnumClassFileName(((Enumeration)typeName));
        String _plus_2 = (_plus_1 + _enumClassFileName);
        return (_plus_2 + ">");
      }
    }
    return "";
  }
  
  public CharSequence generateJsonSourceFile(final CommunicationObject obj) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyright = this._copyrightHelpers.getCopyright();
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#include \"");
    String _jsonHeaderFileName = this.getJsonHeaderFileName(obj);
    _builder.append(_jsonHeaderFileName);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    {
      EList<AttributeDefinition> _attributes = obj.getAttributes();
      for(final AttributeDefinition attr : _attributes) {
        {
          boolean _isCommunicationObject = this._communicationObjectUtility.isCommunicationObject(attr.getType());
          if (_isCommunicationObject) {
            _builder.append("#include \"");
            CharSequence _repoNamespace = this._commObjectGenHelpers.getRepoNamespace(this._communicationObjectUtility.getCommunicationObjectRef(attr.getType()));
            _builder.append(_repoNamespace);
            _builder.append("JSON/");
            String _jsonHeaderFileName_1 = this.getJsonHeaderFileName(this._communicationObjectUtility.getCommunicationObjectRef(attr.getType()));
            _builder.append(_jsonHeaderFileName_1);
            _builder.append("\"");
            _builder.newLineIfNotEmpty();
          } else {
            boolean _isEnumeration = this._communicationObjectUtility.isEnumeration(attr.getType());
            if (_isEnumeration) {
              String _enumerationInclude = this.getEnumerationInclude(attr.getType());
              _builder.append(_enumerationInclude);
              _builder.newLineIfNotEmpty();
            }
          }
        }
      }
    }
    _builder.newLine();
    _builder.append("namespace ");
    CharSequence _repoNamespace_1 = this._commObjectGenHelpers.getRepoNamespace(obj);
    _builder.append(_repoNamespace_1);
    _builder.append("IDL {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("void to_json(const ");
    CharSequence _repoNamespace_2 = this._commObjectGenHelpers.getRepoNamespace(obj);
    _builder.append(_repoNamespace_2);
    _builder.append("IDL::");
    CharSequence _userClassName = this._commObjectGenHelpers.getUserClassName(obj);
    _builder.append(_userClassName);
    _builder.append("& obj, nlohmann::json& j)");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    {
      EList<AttributeDefinition> _attributes_1 = obj.getAttributes();
      for(final AttributeDefinition attribute : _attributes_1) {
        _builder.append("\t");
        _builder.append("// ");
        String _name = attribute.getName();
        _builder.append(_name, "\t");
        _builder.append(": ");
        String _typeName = this._communicationObjectUtility.getTypeName(attribute.getType());
        _builder.append(_typeName, "\t");
        {
          Boolean _isArrayType = this._communicationObjectUtility.isArrayType(attribute);
          if ((_isArrayType).booleanValue()) {
            _builder.append("[]");
          }
        }
        _builder.newLineIfNotEmpty();
        {
          boolean _isComposedType = this._communicationObjectUtility.isComposedType(attribute.getType());
          if (_isComposedType) {
            {
              Boolean _isArrayType_1 = this._communicationObjectUtility.isArrayType(attribute);
              if ((_isArrayType_1).booleanValue()) {
                _builder.append("\t");
                _builder.append("for(size_t idx=0; idx < obj.");
                String _name_1 = attribute.getName();
                _builder.append(_name_1, "\t");
                _builder.append(".size(); idx++) {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("nlohmann::json array_element;");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("to_json(obj.");
                String _name_2 = attribute.getName();
                _builder.append(_name_2, "\t\t");
                _builder.append(".at(idx), array_element);");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("j[\"");
                String _name_3 = attribute.getName();
                _builder.append(_name_3, "\t\t");
                _builder.append("\"].emplace_back(array_element);");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
              } else {
                _builder.append("\t");
                _builder.append("to_json(obj.");
                String _name_4 = attribute.getName();
                _builder.append(_name_4, "\t");
                _builder.append(", j[\"");
                String _name_5 = attribute.getName();
                _builder.append(_name_5, "\t");
                _builder.append("\"]);");
                _builder.newLineIfNotEmpty();
              }
            }
          } else {
            boolean _isEnumeration_1 = this._communicationObjectUtility.isEnumeration(attribute.getType());
            if (_isEnumeration_1) {
              {
                Boolean _isArrayType_2 = this._communicationObjectUtility.isArrayType(attribute);
                if ((_isArrayType_2).booleanValue()) {
                  _builder.append("\t");
                  _builder.append("for(size_t idx=0; idx < obj.");
                  String _name_6 = attribute.getName();
                  _builder.append(_name_6, "\t");
                  _builder.append(".size(); idx++) {");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t");
                  _builder.append("\t");
                  _builder.append("nlohmann::json array_element = ");
                  CharSequence _referencedRepoNamespace = this._commObjectGenHelpers.getReferencedRepoNamespace(attribute.getType());
                  _builder.append(_referencedRepoNamespace, "\t\t");
                  _builder.append("::");
                  CharSequence _referencedClassName = this._commObjectGenHelpers.getReferencedClassName(attribute.getType());
                  _builder.append(_referencedClassName, "\t\t");
                  _builder.append("(obj.");
                  String _name_7 = attribute.getName();
                  _builder.append(_name_7, "\t\t");
                  _builder.append(".at(idx)).to_string(false);");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t");
                  _builder.append("\t");
                  _builder.append("j[\"");
                  String _name_8 = attribute.getName();
                  _builder.append(_name_8, "\t\t");
                  _builder.append("\"].emplace_back(array_element);");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t");
                  _builder.append("}");
                  _builder.newLine();
                } else {
                  _builder.append("\t");
                  _builder.append("j[\"");
                  String _name_9 = attribute.getName();
                  _builder.append(_name_9, "\t");
                  _builder.append("\"] = ");
                  CharSequence _referencedRepoNamespace_1 = this._commObjectGenHelpers.getReferencedRepoNamespace(attribute.getType());
                  _builder.append(_referencedRepoNamespace_1, "\t");
                  _builder.append("::");
                  CharSequence _referencedClassName_1 = this._commObjectGenHelpers.getReferencedClassName(attribute.getType());
                  _builder.append(_referencedClassName_1, "\t");
                  _builder.append("(obj.");
                  String _name_10 = attribute.getName();
                  _builder.append(_name_10, "\t");
                  _builder.append(").to_string(false);");
                  _builder.newLineIfNotEmpty();
                }
              }
            } else {
              _builder.append("\t");
              _builder.append("j[\"");
              String _name_11 = attribute.getName();
              _builder.append(_name_11, "\t");
              _builder.append("\"] = obj.");
              String _name_12 = attribute.getName();
              _builder.append(_name_12, "\t");
              _builder.append(";");
              _builder.newLineIfNotEmpty();
            }
          }
        }
      }
    }
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("/**");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* this transformation handles missing values and checks for correct types:");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* - missing primitive type values (including simple arrays) are set to zero values");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* - missing object type values are skipped entirely");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* - types are checked before performing the type-cast operation");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("void from_json(const nlohmann::json& j, ");
    CharSequence _repoNamespace_3 = this._commObjectGenHelpers.getRepoNamespace(obj);
    _builder.append(_repoNamespace_3);
    _builder.append("IDL::");
    CharSequence _userClassName_1 = this._commObjectGenHelpers.getUserClassName(obj);
    _builder.append(_userClassName_1);
    _builder.append("& obj)");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    {
      EList<AttributeDefinition> _attributes_2 = obj.getAttributes();
      for(final AttributeDefinition attribute_1 : _attributes_2) {
        _builder.append("\t");
        _builder.append("// ");
        String _name_13 = attribute_1.getName();
        _builder.append(_name_13, "\t");
        _builder.append(": ");
        String _typeName_1 = this._communicationObjectUtility.getTypeName(attribute_1.getType());
        _builder.append(_typeName_1, "\t");
        {
          Boolean _isArrayType_3 = this._communicationObjectUtility.isArrayType(attribute_1);
          if ((_isArrayType_3).booleanValue()) {
            _builder.append("[]");
          }
        }
        _builder.newLineIfNotEmpty();
        {
          boolean _isComposedType_1 = this._communicationObjectUtility.isComposedType(attribute_1.getType());
          if (_isComposedType_1) {
            {
              Boolean _isArrayType_4 = this._communicationObjectUtility.isArrayType(attribute_1);
              if ((_isArrayType_4).booleanValue()) {
                _builder.append("\t");
                _builder.append("if(j.contains(\"");
                String _name_14 = attribute_1.getName();
                _builder.append(_name_14, "\t");
                _builder.append("\") && j[\"");
                String _name_15 = attribute_1.getName();
                _builder.append(_name_15, "\t");
                _builder.append("\"].is_array()) {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("auto j");
                String _name_16 = attribute_1.getName();
                _builder.append(_name_16, "\t\t");
                _builder.append(" = j[\"");
                String _name_17 = attribute_1.getName();
                _builder.append(_name_17, "\t\t");
                _builder.append("\"];");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("obj.");
                String _name_18 = attribute_1.getName();
                _builder.append(_name_18, "\t\t");
                _builder.append(".resize(j");
                String _name_19 = attribute_1.getName();
                _builder.append(_name_19, "\t\t");
                _builder.append(".size());");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("for(size_t idx=0; idx < j");
                String _name_20 = attribute_1.getName();
                _builder.append(_name_20, "\t\t");
                _builder.append(".size(); idx++) {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("// convert the json array values individually");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("if(j");
                String _name_21 = attribute_1.getName();
                _builder.append(_name_21, "\t\t\t");
                _builder.append(".at(idx).is_object()) {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t\t\t");
                _builder.append("// from_json(j");
                String _name_22 = attribute_1.getName();
                _builder.append(_name_22, "\t\t\t\t");
                _builder.append(".at(idx), obj.");
                String _name_23 = attribute_1.getName();
                _builder.append(_name_23, "\t\t\t\t");
                _builder.append(".at(idx));");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t\t\t");
                _builder.append("obj.");
                String _name_24 = attribute_1.getName();
                _builder.append(_name_24, "\t\t\t\t");
                _builder.append("[idx] = j");
                String _name_25 = attribute_1.getName();
                _builder.append(_name_25, "\t\t\t\t");
                _builder.append("[idx].get<");
                CharSequence _repoNamespace_4 = this._commObjectGenHelpers.getRepoNamespace(attribute_1.getType());
                _builder.append(_repoNamespace_4, "\t\t\t\t");
                _builder.append("IDL::");
                String _typeName_2 = this._communicationObjectUtility.getTypeName(attribute_1.getType());
                _builder.append(_typeName_2, "\t\t\t\t");
                _builder.append(">();");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
              } else {
                _builder.append("\t");
                _builder.append("if(j.contains(\"");
                String _name_26 = attribute_1.getName();
                _builder.append(_name_26, "\t");
                _builder.append("\") && j[\"");
                String _name_27 = attribute_1.getName();
                _builder.append(_name_27, "\t");
                _builder.append("\"].is_object()) {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("//from_json(j[\"");
                String _name_28 = attribute_1.getName();
                _builder.append(_name_28, "\t\t");
                _builder.append("\"], obj.");
                String _name_29 = attribute_1.getName();
                _builder.append(_name_29, "\t\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("obj.");
                String _name_30 = attribute_1.getName();
                _builder.append(_name_30, "\t\t");
                _builder.append(" = j[\"");
                String _name_31 = attribute_1.getName();
                _builder.append(_name_31, "\t\t");
                _builder.append("\"].get<");
                CharSequence _repoNamespace_5 = this._commObjectGenHelpers.getRepoNamespace(attribute_1.getType());
                _builder.append(_repoNamespace_5, "\t\t");
                _builder.append("IDL::");
                String _typeName_3 = this._communicationObjectUtility.getTypeName(attribute_1.getType());
                _builder.append(_typeName_3, "\t\t");
                _builder.append(">();");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
              }
            }
          } else {
            boolean _isEnumeration_2 = this._communicationObjectUtility.isEnumeration(attribute_1.getType());
            if (_isEnumeration_2) {
              {
                Boolean _isArrayType_5 = this._communicationObjectUtility.isArrayType(attribute_1);
                if ((_isArrayType_5).booleanValue()) {
                  _builder.append("\t");
                  _builder.append("if(j.contains(\"");
                  String _name_32 = attribute_1.getName();
                  _builder.append(_name_32, "\t");
                  _builder.append("\") && j[\"");
                  String _name_33 = attribute_1.getName();
                  _builder.append(_name_33, "\t");
                  _builder.append("\"].is_array()) {");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t");
                  _builder.append("\t");
                  _builder.append("auto j");
                  String _name_34 = attribute_1.getName();
                  _builder.append(_name_34, "\t\t");
                  _builder.append(" = j[\"");
                  String _name_35 = attribute_1.getName();
                  _builder.append(_name_35, "\t\t");
                  _builder.append("\"];");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t");
                  _builder.append("\t");
                  _builder.append("obj.");
                  String _name_36 = attribute_1.getName();
                  _builder.append(_name_36, "\t\t");
                  _builder.append(".resize(j");
                  String _name_37 = attribute_1.getName();
                  _builder.append(_name_37, "\t\t");
                  _builder.append(".size());");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t");
                  _builder.append("\t");
                  _builder.append("if(j");
                  String _name_38 = attribute_1.getName();
                  _builder.append(_name_38, "\t\t");
                  _builder.append(".at(idx).is_string()) {");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t");
                  _builder.append("\t\t");
                  _builder.append("obj.");
                  String _name_39 = attribute_1.getName();
                  _builder.append(_name_39, "\t\t\t");
                  _builder.append("[idx] = ");
                  CharSequence _referencedRepoNamespace_2 = this._commObjectGenHelpers.getReferencedRepoNamespace(attribute_1.getType());
                  _builder.append(_referencedRepoNamespace_2, "\t\t\t");
                  _builder.append("::");
                  CharSequence _referencedClassName_2 = this._commObjectGenHelpers.getReferencedClassName(attribute_1.getType());
                  _builder.append(_referencedClassName_2, "\t\t\t");
                  _builder.append("::from_string(j");
                  String _name_40 = attribute_1.getName();
                  _builder.append(_name_40, "\t\t\t");
                  _builder.append("[idx].get<std::string>());");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t");
                  _builder.append("\t");
                  _builder.append("}");
                  _builder.newLine();
                  _builder.append("\t");
                  _builder.append("}");
                  _builder.newLine();
                } else {
                  _builder.append("\t");
                  _builder.append("if(j.contains(\"");
                  String _name_41 = attribute_1.getName();
                  _builder.append(_name_41, "\t");
                  _builder.append("\") && j[\"");
                  String _name_42 = attribute_1.getName();
                  _builder.append(_name_42, "\t");
                  _builder.append("\"].is_string()) {");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t");
                  _builder.append("\t");
                  _builder.append("obj.");
                  String _name_43 = attribute_1.getName();
                  _builder.append(_name_43, "\t\t");
                  _builder.append(" = ");
                  CharSequence _referencedRepoNamespace_3 = this._commObjectGenHelpers.getReferencedRepoNamespace(attribute_1.getType());
                  _builder.append(_referencedRepoNamespace_3, "\t\t");
                  _builder.append("::");
                  CharSequence _referencedClassName_3 = this._commObjectGenHelpers.getReferencedClassName(attribute_1.getType());
                  _builder.append(_referencedClassName_3, "\t\t");
                  _builder.append("::from_string(j[\"");
                  String _name_44 = attribute_1.getName();
                  _builder.append(_name_44, "\t\t");
                  _builder.append("\"].get<std::string>());");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t");
                  _builder.append("}");
                  _builder.newLine();
                }
              }
            } else {
              _builder.append("\t");
              _builder.append("if(j.contains(\"");
              String _name_45 = attribute_1.getName();
              _builder.append(_name_45, "\t");
              _builder.append("\") && j[\"");
              String _name_46 = attribute_1.getName();
              _builder.append(_name_46, "\t");
              _builder.append("\"].");
              {
                Boolean _isArrayType_6 = this._communicationObjectUtility.isArrayType(attribute_1);
                if ((_isArrayType_6).booleanValue()) {
                  _builder.append("is_array");
                } else {
                  String _typeCheckName = this.getTypeCheckName(attribute_1.getType());
                  _builder.append(_typeCheckName, "\t");
                }
              }
              _builder.append("()) {");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("\t");
              _builder.append("obj.");
              String _name_47 = attribute_1.getName();
              _builder.append(_name_47, "\t\t");
              _builder.append(" = j[\"");
              String _name_48 = attribute_1.getName();
              _builder.append(_name_48, "\t\t");
              _builder.append("\"].get<");
              String _cppCastType = this.getCppCastType(attribute_1);
              _builder.append(_cppCastType, "\t\t");
              _builder.append(">();");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("}");
              _builder.newLine();
            }
          }
        }
      }
    }
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("} // end namespace ");
    CharSequence _repoNamespace_6 = this._commObjectGenHelpers.getRepoNamespace(obj);
    _builder.append(_repoNamespace_6);
    _builder.append("IDL");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public String getCppCastType(final AttributeDefinition attribute) {
    String result = "";
    Boolean _isArrayType = this._communicationObjectUtility.isArrayType(attribute);
    if ((_isArrayType).booleanValue()) {
      result = "std::vector<";
    }
    String _cppType = this.getCppType(attribute.getType());
    String _plus = (result + _cppType);
    result = _plus;
    Boolean _isArrayType_1 = this._communicationObjectUtility.isArrayType(attribute);
    if ((_isArrayType_1).booleanValue()) {
      result = (result + ">");
    }
    return result;
  }
  
  public String getCppType(final AbstractAttributeType type) {
    String _xifexpression = null;
    if ((type instanceof PrimitiveType)) {
      String _switchResult = null;
      PRIMITIVE_TYPE_NAME _typeName = ((PrimitiveType)type).getTypeName();
      if (_typeName != null) {
        switch (_typeName) {
          case UINT8:
            _switchResult = "unsigned char";
            break;
          case UINT16:
            _switchResult = "unsigned short";
            break;
          case UINT32:
            _switchResult = "unsigned int";
            break;
          case UINT64:
            _switchResult = "unsigned long";
            break;
          case INT8:
            _switchResult = "char";
            break;
          case INT16:
            _switchResult = "short";
            break;
          case INT32:
            _switchResult = "int";
            break;
          case INT64:
            _switchResult = "long";
            break;
          case FLOAT:
            _switchResult = "float";
            break;
          case DOUBLE:
            _switchResult = "double";
            break;
          case BOOLEAN:
            _switchResult = "bool";
            break;
          case STRING:
            _switchResult = "std::string";
            break;
          default:
            break;
        }
      }
      _xifexpression = _switchResult;
    } else {
      if ((type instanceof InlineEnumerationType)) {
        return "int";
      }
    }
    return _xifexpression;
  }
  
  public String getTypeCheckName(final AbstractAttributeType type) {
    if ((type instanceof PrimitiveType)) {
      PRIMITIVE_TYPE_NAME _typeName = ((PrimitiveType)type).getTypeName();
      boolean _lessEqualsThan = (_typeName.compareTo(PRIMITIVE_TYPE_NAME.UINT64) <= 0);
      if (_lessEqualsThan) {
        return "is_number_unsigned";
      } else {
        PRIMITIVE_TYPE_NAME _typeName_1 = ((PrimitiveType)type).getTypeName();
        boolean _lessEqualsThan_1 = (_typeName_1.compareTo(PRIMITIVE_TYPE_NAME.INT64) <= 0);
        if (_lessEqualsThan_1) {
          return "is_number_integer";
        } else {
          PRIMITIVE_TYPE_NAME _typeName_2 = ((PrimitiveType)type).getTypeName();
          boolean _lessEqualsThan_2 = (_typeName_2.compareTo(PRIMITIVE_TYPE_NAME.DOUBLE) <= 0);
          if (_lessEqualsThan_2) {
            return "is_number_float";
          } else {
            PRIMITIVE_TYPE_NAME _typeName_3 = ((PrimitiveType)type).getTypeName();
            boolean _equals = Objects.equal(_typeName_3, PRIMITIVE_TYPE_NAME.BOOLEAN);
            if (_equals) {
              return "is_boolean";
            } else {
              PRIMITIVE_TYPE_NAME _typeName_4 = ((PrimitiveType)type).getTypeName();
              boolean _equals_1 = Objects.equal(_typeName_4, PRIMITIVE_TYPE_NAME.STRING);
              if (_equals_1) {
                return "is_string";
              }
            }
          }
        }
      }
    } else {
      if ((type instanceof InlineEnumerationType)) {
        return "is_number_integer";
      }
    }
    return null;
  }
}
