/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ecore.component.componentDefinition;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.Activity;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.AnswerPort;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinition;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentPort;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentSubNode;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentSubNodeObserver;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.InputHandler;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.InputPort;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.InputPortLink;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.OutputPort;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.RequestHandler;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.RequestPort;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommunicationObject;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.CommunicationServiceDefinition;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.ServiceDefinitionModelUtility;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ComponentDefinitionModelUtility
extends ServiceDefinitionModelUtility {
    public static LinkedHashSet<Activity> getActivityObservationHierarchy(Activity activity) {
        return ComponentDefinitionModelUtility.iterateObservers(activity, CollectionLiterals.newLinkedHashSet());
    }

    private static LinkedHashSet<Activity> iterateObservers(Activity current, LinkedHashSet<Activity> visited) {
        Iterable<ComponentSubNodeObserver> _observers = ComponentDefinitionModelUtility.getObservers(current);
        for (ComponentSubNodeObserver observer : _observers) {
            ComponentSubNode subject = observer.getSubject();
            if (subject instanceof Activity) {
                boolean _not;
                boolean _contains = visited.contains(subject);
                boolean bl = _not = !_contains;
                if (!_not) continue;
                visited.add((Activity)subject);
                visited.addAll(ComponentDefinitionModelUtility.iterateObservers((Activity)subject, visited));
                continue;
            }
            boolean cfr_ignored_0 = subject instanceof RequestHandler;
        }
        return visited;
    }

    public static Iterable<ComponentSubNodeObserver> getObservers(ComponentSubNode node) {
        return Iterables.filter(node.getLinks(), ComponentSubNodeObserver.class);
    }

    public static Iterable<ComponentSubNode> getSubNodes(ComponentDefinition component) {
        return Iterables.filter(component.getElements(), ComponentSubNode.class);
    }

    public static CommunicationServiceDefinition getService(ComponentPort port) {
        boolean _matched = false;
        if (port instanceof InputPort) {
            _matched = true;
            return ((InputPort)port).getService();
        }
        if (!_matched && port instanceof AnswerPort) {
            _matched = true;
            return ((AnswerPort)port).getService();
        }
        if (!_matched && port instanceof OutputPort) {
            _matched = true;
            return ((OutputPort)port).getService();
        }
        if (!_matched && port instanceof RequestPort) {
            _matched = true;
            return ((RequestPort)port).getService();
        }
        return null;
    }

    public static Iterable<InputPortLink> getInputLinks(ComponentSubNode node) {
        return Iterables.filter(node.getLinks(), InputPortLink.class);
    }

    public static Boolean isOptional(ComponentPort port) {
        EObject parent;
        if (port instanceof InputPort && (parent = ((InputPort)port).eContainer()) instanceof ComponentDefinition) {
            boolean _not;
            Functions.Function1 _function = it -> {
                Functions.Function1 _function_1 = it_1 -> Objects.equal((Object)it_1.getInputPort(), (Object)port) && !it_1.isOptional();
                return IterableExtensions.exists(ComponentDefinitionModelUtility.getInputLinks(it), (Functions.Function1)_function_1);
            };
            boolean _exists = IterableExtensions.exists(ComponentDefinitionModelUtility.getActivities((ComponentDefinition)parent), (Functions.Function1)_function);
            boolean bl = _not = !_exists;
            if (_not) {
                boolean _not_1;
                Functions.Function1 _function_1 = it -> {
                    Functions.Function1 _function_2 = it_1 -> Objects.equal((Object)it_1.getInputPort(), (Object)port) && !it_1.isOptional();
                    return IterableExtensions.exists(ComponentDefinitionModelUtility.getInputLinks(it), (Functions.Function1)_function_2);
                };
                boolean _exists_1 = IterableExtensions.exists(ComponentDefinitionModelUtility.getInputHandlers((ComponentDefinition)parent), (Functions.Function1)_function_1);
                boolean bl2 = _not_1 = !_exists_1;
                if (_not_1) {
                    return true;
                }
            }
        }
        return false;
    }

    public static Collection<CommunicationObject> getAllCommObjects(ComponentPort port) {
        return ServiceDefinitionModelUtility.getAllCommObjects((CommunicationServiceDefinition)ComponentDefinitionModelUtility.getService(port));
    }

    public static Collection<CommunicationObject> getAllCommObjects(RequestHandler handler) {
        return ServiceDefinitionModelUtility.getAllCommObjects((CommunicationServiceDefinition)handler.getAnswerPort().getService());
    }

    public static Collection<CommunicationObject> getAllCommObjects(Activity activity) {
        HashSet<CommunicationObject> objects = new HashSet<CommunicationObject>();
        Consumer<InputPortLink> _function = it -> objects.addAll(ComponentDefinitionModelUtility.getAllCommObjects(it.getInputPort()));
        ComponentDefinitionModelUtility.getInputLinks(activity).forEach(_function);
        return objects;
    }

    public static Collection<CommunicationObject> getAllCommObjects(ComponentDefinition component) {
        HashSet<CommunicationObject> objects = new HashSet<CommunicationObject>();
        Consumer<ComponentPort> _function = it -> objects.addAll(ComponentDefinitionModelUtility.getAllCommObjects(it));
        Iterables.filter(component.getElements(), ComponentPort.class).forEach(_function);
        return objects;
    }

    public static Iterable<Activity> getActivities(ComponentDefinition component) {
        return Iterables.filter(component.getElements(), Activity.class);
    }

    public static Iterable<InputHandler> getInputHandlers(ComponentDefinition component) {
        return Iterables.filter(component.getElements(), InputHandler.class);
    }

    public static Iterable<RequestHandler> getRequestHandlers(ComponentDefinition component) {
        return Iterables.filter(component.getElements(), RequestHandler.class);
    }

    public static Iterable<InputPort> getInputPorts(ComponentDefinition component) {
        return Iterables.filter(component.getElements(), InputPort.class);
    }

    public static Iterable<AnswerPort> getAnswerPorts(ComponentDefinition component) {
        return Iterables.filter(component.getElements(), AnswerPort.class);
    }

    public static Iterable<OutputPort> getOutputPorts(ComponentDefinition component) {
        return Iterables.filter(component.getElements(), OutputPort.class);
    }

    public static Iterable<RequestPort> getRequestPorts(ComponentDefinition component) {
        return Iterables.filter(component.getElements(), RequestPort.class);
    }

    public static Iterable<ComponentPort> getPorts(ComponentDefinition component) {
        return Iterables.filter(component.getElements(), ComponentPort.class);
    }
}

