/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ecore.system.datasheetPropertyChecks;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum EvaluationOperator implements Enumerator
{
    EQ(0, "EQ", "=="),
    NEQ(1, "NEQ", "!="),
    LT(2, "LT", "<"),
    LET(3, "LET", "<="),
    GET(4, "GET", ">="),
    GT(5, "GT", ">"),
    COMPATIBLE_TO(6, "COMPATIBLE_TO", "COMPATIBLE_TO");

    public static final int EQ_VALUE = 0;
    public static final int NEQ_VALUE = 1;
    public static final int LT_VALUE = 2;
    public static final int LET_VALUE = 3;
    public static final int GET_VALUE = 4;
    public static final int GT_VALUE = 5;
    public static final int COMPATIBLE_TO_VALUE = 6;
    private static final EvaluationOperator[] VALUES_ARRAY;
    public static final List<EvaluationOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new EvaluationOperator[]{EQ, NEQ, LT, LET, GET, GT, COMPATIBLE_TO};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static EvaluationOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EvaluationOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EvaluationOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EvaluationOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EvaluationOperator get(int value) {
        switch (value) {
            case 0: {
                return EQ;
            }
            case 1: {
                return NEQ;
            }
            case 2: {
                return LT;
            }
            case 3: {
                return LET;
            }
            case 4: {
                return GET;
            }
            case 5: {
                return GT;
            }
            case 6: {
                return COMPATIBLE_TO;
            }
        }
        return null;
    }

    private EvaluationOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

