/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.navigator.content;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.smartmdsd.navigator.content.SiriusDiagramRepresentationItem;
import org.eclipse.smartmdsd.ui.factories.ModelingProjectFactory;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public abstract class AbstractSiriusDiagramContentProvider
implements ITreeContentProvider {
    private StructuredViewer viewer;
    protected static final Object[] NO_CHILDREN = new Object[0];
    protected final Map<IFile, List<SiriusDiagramRepresentationItem>> cachedModelMap = new HashMap<IFile, List<SiriusDiagramRepresentationItem>>();

    protected abstract String getModelFileExtension();

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object getParent(Object element) {
        if (element instanceof SiriusDiagramRepresentationItem) {
            SiriusDiagramRepresentationItem diagram = (SiriusDiagramRepresentationItem)element;
            return diagram.getContainer();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IFile) {
            IFile file = (IFile)element;
            return file.getFileExtension().contentEquals(this.getModelFileExtension());
        }
        return false;
    }

    public Object[] getChildren(Object parentElement) {
        IFile modelFile;
        if (parentElement instanceof IFile && (modelFile = (IFile)parentElement).getFileExtension().contentEquals(this.getModelFileExtension())) {
            List<SiriusDiagramRepresentationItem> diagrams = this.cachedModelMap.get(modelFile);
            if (diagrams == null) {
                this.loadDiagramRepresentationsFor(modelFile);
            } else {
                for (SiriusDiagramRepresentationItem diagram : diagrams) {
                    if (diagram.isLoadedRepresentation()) continue;
                    this.reloadDiagram(diagram);
                }
            }
            return diagrams != null ? diagrams.toArray() : NO_CHILDREN;
        }
        return NO_CHILDREN;
    }

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        if (v instanceof StructuredViewer) {
            this.viewer = (StructuredViewer)v;
        }
    }

    protected void reloadDiagram(final SiriusDiagramRepresentationItem diagram) {
        WorkspaceJob reloadDiagramJob = new WorkspaceJob("Reload diagram(s) for " + diagram.getName()){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                diagram.reloadDiagram(monitor);
                return Status.OK_STATUS;
            }
        };
        reloadDiagramJob.setUser(true);
        reloadDiagramJob.setRule((ISchedulingRule)diagram.getContainer());
        reloadDiagramJob.schedule();
    }

    protected void loadDiagramRepresentationsFor(final IFile modelFile) {
        WorkspaceModifyOperation loadDiagramOperation = new WorkspaceModifyOperation((ISchedulingRule)modelFile){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                IProject project = modelFile.getProject();
                monitor.setTaskName("Load Sirius-diagram(s) for " + modelFile.getName());
                Session session = ModelingProjectFactory.getProjectSession((IProject)project, (IProgressMonitor)monitor);
                ArrayList<SiriusDiagramRepresentationItem> diagrams = new ArrayList<SiriusDiagramRepresentationItem>();
                EList representations = ModelingProjectFactory.getRepresentationsFor((IResource)modelFile, (Session)session);
                for (DRepresentationDescriptor representation : representations) {
                    diagrams.add(new SiriusDiagramRepresentationItem((IResource)modelFile, session, representation));
                }
                AbstractSiriusDiagramContentProvider.this.cachedModelMap.put(modelFile, diagrams);
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)loadDiagramOperation);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (AbstractSiriusDiagramContentProvider.this.viewer != null) {
                        AbstractSiriusDiagramContentProvider.this.viewer.refresh((Object)modelFile);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

