/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.navigator.content;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.smartmdsd.ui.factories.ModelingProjectFactory;
import org.eclipse.ui.IEditorPart;

public class SiriusDiagramRepresentationItem {
    private IResource container;
    private Session session;
    private DRepresentationDescriptor representation;

    public SiriusDiagramRepresentationItem(IResource container, Session session, DRepresentationDescriptor representation) {
        this.container = container;
        this.session = session;
        this.representation = representation;
    }

    public boolean isLoadedRepresentation() {
        return this.session.isOpen() && this.representation.isLoadedRepresentation();
    }

    public IEditorPart openDiagramEditor(IProgressMonitor monitor) {
        return DialectUIManager.INSTANCE.openEditor(this.session, this.representation.getRepresentation(), monitor);
    }

    public IResource getContainer() {
        return this.container;
    }

    public String getName() {
        return this.representation.getName();
    }

    public void reloadDiagram(IProgressMonitor monitor) throws CoreException {
        IProject project = this.container.getProject();
        this.session = ModelingProjectFactory.getProjectSession((IProject)project, (IProgressMonitor)monitor);
        EList representations = ModelingProjectFactory.getRepresentationsFor((IResource)this.container, (Session)this.session);
        for (DRepresentationDescriptor representation : representations) {
            if (!representation.getName().contentEquals(this.representation.getName())) continue;
            this.representation = representation;
        }
    }
}

