/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.navigator.imports;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.smartmdsd.navigator.imports.ImportedProjectsElement;

public class ImportsContentProvider
implements ITreeContentProvider {
    private static final Object[] NO_CHILDREN = new Object[0];
    private final Map<IProject, ImportedProjectsElement> cachedImportsMap = new HashMap<IProject, ImportedProjectsElement>();

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IProject) {
            IProject project = (IProject)parentElement;
            if (project.isOpen()) {
                Object[] objectArray;
                ImportedProjectsElement imports = this.cachedImportsMap.get(project);
                if (imports == null) {
                    imports = new ImportedProjectsElement(project);
                    this.cachedImportsMap.put(project, imports);
                }
                if (imports != null) {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = imports;
                } else {
                    objectArray = NO_CHILDREN;
                }
                return objectArray;
            }
        } else if (parentElement instanceof ImportedProjectsElement) {
            ImportedProjectsElement imports = (ImportedProjectsElement)parentElement;
            return imports.getReferencedProjects();
        }
        return NO_CHILDREN;
    }

    public Object getParent(Object element) {
        if (element instanceof ImportedProjectsElement) {
            ImportedProjectsElement imports = (ImportedProjectsElement)element;
            return imports.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IProject) {
            IProject project = (IProject)element;
            return project.isOpen();
        }
        if (element instanceof ImportedProjectsElement) {
            ImportedProjectsElement imports = (ImportedProjectsElement)element;
            return imports.getReferencedProjects() != null;
        }
        return false;
    }
}

