/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.sirius.component.design;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.action.AbstractExternalJavaAction;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ComponentParametersRef;
import org.eclipse.smartmdsd.sirius.component.design.ComponentParameterViewPart;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

public class DeleteComponentParameterModelFileAction
extends AbstractExternalJavaAction {
    public boolean canExecute(Collection<? extends EObject> arg0) {
        return true;
    }

    public void execute(Collection<? extends EObject> arg0, Map<String, Object> arg1) {
        IViewPart view;
        DDiagramElement diagramElement;
        EObject target;
        EObject selfObject = (EObject)this.getParameter(arg1, "self", EObject.class);
        if (selfObject == null) {
            Iterator<? extends EObject> iterator = arg0.iterator();
            while (iterator.hasNext()) {
                EObject object;
                selfObject = object = iterator.next();
            }
        }
        if (selfObject instanceof DDiagramElement && (target = (diagramElement = (DDiagramElement)selfObject).getTarget()) instanceof ComponentParametersRef && (view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.smartmdsd.sirius.component.design.ComponentParamView")) instanceof ComponentParameterViewPart) {
            ComponentParameterViewPart compViewPart = (ComponentParameterViewPart)view;
            URI xtextResourceUri = compViewPart.getAccordingXtextResourceUri((DRepresentationElement)diagramElement);
            this.askToDeleteModelFile(xtextResourceUri, compViewPart);
        }
    }

    protected void askToDeleteModelFile(URI xtextResourceUri, ComponentParameterViewPart compViewPart) {
        Path modelFilePath;
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IFile modelFile = workspaceRoot.getFile((IPath)(modelFilePath = new Path(xtextResourceUri.toPlatformString(true))));
        if (modelFile.exists()) {
            String messageTitle = "Delete ComponentParameter model file";
            String message = "Do you also want to delete the according model file " + modelFile.getName() + "?";
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            MessageBox dialog = new MessageBox(shell, 196);
            dialog.setText(messageTitle);
            dialog.setMessage(message);
            int result = dialog.open();
            if (result == 64) {
                try {
                    modelFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
                    compViewPart.removeResourceBase(xtextResourceUri);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            } else {
                System.out.println("No pressed");
            }
        }
    }
}

