/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.sirius.component.design;

import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.smartmdsd.ecore.base.documentation.AbstractDocumentationElement;
import org.eclipse.smartmdsd.ecore.base.mixedport.MixedportPackage;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.AbstractComponentElement;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.Activity;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.AnswerPort;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefModel;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinition;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentPort;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentPortExtension;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.InputPort;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ComponentParameterPackage;
import org.eclipse.smartmdsd.ecore.component.coordinationExtension.CoordinationSlavePort;
import org.eclipse.smartmdsd.ecore.component.seronetExtension.OpcUaDeviceClient;
import org.eclipse.smartmdsd.ecore.component.seronetExtension.SeronetExtensionFactory;
import org.eclipse.smartmdsd.ecore.component.seronetExtension.SupportedMiddleware;
import org.eclipse.smartmdsd.ecore.service.componentMode.ComponentModeCollection;
import org.eclipse.smartmdsd.ecore.service.roboticMiddleware.ACE_SmartSoft;
import org.eclipse.smartmdsd.ecore.service.roboticMiddleware.DDS_SmartSoft;
import org.eclipse.smartmdsd.ecore.service.roboticMiddleware.OpcUa_SeRoNet;
import org.eclipse.smartmdsd.ecore.service.roboticMiddleware.RoboticMiddleware;
import org.eclipse.smartmdsd.ecore.service.roboticMiddleware.RoboticMiddlewareFactory;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.ServiceDefRepository;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.ServiceDefinitionPackage;
import org.eclipse.smartmdsd.sirius.utils.DiagramHelperServices;
import org.eclipse.smartmdsd.xtext.component.componentDefinition.ui.internal.ComponentDefinitionActivator;
import org.eclipse.smartmdsd.xtext.service.serviceDefinition.ui.internal.ServiceDefinitionActivator;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.xtext.resource.IContainer;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;

public class Services {
    public EObject print(EObject context) {
        System.out.println("context: " + context);
        return context;
    }

    public EObject importModels(EObject context) {
        DiagramHelperServices.triggerModelImportCommand();
        return context;
    }

    public Boolean hasLogo(EObject context) {
        ComponentDefinition component;
        if (context instanceof ComponentDefinition && (component = (ComponentDefinition)context).getLogo() != null) {
            String logoString = component.getLogo();
            Path logoPath = new Path(logoString);
            IFile logoFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)logoPath);
            if (logoFile.exists()) {
                return true;
            }
        }
        return false;
    }

    public String getDocumentationString(EObject context) {
        AbstractDocumentationElement docu;
        String short_description;
        String text = context.eClass().getName();
        Object name_atribute = context.eGet(context.eClass().getEStructuralFeature("name"));
        if (name_atribute instanceof String) {
            String name = (String)name_atribute;
            text = String.valueOf(text) + ": " + name + "\n";
        } else {
            text = String.valueOf(text) + "\n";
        }
        if (context instanceof AbstractDocumentationElement && !(short_description = (docu = (AbstractDocumentationElement)context).getFirstDocumentationLine()).isEmpty()) {
            text = String.valueOf(text) + short_description;
        }
        return text;
    }

    public String getProjectName(EObject obj) {
        return DiagramHelperServices.getProjectName((EObject)obj);
    }

    public String openXmlFileDialog(EObject context) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        String currentProjectName = context.eResource().getURI().segment(1);
        IProject currentProject = workspaceRoot.getProject(currentProjectName);
        ArrayList<IFile> elements = new ArrayList<IFile>();
        String fileExtension = "xml";
        String modelFolderName = "model";
        IFolder modelFolder = currentProject.getFolder(modelFolderName);
        try {
            IResource[] iResourceArray = modelFolder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFile modelFile;
                IResource member = iResourceArray[n2];
                if (member instanceof IFile && (modelFile = (IFile)member).getFileExtension().equals(fileExtension)) {
                    elements.add(modelFile);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
        boolean multipleSelection = false;
        String dialogMessage = "Select XML file containing the device's OPC UA Information Model";
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)labelProvider);
        dialog.setTitle("OPC UA Information Model Selection");
        dialog.setMessage(dialogMessage);
        dialog.setElements(elements.toArray());
        dialog.setMultipleSelection(multipleSelection);
        if (dialog.open() == 0) {
            Object[] results = dialog.getResult();
            IFile modelFile = (IFile)results[0];
            String modelFilePath = "/" + currentProjectName + "/" + modelFile.getProjectRelativePath();
            if (context instanceof OpcUaDeviceClient) {
                OpcUaDeviceClient client = (OpcUaDeviceClient)context;
                client.setOpcuaXmlFile(modelFilePath);
            }
        }
        return "";
    }

    public Boolean hasNoOpcUa(EObject context) {
        return this.hasOpcUaMW(context) == false;
    }

    public Boolean hasOpcUaMW(EObject context) {
        if (context instanceof ComponentPort) {
            ComponentPort port = (ComponentPort)context;
            for (ComponentPortExtension ex : port.getExtensions()) {
                SupportedMiddleware sm;
                if (!(ex instanceof SupportedMiddleware) || !((sm = (SupportedMiddleware)ex).getMiddleware() instanceof OpcUa_SeRoNet)) continue;
                return true;
            }
        }
        return false;
    }

    public EObject updateOpcUaMW(EObject context, Boolean newValue) {
        if (context instanceof ComponentPort) {
            if (newValue.booleanValue()) {
                if (!this.hasOpcUaMW(context).booleanValue()) {
                    ComponentPort port = (ComponentPort)context;
                    SupportedMiddleware mw = SeronetExtensionFactory.eINSTANCE.createSupportedMiddleware();
                    mw.setMiddleware((RoboticMiddleware)RoboticMiddlewareFactory.eINSTANCE.createOpcUa_SeRoNet());
                    port.getExtensions().add((Object)mw);
                }
            } else {
                ComponentPort port = (ComponentPort)context;
                Iterator it = port.getExtensions().iterator();
                while (it.hasNext()) {
                    SupportedMiddleware sm;
                    if (!(it.next() instanceof SupportedMiddleware) || !((sm = (SupportedMiddleware)it.next()).getMiddleware() instanceof OpcUa_SeRoNet)) continue;
                    it.remove();
                }
            }
        }
        return context;
    }

    public Boolean hasDDSMW(EObject context) {
        if (context instanceof ComponentPort) {
            ComponentPort port = (ComponentPort)context;
            for (ComponentPortExtension ex : port.getExtensions()) {
                SupportedMiddleware sm;
                if (!(ex instanceof SupportedMiddleware) || !((sm = (SupportedMiddleware)ex).getMiddleware() instanceof DDS_SmartSoft)) continue;
                return true;
            }
        }
        return false;
    }

    public EObject updateDDSMW(EObject context, Boolean newValue) {
        if (context instanceof ComponentPort) {
            if (newValue.booleanValue()) {
                if (!this.hasDDSMW(context).booleanValue()) {
                    ComponentPort port = (ComponentPort)context;
                    SupportedMiddleware mw = SeronetExtensionFactory.eINSTANCE.createSupportedMiddleware();
                    mw.setMiddleware((RoboticMiddleware)RoboticMiddlewareFactory.eINSTANCE.createDDS_SmartSoft());
                    port.getExtensions().add((Object)mw);
                }
            } else {
                ComponentPort port = (ComponentPort)context;
                Iterator it = port.getExtensions().iterator();
                while (it.hasNext()) {
                    SupportedMiddleware sm;
                    if (!(it.next() instanceof SupportedMiddleware) || !((sm = (SupportedMiddleware)it.next()).getMiddleware() instanceof DDS_SmartSoft)) continue;
                    it.remove();
                }
            }
        }
        return context;
    }

    public Boolean hasACEMW(EObject context) {
        if (context instanceof ComponentPort) {
            ComponentPort port = (ComponentPort)context;
            for (ComponentPortExtension ex : port.getExtensions()) {
                SupportedMiddleware sm;
                if (!(ex instanceof SupportedMiddleware) || !((sm = (SupportedMiddleware)ex).getMiddleware() instanceof ACE_SmartSoft)) continue;
                return true;
            }
        }
        return false;
    }

    public EObject updateACEMW(EObject context, Boolean newValue) {
        if (context instanceof ComponentPort) {
            if (newValue.booleanValue()) {
                if (!this.hasACEMW(context).booleanValue()) {
                    ComponentPort port = (ComponentPort)context;
                    SupportedMiddleware mw = SeronetExtensionFactory.eINSTANCE.createSupportedMiddleware();
                    mw.setMiddleware((RoboticMiddleware)RoboticMiddlewareFactory.eINSTANCE.createACE_SmartSoft());
                    port.getExtensions().add((Object)mw);
                }
            } else {
                ComponentPort port = (ComponentPort)context;
                Iterator it = port.getExtensions().iterator();
                while (it.hasNext()) {
                    SupportedMiddleware sm;
                    if (!(it.next() instanceof SupportedMiddleware) || !((sm = (SupportedMiddleware)it.next()).getMiddleware() instanceof ACE_SmartSoft)) continue;
                    it.remove();
                }
            }
        }
        return context;
    }

    public Collection<EObject> getActivities(EObject context) {
        ArrayList<EObject> objects = new ArrayList<EObject>();
        if (context instanceof ComponentDefinition) {
            ComponentDefinition component = (ComponentDefinition)context;
            for (AbstractComponentElement element : component.getElements()) {
                if (!(element instanceof Activity)) continue;
                objects.add((EObject)element);
            }
        }
        return objects;
    }

    public Collection<EObject> getAllComponentPorts(EObject context) {
        ComponentDefModel model;
        ComponentDefinition component;
        ArrayList<EObject> objects = new ArrayList<EObject>();
        if (context instanceof ComponentDefModel && (component = (model = (ComponentDefModel)context).getComponent()) != null) {
            for (AbstractComponentElement element : component.getElements()) {
                if (!(element instanceof ComponentPort)) continue;
                objects.add((EObject)element);
            }
        }
        return objects;
    }

    public Collection<EObject> getInputPorts(EObject context) {
        ArrayList<EObject> objects = new ArrayList<EObject>();
        if (context instanceof ComponentDefinition) {
            ComponentDefinition component = (ComponentDefinition)context;
            for (AbstractComponentElement element : component.getElements()) {
                if (!(element instanceof InputPort)) continue;
                objects.add((EObject)element);
            }
        }
        return objects;
    }

    public Collection<EObject> getAnswerPorts(EObject context) {
        ArrayList<EObject> objects = new ArrayList<EObject>();
        if (context instanceof ComponentDefinition) {
            ComponentDefinition component = (ComponentDefinition)context;
            for (AbstractComponentElement element : component.getElements()) {
                if (!(element instanceof AnswerPort)) continue;
                objects.add((EObject)element);
            }
        }
        return objects;
    }

    public Collection<EObject> getComponentOperationModes(EObject context) {
        CoordinationSlavePort port;
        ComponentModeCollection collection;
        ArrayList<EObject> objects = new ArrayList<EObject>();
        if (context instanceof CoordinationSlavePort && (collection = (port = (CoordinationSlavePort)context).getService().getStatePattern().getModes()) != null) {
            objects.addAll((Collection<EObject>)collection.getModes());
        }
        return objects;
    }

    public Collection<EObject> getComponentParameter(EObject context) {
        EClass type = ComponentParameterPackage.eINSTANCE.getComponentParameter();
        Injector injector = this.getServiceDefinitionInjector();
        return this.geXtextIndexEObjetcsByType(injector, context, type);
    }

    public Collection<EObject> getAllServices(EObject repo) {
        ArrayList<EObject> objects = new ArrayList<EObject>();
        if (repo instanceof ServiceDefRepository) {
            objects.addAll((Collection<EObject>)((ServiceDefRepository)repo).getServices());
        }
        return objects;
    }

    public Collection<EObject> getAllOneWayServiceRelatedCandidates(EObject context) {
        Collection<EObject> objects = this.getServiceRepositories(context);
        objects.addAll(this.getAllOneWayServices(context));
        return objects;
    }

    public Collection<EObject> getAllTwoWayServiceRelatedCandidates(EObject context) {
        Collection<EObject> objects = this.getServiceRepositories(context);
        objects.addAll(this.getAllTwoWayServices(context));
        return objects;
    }

    public Collection<EObject> getAllCoordinationServiceRelatedCandidates(EObject context) {
        Collection<EObject> objects = this.getServiceRepositories(context);
        objects.addAll(this.getAllCoordinationServices(context));
        return objects;
    }

    public Collection<EObject> getServiceRepositories(EObject context) {
        Injector injector = this.getServiceDefinitionInjector();
        EClass type = ServiceDefinitionPackage.eINSTANCE.getServiceDefRepository();
        return this.geXtextIndexEObjetcsByType(injector, context, type);
    }

    public Collection<EObject> getAllOneWayServices(EObject context) {
        Injector injector = this.getServiceDefinitionInjector();
        EClass type = ServiceDefinitionPackage.eINSTANCE.getOneWayCommunicationService();
        return this.geXtextIndexEObjetcsByType(injector, context, type);
    }

    public Collection<EObject> getAllTwoWayServices(EObject context) {
        Injector injector = this.getServiceDefinitionInjector();
        EClass type = ServiceDefinitionPackage.eINSTANCE.getTwoWayCommunicationService();
        return this.geXtextIndexEObjetcsByType(injector, context, type);
    }

    public Collection<EObject> getAllCoordinationServices(EObject context) {
        Injector injector = this.getServiceDefinitionInjector();
        EClass type = ServiceDefinitionPackage.eINSTANCE.getCoordinationServiceDefinition();
        return this.geXtextIndexEObjetcsByType(injector, context, type);
    }

    private Injector getServiceDefinitionInjector() {
        return ServiceDefinitionActivator.getInstance().getInjector("org.eclipse.smartmdsd.xtext.service.serviceDefinition.ServiceDefinition");
    }

    public Collection<EObject> getAllRosPorts(EObject context) {
        Injector injector = this.getComponentDefinitionInjector();
        EClass type = MixedportPackage.eINSTANCE.getMixedPortROSBase();
        return this.geXtextIndexEObjetcsByType(injector, context, type);
    }

    private Injector getComponentDefinitionInjector() {
        return ComponentDefinitionActivator.getInstance().getInjector("org.eclipse.smartmdsd.xtext.component.componentDefinition.ComponentDefinition");
    }

    private Collection<EObject> geXtextIndexEObjetcsByType(Injector injector, EObject context, EClass type) {
        ArrayList<EObject> objects = new ArrayList<EObject>();
        ResourceDescriptionsProvider rdp = (ResourceDescriptionsProvider)injector.getInstance(ResourceDescriptionsProvider.class);
        IResourceDescriptions descriptions = rdp.getResourceDescriptions(context.eResource());
        IResourceDescription description = descriptions.getResourceDescription(context.eResource().getURI());
        IContainer.Manager manager = (IContainer.Manager)injector.getInstance(IContainer.Manager.class);
        List containters = manager.getVisibleContainers(description, descriptions);
        for (IContainer container : containters) {
            Iterable objectDescriptions = container.getExportedObjectsByType(type);
            for (IEObjectDescription objectDescription : objectDescriptions) {
                EObject objectOrProxy = objectDescription.getEObjectOrProxy();
                if (objectOrProxy.eIsProxy()) {
                    EObject resolvedObject = context.eResource().getResourceSet().getEObject(objectDescription.getEObjectURI(), true);
                    objects.add(resolvedObject);
                    continue;
                }
                objects.add(objectOrProxy);
            }
        }
        return objects;
    }
}

