/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Matthias Lutz, Dennis Stampfer
 */
package org.eclipse.smartmdsd.xtend.smartsoft.generator.commObj;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractAttributeType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.ArrayValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeDefinition;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.PrimitiveType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.SingleValue;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommElementReference;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommunicationObject;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommunicationObjectUtility;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class ConstructorParamGenHelper {
  @Inject
  @Extension
  private CommObjectGenHelpers _commObjectGenHelpers;
  
  @Inject
  @Extension
  private CommunicationObjectUtility _communicationObjectUtility;
  
  public String generateConstructorHeaderParameters(final CommunicationObject co) {
    String _xblockexpression = null;
    {
      List<AttributeDefinition> elements = new ArrayList<AttributeDefinition>();
      final Function1<AttributeDefinition, Boolean> _function = (AttributeDefinition e) -> {
        boolean _defval = this._commObjectGenHelpers.getDefval(e);
        return Boolean.valueOf((!_defval));
      };
      Iterables.<AttributeDefinition>addAll(elements, IterableExtensions.<AttributeDefinition>filter(co.getAttributes(), _function));
      final Function1<AttributeDefinition, Boolean> _function_1 = (AttributeDefinition e) -> {
        return Boolean.valueOf(this._commObjectGenHelpers.getDefval(e));
      };
      Iterables.<AttributeDefinition>addAll(elements, IterableExtensions.<AttributeDefinition>filter(co.getAttributes(), _function_1));
      _xblockexpression = this.generateConstructorParams(elements, true);
    }
    return _xblockexpression;
  }
  
  public String generateConstructorSourceParameters(final CommunicationObject co) {
    String _xblockexpression = null;
    {
      List<AttributeDefinition> elements = new ArrayList<AttributeDefinition>();
      final Function1<AttributeDefinition, Boolean> _function = (AttributeDefinition e) -> {
        boolean _defval = this._commObjectGenHelpers.getDefval(e);
        return Boolean.valueOf((!_defval));
      };
      Iterables.<AttributeDefinition>addAll(elements, IterableExtensions.<AttributeDefinition>filter(co.getAttributes(), _function));
      final Function1<AttributeDefinition, Boolean> _function_1 = (AttributeDefinition e) -> {
        return Boolean.valueOf(this._commObjectGenHelpers.getDefval(e));
      };
      Iterables.<AttributeDefinition>addAll(elements, IterableExtensions.<AttributeDefinition>filter(co.getAttributes(), _function_1));
      _xblockexpression = this.generateConstructorParams(elements, false);
    }
    return _xblockexpression;
  }
  
  public String generateConstructorSourceCoreParameters(final CommunicationObject co) {
    List<AttributeDefinition> elements = new ArrayList<AttributeDefinition>();
    String result = "";
    final Function1<AttributeDefinition, Boolean> _function = (AttributeDefinition e) -> {
      boolean _defval = this._commObjectGenHelpers.getDefval(e);
      return Boolean.valueOf((!_defval));
    };
    Iterables.<AttributeDefinition>addAll(elements, IterableExtensions.<AttributeDefinition>filter(co.getAttributes(), _function));
    final Function1<AttributeDefinition, Boolean> _function_1 = (AttributeDefinition e) -> {
      return Boolean.valueOf(this._commObjectGenHelpers.getDefval(e));
    };
    Iterables.<AttributeDefinition>addAll(elements, IterableExtensions.<AttributeDefinition>filter(co.getAttributes(), _function_1));
    for (final AttributeDefinition el : elements) {
      {
        String _name = el.getName();
        String _plus = (result + _name);
        result = _plus;
        AttributeDefinition _last = IterableExtensions.<AttributeDefinition>last(elements);
        boolean _notEquals = (!Objects.equal(el, _last));
        if (_notEquals) {
          result = (result + ", ");
        }
      }
    }
    return result;
  }
  
  public String generateDefaultConstructorContent(final CommunicationObject co) {
    return this.generateConstructorContent(co.getAttributes());
  }
  
  private String generateConstructorContent(final List<AttributeDefinition> elements) {
    String result = "";
    for (final AttributeDefinition el : elements) {
      boolean _defval = this._commObjectGenHelpers.getDefval(el);
      boolean _equals = (_defval == true);
      if (_equals) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("set");
        String _firstUpper = StringExtensions.toFirstUpper(el.getName());
        _builder.append(_firstUpper);
        _builder.append("(");
        String _generateDefaultValue = this.generateDefaultValue(el);
        _builder.append(_generateDefaultValue);
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        String _plus = (result + _builder);
        result = _plus;
      } else {
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("set");
        String _firstUpper_1 = StringExtensions.toFirstUpper(el.getName());
        _builder_1.append(_firstUpper_1);
        _builder_1.append("(");
        String _plus_1 = (result + _builder_1);
        result = _plus_1;
        boolean _many = this._commObjectGenHelpers.getMany(el);
        if (_many) {
          AbstractAttributeType type = el.getType();
          result = (result + "std::vector<");
          if ((type instanceof CommElementReference)) {
            CharSequence _repoNamespace = this._commObjectGenHelpers.getRepoNamespace(type);
            String _plus_2 = (result + _repoNamespace);
            String _plus_3 = (_plus_2 + "::");
            CharSequence _idlStructName = this._commObjectGenHelpers.getIdlStructName(((CommElementReference)type).getTypeName());
            String _plus_4 = (_plus_3 + _idlStructName);
            result = _plus_4;
          } else {
            if ((type instanceof PrimitiveType)) {
              String _compileCppType = this._commObjectGenHelpers.compileCppType(type);
              String _plus_5 = (result + _compileCppType);
              result = _plus_5;
            }
          }
          result = (result + ">()");
        } else {
          AbstractAttributeType type_1 = el.getType();
          if ((type_1 instanceof CommElementReference)) {
            CharSequence _repoNamespace_1 = this._commObjectGenHelpers.getRepoNamespace(type_1);
            String _plus_6 = (result + _repoNamespace_1);
            String _plus_7 = (_plus_6 + "::");
            CharSequence _idlStructName_1 = this._commObjectGenHelpers.getIdlStructName(((CommElementReference)type_1).getTypeName());
            String _plus_8 = (_plus_7 + _idlStructName_1);
            String _plus_9 = (_plus_8 + "()");
            result = _plus_9;
          }
          if ((type_1 instanceof PrimitiveType)) {
            boolean _isStringType = this._communicationObjectUtility.isStringType(type_1);
            if (_isStringType) {
              result = (result + "\"\"");
            } else {
              boolean _isBooleanType = this._communicationObjectUtility.isBooleanType(type_1);
              if (_isBooleanType) {
                result = (result + "false");
              } else {
                boolean _isRealType = this._communicationObjectUtility.isRealType(type_1);
                if (_isRealType) {
                  result = (result + "0.0");
                } else {
                  result = (result + "0");
                }
              }
            }
          }
        }
        result = (result + ");\n");
      }
    }
    return result;
  }
  
  private String generateConstructorParams(final List<AttributeDefinition> elements, final boolean generateDefval) {
    String result = "";
    for (final AttributeDefinition el : elements) {
      {
        AbstractAttributeType type = el.getType();
        result = (result + "const ");
        boolean _many = this._commObjectGenHelpers.getMany(el);
        if (_many) {
          result = (result + "std::vector<");
        }
        if ((type instanceof CommElementReference)) {
          CharSequence _repoNamespace = this._commObjectGenHelpers.getRepoNamespace(type);
          String _plus = (result + _repoNamespace);
          String _plus_1 = (_plus + "::");
          CharSequence _idlStructName = this._commObjectGenHelpers.getIdlStructName(((CommElementReference)type).getTypeName());
          String _plus_2 = (_plus_1 + _idlStructName);
          result = _plus_2;
        } else {
          if ((type instanceof PrimitiveType)) {
            String _compileCppType = this._commObjectGenHelpers.compileCppType(type);
            String _plus_3 = (result + _compileCppType);
            result = _plus_3;
          }
        }
        boolean _many_1 = this._commObjectGenHelpers.getMany(el);
        if (_many_1) {
          result = (result + ">");
        }
        String _name = el.getName();
        String _plus_4 = ((result + " &") + _name);
        result = _plus_4;
        if ((generateDefval && (this._commObjectGenHelpers.getDefval(el) == true))) {
          String _generateDefaultValue = this.generateDefaultValue(el);
          String _plus_5 = ((result + " = ") + _generateDefaultValue);
          result = _plus_5;
        }
        boolean _equals = el.equals(IterableExtensions.<AttributeDefinition>last(elements));
        boolean _not = (!_equals);
        if (_not) {
          result = (result + ", ");
        }
      }
    }
    return result;
  }
  
  private String generateDefaultValue(final AttributeDefinition el) {
    String result = "";
    AbstractAttributeType type = el.getType();
    boolean _defval = this._commObjectGenHelpers.getDefval(el);
    if (_defval) {
      boolean _many = this._commObjectGenHelpers.getMany(el);
      if (_many) {
        result = (result + "std::vector<");
        if ((type instanceof CommElementReference)) {
          CharSequence _repoNamespace = this._commObjectGenHelpers.getRepoNamespace(type);
          String _plus = (result + _repoNamespace);
          String _plus_1 = (_plus + "::");
          CharSequence _idlStructName = this._commObjectGenHelpers.getIdlStructName(((CommElementReference)type).getTypeName());
          String _plus_2 = (_plus_1 + _idlStructName);
          result = _plus_2;
        } else {
          if ((type instanceof PrimitiveType)) {
            String _compileCppType = this._commObjectGenHelpers.compileCppType(type);
            String _plus_3 = (result + _compileCppType);
            result = _plus_3;
          }
        }
        result = (result + ">");
      }
      if ((this._commObjectGenHelpers.getMany(el) && Objects.equal(this._commObjectGenHelpers.getCardinality(el), "*"))) {
        result = (result + "()");
      } else {
        boolean _many_1 = this._commObjectGenHelpers.getMany(el);
        if (_many_1) {
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("(");
          String _cardinality = this._commObjectGenHelpers.getCardinality(el);
          _builder.append(_cardinality);
          _builder.append(", ");
          String _plus_4 = (result + _builder);
          result = _plus_4;
        }
        if ((type instanceof CommElementReference)) {
          CharSequence _repoNamespace_1 = this._commObjectGenHelpers.getRepoNamespace(type);
          String _plus_5 = (result + _repoNamespace_1);
          String _plus_6 = (_plus_5 + "::");
          CharSequence _idlStructName_1 = this._commObjectGenHelpers.getIdlStructName(((CommElementReference)type).getTypeName());
          String _plus_7 = (_plus_6 + _idlStructName_1);
          String _plus_8 = (_plus_7 + "()");
          result = _plus_8;
        } else {
          if ((type instanceof PrimitiveType)) {
            final AbstractValue defVal = el.getDefaultvalue();
            if ((defVal instanceof ArrayValue)) {
              String _valueString = this._communicationObjectUtility.getValueString(IterableExtensions.<SingleValue>head(((ArrayValue)defVal).getValues()));
              String _plus_9 = (result + _valueString);
              result = _plus_9;
            } else {
              String _valueString_1 = this._communicationObjectUtility.getValueString(defVal);
              String _plus_10 = (result + _valueString_1);
              result = _plus_10;
            }
          }
        }
        boolean _many_2 = this._commObjectGenHelpers.getMany(el);
        if (_many_2) {
          result = (result + ")");
        }
      }
    }
    return result;
  }
}
