/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtend.smartsoft.generator.component;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.List;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.AbstractComponentElement;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinition;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinitionModelUtility;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentPort;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.OutputPort;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommunicationObject;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.CopyrightHelpers;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.commObj.CommObjectGenHelpers;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.ComponentGenHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class SmartEventHandler {
    @Inject
    @Extension
    private CopyrightHelpers _copyrightHelpers;
    @Inject
    @Extension
    private ComponentGenHelpers _componentGenHelpers;
    @Inject
    @Extension
    private CommObjectGenHelpers _commObjectGenHelpers;

    public String EventTestHandlerCoreHeaderFileName(ComponentPort service) {
        String _nameClass = this._componentGenHelpers.nameClass((AbstractComponentElement)service);
        return String.valueOf(_nameClass) + "EventTestHandlerCore.hh";
    }

    public String EventTestHandlerUserHeaderFileName(ComponentPort service) {
        String _nameClass = this._componentGenHelpers.nameClass((AbstractComponentElement)service);
        return String.valueOf(_nameClass) + "EventTestHandler.hh";
    }

    public String EventTestHandlerUserSourceFileName(ComponentPort service) {
        String _nameClass = this._componentGenHelpers.nameClass((AbstractComponentElement)service);
        return String.valueOf(_nameClass) + "EventTestHandler.cc";
    }

    public void CreateEventTestHandlers(ComponentDefinition comp, IFileSystemAccess fsa) {
        Functions.Function1 _function = it -> this._componentGenHelpers.isEventServer((AbstractComponentElement)it);
        Iterable _filter = IterableExtensions.filter((Iterable)Iterables.filter((Iterable)comp.getElements(), OutputPort.class), (Functions.Function1)_function);
        for (OutputPort eventServer : _filter) {
            fsa.generateFile(this.EventTestHandlerCoreHeaderFileName((ComponentPort)eventServer), this.HandlerHeaderFileContent(eventServer));
            fsa.generateFile(this.EventTestHandlerUserHeaderFileName((ComponentPort)eventServer), "SRC_OUTPUT", this.HandlerUserHeaderFileContent(eventServer));
            fsa.generateFile(this.EventTestHandlerUserSourceFileName((ComponentPort)eventServer), "SRC_OUTPUT", this.HandlerUserSourceFileContent(eventServer));
        }
    }

    public CharSequence HandlerHeaderFileContent(OutputPort service) {
        StringConcatenation _builder = new StringConcatenation();
        String _copyright = this._copyrightHelpers.getCopyright();
        _builder.append(_copyright);
        _builder.newLineIfNotEmpty();
        _builder.append("#ifndef _");
        String _upperCase = service.getName().toUpperCase();
        _builder.append(_upperCase);
        _builder.append("_EVENT_TEST_HANDLER_CORE_HH");
        _builder.newLineIfNotEmpty();
        _builder.append("#define _");
        String _upperCase_1 = service.getName().toUpperCase();
        _builder.append(_upperCase_1);
        _builder.append("_EVENT_TEST_HANDLER_CORE_HH");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("#include \"aceSmartSoft.hh\"");
        _builder.newLine();
        _builder.newLine();
        Functions.Function1 _function = it -> it.getName();
        List _sortBy = IterableExtensions.sortBy((Iterable)ComponentDefinitionModelUtility.getAllCommObjects((ComponentPort)service), (Functions.Function1)_function);
        for (CommunicationObject obj : _sortBy) {
            _builder.append("#include <");
            CharSequence _userClassHeaderFileNameFQN = this._commObjectGenHelpers.getUserClassHeaderFileNameFQN(obj);
            _builder.append((Object)_userClassHeaderFileNameFQN);
            _builder.append(">");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("class ");
        String _nameClass = this._componentGenHelpers.nameClass((AbstractComponentElement)service);
        _builder.append(_nameClass);
        _builder.append("EventTestHandlerCore : public SmartACE::EventTestHandler<");
        CharSequence _commObjectCppList = this._componentGenHelpers.getCommObjectCppList((ComponentPort)service, (Boolean)true);
        _builder.append((Object)_commObjectCppList);
        _builder.append(">");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("};");
        _builder.newLine();
        _builder.append("#endif");
        _builder.newLine();
        return _builder;
    }

    public CharSequence HandlerUserHeaderFileContent(OutputPort service) {
        StringConcatenation _builder = new StringConcatenation();
        String _copyrightWriteOnce = this._copyrightHelpers.getCopyrightWriteOnce();
        _builder.append(_copyrightWriteOnce);
        _builder.newLineIfNotEmpty();
        _builder.append("#ifndef _");
        String _upperCase = service.getName().toUpperCase();
        _builder.append(_upperCase);
        _builder.append("_EVENT_TEST_HANDLER_USER_HH");
        _builder.newLineIfNotEmpty();
        _builder.append("#define _");
        String _upperCase_1 = service.getName().toUpperCase();
        _builder.append(_upperCase_1);
        _builder.append("_EVENT_TEST_HANDLER_USER_HH");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("#include \"");
        String _EventTestHandlerCoreHeaderFileName = this.EventTestHandlerCoreHeaderFileName((ComponentPort)service);
        _builder.append(_EventTestHandlerCoreHeaderFileName);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("class ");
        String _nameClass = this._componentGenHelpers.nameClass((AbstractComponentElement)service);
        _builder.append(_nameClass);
        _builder.append("EventTestHandler : public ");
        String _nameClass_1 = this._componentGenHelpers.nameClass((AbstractComponentElement)service);
        _builder.append(_nameClass_1);
        _builder.append("EventTestHandlerCore");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("public:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("virtual bool testEvent(");
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _fullyQualifiedNameCpp = this._commObjectGenHelpers.getFullyQualifiedNameCpp(this._componentGenHelpers.getCommunicationObjects((ComponentPort)service).get("Activation"));
        _builder.append((Object)_fullyQualifiedNameCpp, "\t\t");
        _builder.append(" &p,");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        CharSequence _fullyQualifiedNameCpp_1 = this._commObjectGenHelpers.getFullyQualifiedNameCpp(this._componentGenHelpers.getCommunicationObjects((ComponentPort)service).get("Event"));
        _builder.append((Object)_fullyQualifiedNameCpp_1, "\t\t");
        _builder.append(" &r,");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("const ");
        CharSequence _fullyQualifiedNameCpp_2 = this._commObjectGenHelpers.getFullyQualifiedNameCpp(this._componentGenHelpers.getCommunicationObjects((ComponentPort)service).get("EventState"));
        _builder.append((Object)_fullyQualifiedNameCpp_2, "\t\t");
        _builder.append(" &s");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(") throw();");
        _builder.newLine();
        _builder.append("};");
        _builder.newLine();
        _builder.append("#endif");
        _builder.newLine();
        return _builder;
    }

    public CharSequence HandlerUserSourceFileContent(OutputPort service) {
        StringConcatenation _builder = new StringConcatenation();
        String _copyrightWriteOnce = this._copyrightHelpers.getCopyrightWriteOnce();
        _builder.append(_copyrightWriteOnce);
        _builder.newLineIfNotEmpty();
        _builder.append("#include \"");
        String _EventTestHandlerUserHeaderFileName = this.EventTestHandlerUserHeaderFileName((ComponentPort)service);
        _builder.append(_EventTestHandlerUserHeaderFileName);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("bool ");
        String _nameClass = this._componentGenHelpers.nameClass((AbstractComponentElement)service);
        _builder.append(_nameClass);
        _builder.append("EventTestHandler::testEvent(");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _fullyQualifiedNameCpp = this._commObjectGenHelpers.getFullyQualifiedNameCpp(this._componentGenHelpers.getCommunicationObjects((ComponentPort)service).get("Activation"));
        _builder.append((Object)_fullyQualifiedNameCpp, "\t");
        _builder.append(" &p,");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _fullyQualifiedNameCpp_1 = this._commObjectGenHelpers.getFullyQualifiedNameCpp(this._componentGenHelpers.getCommunicationObjects((ComponentPort)service).get("Event"));
        _builder.append((Object)_fullyQualifiedNameCpp_1, "\t");
        _builder.append(" &r,");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("const ");
        CharSequence _fullyQualifiedNameCpp_2 = this._commObjectGenHelpers.getFullyQualifiedNameCpp(this._componentGenHelpers.getCommunicationObjects((ComponentPort)service).get("EventState"));
        _builder.append((Object)_fullyQualifiedNameCpp_2, "\t");
        _builder.append(" &s");
        _builder.newLineIfNotEmpty();
        _builder.append(") throw() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// fire all events (without filtering) in the default implementation");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// implement your own (specific) event-filtering code using the event-parameter as input");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// true means that the current event will be fired to the according client");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// false means that the current event is ignored (it will not be communicated to the according client)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return true;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }
}

